package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 任务执行情况表
 *
 * @author zhangye
 * @since 2018-02-26 10:42:16
 */
@Data
@TableName("com_task_implement")
public class ComTaskImplement extends BaseEntity<ComTaskImplement> {
    private static final long serialVersionUID = 113670352L;

    /**
     * 任务执行情况ID
     */
    @ApiModelProperty(value = "任务执行情况ID")
    private Long taskImplementId;

    /**
     * 星期几
     */
    @ApiModelProperty(value = "星期几")
    private int weekDay;

    /**
     * 日期
     */
    @ApiModelProperty(value = "日期")
    private Date dates;

    /**
     * 是否休息
     */
    @ApiModelProperty(value = "是否休息")
    private String isRest;


    /**
     * 上班出勤状态
     */
    @ApiModelProperty(value = "上班出勤状态")
    private String attendStatus;

    /**
     * 上班打卡时间
     */
    @ApiModelProperty(value = "上班打卡时间")
    @DateTimeFormat(pattern = "HH:mm:ss")
    private Date onClockInTime;


    /**
     * 出勤类型
     */
    @ApiModelProperty(value = "出勤类型")
    private String attendType;

    /**
     * 任务ID
     */
    @ApiModelProperty(value = "任务ID")
    private Long comTaskId;

    /**
     * 企业ID
     */
    @ApiModelProperty(value = "企业ID")
    private Long comId;

    /**
     * 人员ID
     */
    @ApiModelProperty(value = "人员ID")
    private Long perId;

    /**
     * 班次ID
     */
    @ApiModelProperty(value = "班次ID")
    private Long shiftId;

    /**
     * 班次规则ID
     */
    @ApiModelProperty(value = "班次规则ID")
    private Long shiftRuleId;

    /**
     * 下班出勤状态
     */
    @ApiModelProperty(value = "下班出勤状态")
    private String offAttendStatus;

    /**
     * 下班打卡时间
     */
    @ApiModelProperty(value = "下班打卡时间")
    @DateTimeFormat(pattern = "HH:mm:ss")
    private Date offClockInTime;


    @JsonSerialize(using = ToStringSerializer.class)
    public Long getTaskImplementId() {
        return taskImplementId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getComTaskId() {
        return comTaskId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getPerId() {
        return perId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getShiftId() {
        return shiftId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    public Long getShiftRuleId() {
        return shiftRuleId;
    }

}