package com.bcxin.oa.old.dto.app;

import com.bcxin.oa.old.entity.task.PerAttendCardRecord;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 考勤打卡记录DTO
 *
 * @author wangjianchi
 * @version 1.0
 */
@Data
public class AppPerAttendCardRecordDTO extends PerAttendCardRecord {
	/**
	 * 班次打卡日期
	 */
	@NotNull(message = "班次打卡日期不能为空")
	@ApiModelProperty(value = "班次打卡日期")
	private Date shiftRuleClockDate;

	@ApiModelProperty(value = "查询月份，例如：2018-03")
	private String month;
	/**
	 * 打卡日期
	 */
	@JsonFormat(pattern = "HH:mm:ss")
	@ApiModelProperty(value = "打卡日期")
	private Date clockInDate;
}
