package com.bcxin.oa.old.dto.app;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * APP考勤轮次
 * 
 * @author zhangye
 *
 */
public class AppComTaskSmallShiftDTO {

	/**
	 * 班次ID
	 */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;

	/**
	 * 班次规则ID
	 */
	@ApiModelProperty(value = "班次规则ID")
	private Long shiftRuleId;

	/**
	 * 轮次ID
	 */
	@ApiModelProperty(value = "轮次ID")
	private Long smallShiftId;

	/**
	 * 轮次状态 (1：已完成，2：可签到，3：可下班，4：未开始)
	 */
	@ApiModelProperty(value = "轮次状态")
	private int smallShiftType;
	/**
	 * 签到日期
	 */
	@ApiModelProperty(value = "上班打卡日期")
	private String clockInDate;
	/**
	 * 上班打卡日期
	 */
	@ApiModelProperty(value = "签到时间")
	private String signInTime;

	/**
	 * 下班打卡日期
	 */
	@ApiModelProperty(value = "下班打卡日期")
	private String clockOutDate;

	/**
	 * 签退时间
	 */
	@ApiModelProperty(value = "签退时间")
	private String signOutTime;

	/**
	 * 任务日期
	 */
	@ApiModelProperty(value = "任务日期")
	private Date dates;

	/**
	 * 班次开始时间
	 */
	@ApiModelProperty(value = "班次开始时间")
	private String startTime;

	/**
	 * 班次结束时间
	 */
	@ApiModelProperty(value = "班次结束时间")
	private String endTime;

	/**
	 * 签到状态(1:正常，2：迟到，5：漏打卡，7：请假)
	 */
	@ApiModelProperty(value = "签到状态")
	private Integer signInStatus;

	/**
	 * 签退状态（1:正常，3：早退，5：漏打卡，7：请假）
	 */
	@ApiModelProperty(value = "签退状态")
	private Integer signOutStatus;

	/**
	 * 是否要补签上班打卡YES,NO
	 */
	@ApiModelProperty(value = "是否要补签")
	private boolean requestSignIn;

	/**
	 * 是否要补签下班打卡YES,NO
	 */
	@ApiModelProperty(value = "是否要补签")
	private boolean requestSignOut;

	/**
	 * 班次开始日期
	 */
	@ApiModelProperty(value = "班次开始日期")
	private Date startDate;
	/**
	 * 班次结束日期
	 */
	@ApiModelProperty(value = "班次结束日期")
	private Date endDate;

	/** 可上班打卡日期 */
	@ApiModelProperty(value = "可上班打卡日期")
	private Date startWorkDate;

	/** 下班最迟打卡日期 */
	@ApiModelProperty(value = "下班最迟打卡日期")
	private Date endWorkDate;

	/** 打卡时限开关 */
	@ApiModelProperty(value = "打卡时限开关")
	private String clockLimitSwitch;

	/** 打卡时限开关 */
	@ApiModelProperty(value = "是否次日")
	private String isEndNextDay;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftRuleId() {
		return shiftRuleId;
	}

	public void setShiftRuleId(Long shiftRuleId) {
		this.shiftRuleId = shiftRuleId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getSmallShiftId() {
		return smallShiftId;
	}

	public void setSmallShiftId(Long smallShiftId) {
		this.smallShiftId = smallShiftId;
	}

	public int getSmallShiftType() {
		return smallShiftType;
	}

	public void setSmallShiftType(int smallShiftType) {
		this.smallShiftType = smallShiftType;
	}

	public String getSignInTime() {
		return signInTime;
	}

	public void setSignInTime(String signInTime) {
		this.signInTime = signInTime;
	}

	public String getSignOutTime() {
		return signOutTime;
	}

	public void setSignOutTime(String signOutTime) {
		this.signOutTime = signOutTime;
	}

	public String getStartTime() {
		return startTime;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public Integer getSignInStatus() {
		return signInStatus;
	}

	public void setSignInStatus(Integer signInStatus) {
		this.signInStatus = signInStatus;
	}

	public Integer getSignOutStatus() {
		return signOutStatus;
	}

	public void setSignOutStatus(Integer signOutStatus) {
		this.signOutStatus = signOutStatus;
	}

	public boolean isRequestSignIn() {
		return requestSignIn;
	}

	public void setRequestSignIn(boolean requestSignIn) {
		this.requestSignIn = requestSignIn;
	}

	public boolean isRequestSignOut() {
		return requestSignOut;
	}

	public void setRequestSignOut(boolean requestSignOut) {
		this.requestSignOut = requestSignOut;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getStartWorkDate() {
		return startWorkDate;
	}

	public void setStartWorkDate(Date startWorkDate) {
		this.startWorkDate = startWorkDate;
	}

	public Date getEndWorkDate() {
		return endWorkDate;
	}

	public void setEndWorkDate(Date endWorkDate) {
		this.endWorkDate = endWorkDate;
	}

	public String getClockLimitSwitch() {
		return clockLimitSwitch;
	}

	public void setClockLimitSwitch(String clockLimitSwitch) {
		this.clockLimitSwitch = clockLimitSwitch;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}

	public void setShiftId(Long shiftId) {
		this.shiftId = shiftId;
	}

	public Date getDates() {
		return dates;
	}

	public void setDates(Date dates) {
		this.dates = dates;
	}

	public String getClockInDate() {
		return clockInDate;
	}

	public void setClockInDate(String clockInDate) {
		this.clockInDate = clockInDate;
	}

	public String getClockOutDate() {
		return clockOutDate;
	}

	public void setClockOutDate(String clockOutDate) {
		this.clockOutDate = clockOutDate;
	}

	public String getIsEndNextDay() {
		return isEndNextDay;
	}

	public void setIsEndNextDay(String isEndNextDay) {
		this.isEndNextDay = isEndNextDay;
	}

}
