package com.bcxin.oa.old.dto.app;

import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * APP任务
 *
 * @author zhangye
 * @since 2018-03-15 16:24:22
 */
@Data
public class AppComTaskDetailsDTO extends BaseEntity<AppComTaskDetailsDTO> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 49195933494526696L;
	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long taskId;
	/** 任务类型 ：1：周期，2：临时，3：紧急 */
	@ApiModelProperty(value = "任务类型")
	private String taskType;

	/** 出勤类型 ：1:固定，2：排班制，3：自由班 */
	@ApiModelProperty(value = "出勤类型")
	private String attendType;

	/** 任务名称 */
	@ApiModelProperty(value = "任务名称")
	private String taskName;

	/** 任务地址 */
	@ApiModelProperty(value = "任务地址")
	private String address;

	/** 任务地址经度 */
	@ApiModelProperty(value = "任务地址经度")
	private String longitude;

	/** 任务地址纬度 */
	@ApiModelProperty(value = "任务地址纬度")
	private String latitude;

	/** 执行范围（单位:米） */
	@ApiModelProperty(value = "执行范围（单位:米）")
	private Long scope;

	/** 当前任务状态：1:执行中,2:已完成,3:已结束,4:新任务,5:即将进行，6：已取消 */
	private String currentTaskStatus;// 1:正在执行,2:已完成,3:已结束,4:新任务,5:即将进行

	/** 任务内容 */
	@ApiModelProperty(value = "任务内容")
	private String taskDetail;
	/**
	 * 人员ID
	 */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/** 任务结束状态(0:未结束，1：已结束) */
	@ApiModelProperty(value = "任务结束状态")
	private String taskOverStatus;

	/** 任务考勤列表 */
	@ApiModelProperty(value = "任务考勤列表")
	private AppComTaskCalendarDTO calendarData;

	/**
	 * 当前选择年月日
	 */
	@ApiModelProperty(value = "当前选择日期")
	private String selectDate;

	/** 任务开始结束时间XXXX年XX月XX日-XXXX年XX月XX日(普通任务）；紧急任务（发布）：XXXX年XX月XX日 HH:mm */
	@ApiModelProperty(value = "任务开始结束时间")
	private String taskDate;

	/**
	 * 任务成员
	 */
	@ApiModelProperty(value = "任务成员")
	private List<AppComTaskInsidePushDTO> persons = new ArrayList<AppComTaskInsidePushDTO>();

	/** 任务负责人ID */
	@ApiModelProperty(value = "任务负责人ID")
	private Long chargePerId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getChargePerId() {
		return chargePerId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getTaskId() {
		return taskId;
	}

}
