package com.bcxin.oa.old.controller.system;

import cn.hutool.json.JSONUtil;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.dto.ComSocialInsSchemeDTO;
import com.bcxin.oa.old.dto.PaymentSettingDTO;
import com.bcxin.oa.old.service.system.MedicalSocialRecService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.log4j.Log4j;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 企业基础信息表 前端控制器
 * </p>
 *
 * @author ctj
 * @since 2017-12-11
 */
@Slf4j
@RestController
@RequestMapping("/enterprise/ins/payment-setting")
@Api(tags = { "" }, description = "医社保缴交设置") // tag中文会影响路径
public class PaymentSettingController extends BaseController {

	@Autowired
	private MedicalSocialRecService medicalSocialRecService;

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保缴交设置", title = "添加人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/add-person")
	@ApiOperation(value = "添加人员，插入关系数据")
	public Result addPerson(PaymentSettingDTO dto) {
		log.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(dto));
		return medicalSocialRecService.addPerson(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保缴交设置", title = "移除人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/del-person")
	@ApiOperation(value = "移除人员，删除关系数据")
	public Result delPerson(PaymentSettingDTO dto) {
		log.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(dto));
		return medicalSocialRecService.delPerson(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保缴交设置", title = "人员选择列表分页", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/multisel-person-page")
	@ApiOperation(value = "人员选择列表分页，根据企业ID和缴交方案ID查询出本公司的所有人员")
	public Result multiselPersonPage(ComSocialInsSchemeDTO dto) throws BusinessException {
		log.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(dto));
		return medicalSocialRecService.multiselPersonPage(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保缴交设置", title = "缴交方案新增保存", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-payment-setting")
	@ApiOperation(value = "缴交方案新增保存，一对多5险")
	public Result savePaymentSetting(ComSocialInsSchemeDTO dto) throws BusinessException {
		log.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(dto));
		return medicalSocialRecService.savePaymentSetting(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保缴交设置", title = "缴交方案详情查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-payment-setting-by-id")
	@ApiOperation(value = "缴交方案详情查询，通过缴交方案ID")
	public Result getPaymentSettingById(ComSocialInsSchemeDTO dto) {
		log.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(dto));
		return medicalSocialRecService.getPaymentSettingById(dto).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "医社保缴交设置", title = "某个缴交方案的已选人员列表分页", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/get-selected-person-page")
	@ApiOperation(value = "某个缴交方案的已选人员列表分页,通过缴交方案ID")
	public Result getSelectedPersonPage(ComSocialInsSchemeDTO dto) {
		log.info(">>>>>>>>获得参数" + JSONUtil.toJsonStr(dto));
		return medicalSocialRecService.getSelectedPersonPage(dto).setBack(getRequest());
	}

}
