package com.bcxin.oa.old.controller.htmlfive.task;

import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.html.HtmlComTaskService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.dto.user.CurrentUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 任务管理
 *
 * @author zhangye
 */
@RestController
@RequestMapping("/task/html/task")
@Api(tags = { "" }, description = "APP_html5_任务")
public class HtmlComTaskController extends BaseController {

	@Autowired
	private HtmlComTaskService htmlComTaskService;


	/**
	 * 发布外勤任务
	 *
	 * @param paramDTO
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/publish-task")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "发布外勤任务", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "发布外勤任务")
	public Result publishTask(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.publishTask(paramDTO);
		return result.setBack(getRequest());
	}

	/**
	 * 修改任务信息
	 *
	 * @param paramDTO
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/update-task")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "修改任务信息", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "修改任务信息")
	public Result updateTask(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.updateTask(paramDTO);
		return result.setBack(getRequest());
	}

	/**
	 * 修改周期信息
	 *
	 * @param paramDTO
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/update-cycle")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "修改周期信息", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "修改周期信息")
	public Result updateCycle(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.updateCycle(paramDTO);
		return result.setBack(getRequest());
	}

	/**
	 * 修改班次信息
	 *
	 * @param paramDTO
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/update-shift")
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "任务管理", title = "修改班次信息", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "修改班次信息")
	public Result updateShift(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.updateShift(paramDTO);
		return result.setBack(getRequest());
	}

	/**
	 * 外勤任务列表（分页）
	 * @return Result
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "外勤任务列表我创建的（分页）", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/task-create-list")
	@ApiOperation(value="外勤任务列表我创建的", notes="外勤任务列表我创建的（分页）")
	public Result taskCreateList(ComTaskDto dto, HttpServletRequest request) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		dto.setPerId(currentUser.getPerId());
		return htmlComTaskService.listTaskCreatePage(dto).setBack(request);
	}

	/**
	 * 外勤任务列表（分页）
	 * @return Result
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "外勤任务列表我负责的（分页）", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/task-charge-list")
	@ApiOperation(value="外勤任务列表我负责的", notes="外勤任务列表我负责的（分页）")
	public Result taskChargeList(ComTaskDto dto, HttpServletRequest request) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		dto.setPerId(currentUser.getPerId());
		return htmlComTaskService.listTaskChargePage(dto).setBack(request);
	}

	/**
	 * 外勤详情
	 * @return Result
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "外勤详情", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/task-detail")
	@ApiOperation(value="外勤详情", notes="外勤详情")
	public Result taskDetail(ParamDTO paramDTO, HttpServletRequest request) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return htmlComTaskService.taskDetail(paramDTO).setBack(request);
	}


	/**
	 * 周期详情
	 * @return Result
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "周期详情", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/cycle-detail")
	@ApiOperation(value="周期详情", notes="周期详情")
	public Result cycleDetail(ParamDTO paramDTO, HttpServletRequest request) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return htmlComTaskService.cycleDetail(paramDTO).setBack(request);
	}


	/**
	 * 取消外勤任务（废弃）
	 * @return Result
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "取消外勤任务", systemType = Log.SYSTEMTYPE_PHONE)
	@PostMapping(value = "/cancel-task")
	@ApiOperation(value="取消外勤任务", notes="取消外勤任务")
	public Result cancelTask(ParamDTO paramDTO, HttpServletRequest request) {
		return htmlComTaskService.cancelTask(paramDTO).setBack(request);
	}

	/**
	 * 排班日历（总览）
	 *
	 * @param paramDTO
	 * @return
	 * @throws BusinessException
	 */
	@PostMapping(value = "/task-calendar-general")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "排班日历（总览）", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "排班日历（总览）")
	public Result taskCalendarGeneral(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.taskCalendarGeneral(paramDTO);
		return result.setBack(getRequest());
	}


	/**
	 * 排班日历（总览）
	 * 点击某一天，查找当天的班次，以及班次对应的人员
	 * @param paramDTO
	 * @return
	 */
	@PostMapping(value = "/task-day-shift")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "排班日历（总览）", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "排班日历（总览）")
	public Result taskDayShift(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.taskDayShift(paramDTO);
		return result.setBack(getRequest());
	}


	/**
	 * 排班日历（个人）
	 * 点击某个月，某个人，查找当月的所有班次
	 * @param paramDTO
	 * @return
	 */
	@PostMapping(value = "/task-per-calendar-general")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "排班日历（个人）", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "排班日历（个人）")
	public Result taskPerCalendarGeneral(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.taskPerCalendarGeneral(paramDTO);
		return result.setBack(getRequest());
	}

	/**
	 * 排班日历（个人） 查找任务对应的班次
	 * @param paramDTO
	 * @return
	 */
	@PostMapping(value = "/task-shift")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "排班日历（个人）", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "排班日历（个人）")
	public Result taskShift(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.taskShift(paramDTO);
		return result.setBack(getRequest());
	}


	/**
	 * 个人当天排班（校验）（废弃）
	 * @param paramDTO
	 * @return
	 */
	@PostMapping(value = "/validate-per-shift")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "个人当天排班（校验）", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "个人当天排班（校验）")
	public Result validatePerShift(ParamDTO paramDTO) throws BusinessException {
		Result result = htmlComTaskService.validatePerShift(paramDTO);
		return result.setBack(getRequest());
	}


	/**
	 * 个人当天排班（插入）
	 * @param paramDTO
	 * @return
	 */
	@PostMapping(value = "/per-shift")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务管理", title = "个人当天排班（插入）", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "个人当天排班（插入）")
	public Result perShiftInDB(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.perShiftInDB(paramDTO);
		return result.setBack(getRequest());
	}


	/**
	 * 获得负责人
	 * @param paramDTO
	 * @return
	 */
	@PostMapping(value = "/per-charge-list")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "获得负责人列表", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "获得负责人列表")
	public Result perChargeList(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.taskChargePer(paramDTO);
		return result.setBack(getRequest());
	}

	/**
	 * 获得任务组员
	 * @param paramDTO
	 * @return
	 */
	@PostMapping(value = "/perList")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "任务管理", title = "组员列表", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "组员列表")
	public Result perList(ParamDTO paramDTO) throws BusinessException {
		Result result = htmlComTaskService.taskPer(paramDTO);
		return result.setBack(getRequest());
	}


	/**
	 * 移除组员(废弃)
	 * @param paramDTO
	 * @return
	 */
	@PostMapping(value = "/remove-per")
	@Log(operation = Log.OPERA_TYPE_DEL, modle = "任务管理", title = "移除组员", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "移除组员")
	public Result removePer(ParamDTO paramDTO) throws BusinessException {
		Result result = htmlComTaskService.removePer(paramDTO);
		return result.setBack(getRequest());
	}

	/**
	 * 增加组员(废弃)
	 * @param paramDTO
	 * @return
	 */
	@PostMapping(value = "/add-per")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务管理", title = "增加组员", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "增加组员")
	public Result addPer(ParamDTO paramDTO) throws BusinessException {
		Result result = htmlComTaskService.addPer(paramDTO);
		return result.setBack(getRequest());
	}


	/**
	 * 任务月度出勤情况
	 * @param paramDTO
	 * @return
	 * @author llc
	 * @date 2019-02-22
	 * @return
	 */
	@PostMapping(value = "/get-task-month-attend-info")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务管理", title = "任务月度出勤情况", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "任务月度出勤情况")
	public Result getTaskMonthAttendInfo(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.getTaskMonthAttendInfo(paramDTO);
		return result.setBack(getRequest());
	}


	/**
	 * 获取某天任务出勤人员
	 * @param paramDTO
	 * @return
	 * @author llc
	 * @date 2019-02-25
	 * @return
	 */
	@PostMapping(value = "/get-task-attend-per-date")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "任务管理", title = "获取某天任务出勤人员", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "任务管理", notes = "获取某天任务出勤人员")
	public Result getTaskAttendPerDate(ParamDTO paramDTO) throws BusinessException {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		Result result = htmlComTaskService.getTaskAttendPerDate(paramDTO);
		return result.setBack(getRequest());
	}
}
