
package com.bcxin.oa.old.controller.attend;

import com.bcxin.oa.old.entity.task.ComAttendGroupFixed;
import com.bcxin.oa.old.dto.ComAttendGroupFixedDTO;
import com.bcxin.oa.old.dto.ComAttendGroupFixedTempDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.attend.ComAttendGroupFixedService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @Title：考勤固定班制管理
 * @Package：com.bcx.platform.controller @Description：
 * @author：zhangye
 */
@RestController
@RequestMapping("/task/attendance/comattendgroupfixed")
@Api(tags = { "" }, description = "考勤固定班制管理")
public class ComAttendGroupFixedController extends BaseController {

	@Resource
	private ComAttendGroupFixedService comAttendGroupFixedService;

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "考勤固定班制管理", title = "考勤固定班制详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-detail")
	@ApiOperation(value = "考勤固定班制详情", httpMethod = "GET", notes = "考勤固定班制详情", response = ComAttendGroupFixed.class)
	public Result getDetail(ComAttendGroupFixedDTO comAttendGroupFixed) throws BusinessException {
		return comAttendGroupFixedService.getDetail(comAttendGroupFixed).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤固定班制管理", title = "保存", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "保存考勤固定班制", httpMethod = "POST", notes = "保存考勤固定班制", response = ComAttendGroupFixed.class)
	@PostMapping(value = "save")
	public Result save(ComAttendGroupFixedTempDTO comAttendGroupFixedTempDTO) throws BusinessException {
		return comAttendGroupFixedService.save(comAttendGroupFixedTempDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤固定班制管理", title = "修改考勤固定班制", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "update")
	@ApiOperation(value = "修改考勤固定班制", httpMethod = "POST", notes = "修改考勤固定班制", response = ComAttendGroupFixed.class)
	public Result update(ComAttendGroupFixedTempDTO comAttendGroupFixedTempDTO) throws BusinessException {
		return comAttendGroupFixedService.update(comAttendGroupFixedTempDTO).setBack(getRequest());
	}

	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "考勤固定班制管理", title = "获取周一到周日模板", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get-add-temp")
	@ApiOperation(value = "获取周一到周日模板", httpMethod = "GET", notes = "获取周一到周日模板", response = ComAttendGroupFixed.class)
	public Result getAddTemp(ComAttendGroupFixedDTO comAttendGroupFixed) throws BusinessException {
		return comAttendGroupFixedService.getAddTemp(comAttendGroupFixed).setBack(getRequest());
	}
}
