package com.bcxin.oa.old.controller.app.task;

import com.bcxin.oa.old.entity.task.ComTaskImplement;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.app.AppComTaskImplementDto;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.task.app.AppComTaskTrackService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.dto.user.CurrentUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/task/app/apptrack")
@Api(tags = { "" }, description = "任务轨迹")
public class AppTrackController extends BaseController {

	@Autowired
	private AppComTaskTrackService appComTaskTrackService;

	/**
	 * APP-查询任务轨迹
	 *
	 * @param appComTaskImplementDto
	 * @return
	 * @author zhangye
	 * @date 2018/03/14
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "APP-查询任务轨迹", title = "查询任务轨迹", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "APP-查询任务轨迹", httpMethod = "POST", notes = "查询任务轨迹", response = ComTaskImplement.class)
	@PostMapping(value = "/list-task-track")
	public Result listTaskTrack(AppComTaskImplementDto appComTaskImplementDto) throws BusinessException {
		AppComTaskImplementDto appComTaskImplementDtoParam = Result.getDecodeData(appComTaskImplementDto.getAppData(),
				AppComTaskImplementDto.class);
		ObjectUtils.appCopyProperties(appComTaskImplementDtoParam, appComTaskImplementDto);
		appComTaskImplementDtoParam.setSessionId(appComTaskImplementDto.getSessionId());
		Result result = appComTaskTrackService.listTaskTrack(appComTaskImplementDtoParam).setBack(getRequest());
		result.setData(Result.setEncodeData(result.getData()));
		return result;
	}

	/**
	 * APP-保存任务轨迹
	 *
	 * @param appComTaskImplementDto
	 * @return
	 * @author zhangye
	 * @date 2018/03/20
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "APP-保存任务轨迹", title = "保存任务轨迹", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "APP-保存任务轨迹", httpMethod = "POST", notes = "保存任务轨迹", response = ComTaskDto.class)
	@PostMapping(value = "/save-task-track")
	public Result saveTaskTrack(AppComTaskImplementDto appComTaskImplementDto) throws BusinessException {
		AppComTaskImplementDto appComTaskImplementDtoParam = Result.getDecodeData(appComTaskImplementDto.getAppData(),
				AppComTaskImplementDto.class);
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		ObjectUtils.appCopyProperties(appComTaskImplementDtoParam, appComTaskImplementDto);
		appComTaskImplementDtoParam.setPerId(currentUser.getPerId());
		appComTaskImplementDtoParam.setSessionId(appComTaskImplementDto.getSessionId());
		Result result = appComTaskTrackService.saveTaskTrack(appComTaskImplementDtoParam).setBack(getRequest());
		result.setData(Result.setEncodeData(result.getData()));
		return result;
	}

	/**
	 * APP-检查地区是否开通任务轨迹
	 *
	 * @param appComTaskImplementDto
	 * @return
	 * @author zhangye
	 * @date 2018/09/21
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "APP-检查地区是否开通任务轨迹", title = "检查地区是否开通任务轨迹", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "APP-检查地区是否开通任务轨迹", httpMethod = "POST", notes = "检查地区是否开通任务轨迹", response = ComTaskDto.class)
	@PostMapping(value = "/check-task-track")
	public Result checkTaskTrack(AppComTaskImplementDto appComTaskImplementDto) throws BusinessException {
		AppComTaskImplementDto appComTaskImplementDtoParam = Result.getDecodeData(appComTaskImplementDto.getAppData(),
				AppComTaskImplementDto.class);
		ObjectUtils.appCopyProperties(appComTaskImplementDtoParam, appComTaskImplementDto);
		Result result = appComTaskTrackService.checkTaskTrack(appComTaskImplementDtoParam).setBack(getRequest());
		result.setData(Result.setEncodeData(result.getData()));
		return result;
	}

}
