package com.bcxin.oa.old.common.utils;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.Set;

/**
 * @author：wangcy @date：2017/12/20 0020 13:30
 * @description：javaBean 约束
 *                       <p>
 *                       约束注解说明
 * @Null 验证对象是否为空
 * @NotNull 验证对象是否为非空
 * @AssertTrue 验证 Boolean 对象是否为 true
 * @AssertFalse 验证 Boolean 对象是否为 false
 * @Min 验证 Number 和 String 对象是否大等于指定的值
 * @Max 验证 Number 和 String 对象是否小等于指定的值
 * @DecimalMin 验证 Number 和 String 对象是否大等于指定的值，小数存在精度
 * @DecimalMax 验证 Number 和 String 对象是否小等于指定的值，小数存在精度
 * @Size 验证对象（Array,Collection,Map,String）长度是否在给定的范围之内
 * @Digits 验证 Number 和 String 的构成是否合法
 * @Past 验证 Date 和 Calendar 对象是否在当前时间之前
 * @Future 验证 Date 和 Calendar 对象是否在当前时间之后
 * @Pattern 验证 String 对象是否符合正则表达式的规则
 */
public class ValidsUtils {

	/**
	 * @Author: wangcy
	 * @Description: 判断前台传过来的是实体是否不合法
	 * @Date: 2017/12/20 0020 13:45
	 */

	public static String judgebean(Object data) {
		StringBuffer stringBuffer = new StringBuffer();
		ValidatorFactory vf = Validation.buildDefaultValidatorFactory();
		Validator validator = vf.getValidator();
		Set<ConstraintViolation<Object>> validate = validator.validate(data);
		for (ConstraintViolation<Object> cv : validate) {
			System.out.println(cv.getMessage() + "(" + cv.getPropertyPath() + ")" + "-->" + cv.getInvalidValue());
			stringBuffer.append(cv.getMessage() + ",");
		}
		return stringBuffer.toString().endsWith(",")
				? stringBuffer.toString().substring(0, stringBuffer.toString().length() - 1) : stringBuffer.toString();
	}
}
