"use strict";

// 为了兼容webpack hooks的新旧两种写法
// 旧版本： compilation.plugin('additional-assets',callback=>{});
// 新版本： compilation.hooks.additionalAssets.tapAsync('随意写的一个名字', callback=>{});
var _require = require('./constant'),
    HOOKS = _require.HOOKS;

var _require2 = require('./log'),
    error = _require2.error; // 将驼峰改写成连字符分隔的字符串


var camelToDash = function camelToDash(camel) {
  return camel.replace(/([A-Z])/g, '-$1').toLowerCase();
};

var tapHook = function tapHook(source, hookName, handler) {
  if (source.hooks) {
    // 例如：compilation.hooks.additionalAssets.tapAsync('随意写的一个名字', callback=>{});
    // additionalAssets
    var hook = source.hooks[hookName]; // 以防旧版本的webpack，不支持新版的hook

    if (!hook) {
      return;
    } // additionalAssets.tapAsync


    hook[HOOKS[hookName]]('build-statistics-webpack-plugin', handler);
    return;
  }

  var dashedHookName = camelToDash(hookName);

  try {
    // 使用旧版本的接口，暂时没有办法检查是否支持该hook，如果hook不存在会抛异常
    source.plugin(dashedHookName, handler);
  } catch (err) {
    error('不支持名为 %s 的插件：%s', dashedHookName, err.stack);
  }
};

module.exports = tapHook;