### build-statistics-webpack-plugin
  
`BuildStatisticsPlugin` 是一个webpack插件，用于上报webpack各阶段的耗时信息。  
  
#### 1. 用法
  
在`webpack.config.js`中配置，  
```
const BuildStatisticsPlugin = require('build-statistics-webpack-plugin');
...
module.exports = {
    ...,
    plugins: [
        ...,
        new BuildStatisticsPlugin({
            path: ...,  // 一个文件的绝对地址
        }),
    ],
};
```

#### 2. 文件内容

`BuildStatisticsPlugin`会自动向指定的`path`中写入统计数据。  
`webpack build`，`webpack watch`，以及`webpack-dev-server`的场景中，都会写入文件，  
值得注意的是，当监测到文件变更时，**不写**文件。  
  
文件内容是一个JSON，  
```
{
    hash: ...,
    stages: [
        {
            stage, 
            startTime, 
            endTime, 
            elpase
        },
        ...,
    ]
}
```

**（1）hash**
`hash`为webpack自带的[stats](https://webpack.js.org/configuration/stats/)中的`hash`字段。

**（2）stages**
`stages`是一个数组，其中保存了webpack构建过程中，各阶段的耗时信息。

`stage`表示阶段名：  
  
| stage | description | begin | end | 
| --- | --- | --- | --- |
| start | 准备阶段 | compiler.hooks.compile | compiler.hooks.compilation |
| load | 载入文件 | compiler.hooks.compilation | compilation.hooks.finishModules |
| assets | 代码生成 | compilation.hooks.finishModules | compilation.hooks.additionalAssets |
| uglify | 压缩 | compilation.hooks.additionalAssets | compilation.hooks.afterOptimizeChunkAssets |
| emit | 写文件 | compilation.hooks.afterOptimizeChunkAssets | compiler.hooks.done |
  
`startTime`，`endTime`为该阶段的开始和结束时间，  
`elapse`为该阶段耗时。  

### 3. 日志

插件内部使用了[debug](https://github.com/visionmedia/debug)，用来记录`trace`日志和`error`日志，  
命令行中传入以下[前置参数](https://www.gnu.org/software/bash/manual/bashref.html#Environment)，可以获取完整日志。例如，  
```
$ DEBUG=build-statistics-webpack-plugin* webpack
```
  
结果如下，  
```
build-statistics-webpack-plugin:trace 开始compile +0ms
build-statistics-webpack-plugin:trace 创建一个新的compilation +10ms
build-statistics-webpack-plugin:trace 开始载入文件 +0ms
build-statistics-webpack-plugin:trace 载入文件结束 +523ms
build-statistics-webpack-plugin:trace 生成目标文件名和文件内容 +38ms
build-statistics-webpack-plugin:trace 对文件内容进行压缩 +11ms
build-statistics-webpack-plugin:trace 完成 +4ms
build-statistics-webpack-plugin:trace 各事件发生的时刻：[{"event":"compiler.compile","timestamp":1542187628407},{"event":"compiler.compilation","timestamp":1542187628414},{"event":"compilation.finishModules","timestamp":1542187628937},{"event":"compilation.additionalAssets","timestamp":1542187628975},{"event":"compilation.afterOptimizeChunkAssets","timestamp":1542187628986},{"event":"compiler.done","timestamp":1542187628990}] +1ms
build-statistics-webpack-plugin:trace 各阶段耗时：[{"stage":"start","startTime":1542187628407,"endTime":1542187628414,"elapse":7},{"stage":"load","startTime":1542187628414,"endTime":1542187628937,"elapse":523},{"stage":"assets","startTime":1542187628937,"endTime":1542187628975,"elapse":38},{"stage":"uglify","startTime":1542187628975,"endTime":1542187628986,"elapse":11},{"stage":"emit","startTime":1542187628986,"endTime":1542187628990,"elapse":4}] +0ms
build-statistics-webpack-plugin:trace hash：16555666ef09ced98421 +12ms
build-statistics-webpack-plugin:trace 准备写文件 +0ms
build-statistics-webpack-plugin:trace 写入文件：***/1542187627983.json
```
