/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task.proerpties;

import java.io.Serializable;
import org.springframework.util.StringUtils;

public class HttpRegionSinkProperty
implements Serializable {
    private String regionIdPrefix;
    private String api;

    public static HttpRegionSinkProperty create(String regionIdPrefix, String api) {
        HttpRegionSinkProperty sinkProperty = new HttpRegionSinkProperty();
        sinkProperty.setApi(api);
        sinkProperty.setRegionIdPrefix(regionIdPrefix);
        return sinkProperty;
    }

    public static HttpRegionSinkProperty getRegionConfigProperty(String name, String value) {
        if (!StringUtils.hasLength((String)name)) {
            return null;
        }
        if (!name.startsWith("dispatch.region") || !name.contains("_")) {
            return null;
        }
        String regionPrefix = name.split("_")[1];
        return HttpRegionSinkProperty.create(regionPrefix, value);
    }

    public boolean IsMatchedApi(String regionId) {
        if (!StringUtils.hasLength((String)this.getRegionIdPrefix()) || !StringUtils.hasLength((String)regionId)) {
            return false;
        }
        return regionId.startsWith(this.getRegionIdPrefix());
    }

    public String getRegionIdPrefix() {
        return this.regionIdPrefix;
    }

    public String getApi() {
        return this.api;
    }

    public void setRegionIdPrefix(String regionIdPrefix) {
        this.regionIdPrefix = regionIdPrefix;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRegionSinkProperty)) {
            return false;
        }
        HttpRegionSinkProperty other = (HttpRegionSinkProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$regionIdPrefix = this.getRegionIdPrefix();
        String other$regionIdPrefix = other.getRegionIdPrefix();
        if (this$regionIdPrefix == null ? other$regionIdPrefix != null : !this$regionIdPrefix.equals(other$regionIdPrefix)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        return !(this$api == null ? other$api != null : !this$api.equals(other$api));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpRegionSinkProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $regionIdPrefix = this.getRegionIdPrefix();
        result = result * 59 + ($regionIdPrefix == null ? 43 : $regionIdPrefix.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        return result;
    }

    public String toString() {
        return "HttpRegionSinkProperty(regionIdPrefix=" + this.getRegionIdPrefix() + ", api=" + this.getApi() + ")";
    }
}

