/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task;

import com.bcxin.event.job.core.domain.JedisPoolFactory;
import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import com.bcxin.flink.cdc.kafka.source.task.cdcs.BinlogOffsetValue;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.CdcDatabaseSourceProperty;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class StartupOptionUtil {
    private static final Logger logger = LoggerFactory.getLogger(StartupOptionUtil.class);
    public static final String REDIS_MS_BINLOG_FILE_NAME_OFFSET = "mysql:flink:checkpoints:cdc:redis_ms_binlog_file_name_offset_gt_ids";
    public static final String REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_FILE_NAME = "redis_ms_binlog_file_name_offset_file_name";
    public static final String REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_FILE_NAME_LAST_TABLE = "redis_ms_binlog_file_name_offset_file_name_last_table";
    public static final String REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_OFFSET_VALUE = "redis_ms_binlog_file_name_offset_offset_value";
    public static final String REDIS_MS_BINLOG_GT_IDS_VALUE = "redis_ms_binlog_gt_ids_value";

    public static StartupOptions calculateStartupOption(BinlogOffsetValue binlogOffsetValue) {
        return StartupOptions.latest();
    }

    public static BinlogOffsetValue getBinlogOffsetValue(RedisConfig redisConfig, CdcDatabaseSourceProperty databaseSourceProperty) {
        try (Jedis jedis = JedisPoolFactory.getNewJedisResource((RedisConfig)redisConfig);){
            String offset;
            Map offsetMap = jedis.hgetAll(REDIS_MS_BINLOG_FILE_NAME_OFFSET);
            if (offsetMap != null && StringUtils.isNumeric((CharSequence)(offset = (String)offsetMap.get(REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_OFFSET_VALUE)))) {
                long lastOffsetFromRedis = Long.parseLong(offset);
                String grIds = (String)offsetMap.get(REDIS_MS_BINLOG_GT_IDS_VALUE);
                BinlogOffsetValue offsetValue = BinlogOffsetValue.create((String)offsetMap.get(REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_FILE_NAME), lastOffsetFromRedis, grIds);
                logger.error("\u521d\u59cb\u5316-\u8bfb\u53d6\u5230\u7684Binlog\u4fe1\u606f\u4e3a:file={};pos={};", offsetMap.get(REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_FILE_NAME), (Object)lastOffsetFromRedis);
                BinlogOffsetValue binlogOffsetValue = offsetValue;
                return binlogOffsetValue;
            }
        }
        return null;
    }
}

