/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonNull;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkConstants {
    private static final Logger logger = LoggerFactory.getLogger(FlinkConstants.class);
    public static final Collection<String> DATETIME_FIELD_NAMES = Stream.of("LASTMODIFIED", "CREATED", "TIME", "DATE", "FZRQ").collect(Collectors.toList());

    public static Object formatValue(String nodeKey, Object nodeValue) {
        if (nodeValue == null || nodeValue instanceof BsonNull) {
            return null;
        }
        if (nodeValue instanceof BsonString) {
            String bsStr = ((BsonString)nodeValue).getValue();
            if (FlinkConstants.isDateTimeField(nodeKey) && (bsStr.contains("0000-00-00") || bsStr.contains("9999-"))) {
                return null;
            }
        }
        if (nodeValue instanceof BsonNumber) {
            try {
                if (FlinkConstants.isDateTimeField(nodeKey)) {
                    return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date(FlinkConstants.getTimeValue(nodeKey, ((BsonNumber)nodeValue).longValue())));
                }
                return nodeValue;
            }
            catch (Exception ex) {
                logger.error("formatValue.key={};value={};\u8f6c\u6362\u51fa\u9519=%s;\u5c1d\u8bd5\u8f6c\u4e3aDouble", new Object[]{nodeKey, nodeValue, ex});
                ex.printStackTrace();
            }
        }
        return nodeValue;
    }

    private static long getTimeValue(String key, Object value) {
        try {
            return Long.parseLong(String.valueOf(value));
        }
        catch (Exception ex) {
            logger.error("key={};value={};\u8f6c\u6362\u51fa\u9519=%s;\u5c1d\u8bd5\u8f6c\u4e3aDouble", new Object[]{key, value, ex});
            return (long)Double.parseDouble(String.valueOf(value));
        }
    }

    public static boolean isDateTimeField(String nodeKey) {
        return DATETIME_FIELD_NAMES.stream().anyMatch(ix -> nodeKey.toUpperCase().contains((CharSequence)ix));
    }
}

