import axios from "axios";

// 创建axios实例
const instance = axios.create({
  // axios中请求配置有baseURL选项，表示请求URL公共部分
  baseURL: process.env.VUE_APP_API_ROOT,
  timeout: 60000,
});

instance.interceptors.request.use(
  async (config) => {
    // config.headers["skip-ip-validation"] = 1;
    let dispatchToken = localStorage.getItem("dispatchToken");
    if (dispatchToken) {
      config.headers.dispatchToken = dispatchToken;
    }
    return config;
  },
  (error) => {
    return Promise.reject(error);
  }
);

instance.interceptors.response.use((response) => {
  const { status, data } = response;
  if (status === 200) {
    const { url } = response.config;
    if (url.indexOf("json") > -1) {
      // mock api
      return data;
    } else {
      return data.data;
    }
  }
});

export default instance;
