import request from "@/api/bcxin/request";
import qs from "qs";

/**
 * @获取腾讯Sig
 * @param params
 * @returns {*}
 * 获取腾IM sigid信息
返回值：{
"api": "",
"v": "",
"retType": "0",
-"data": {
"api": "",
"v": "",
"retType": "0",
"data": "eJw1jk0LgkAURf-LrEPem3EmEdoYBmGL6Mu2xoz2kGSaTIvovzdpLe*598B9sd1qG5iHJWdYjFJKDgCTgXbGsZjxANiYb7ourCXtdyGA5Fwijg1p07RU0iAILsD3gH*NKk9rJ3pMw75B*7wv8-3iWEVFnhzmXdMl5elK63qTnbNEh*nsJ7Z0*X5SkZiiUkq8P5NGMYw_",
"msg": "操作成功！"
},
"msg": ""
}
 */
export const getTencentSig = (params) => {
  return request({
    url: "/identify/api/tencent/get-tencent-sig",
    method: "GET",
    params,
  });
};

//获取TRTC SigId  name="+user.name+"&cid="+user.tencentUserId;
export const getTencentTRTCSig = (params) => {
  return request({
    url: "/identify/api/tencent/get-tencent-ysp-sig",
    method: "GET",
    params,
  });
};

export const getWFToken = (data) => {
  return request({
    url: "/identify/api/yehuo/get/token",
    method: "POST",
    data,
  });
};

//推送音视频房间号给指定人员
export function sendVideoRoomMsg(params) {
  const url = "/identify/api/tencent/send-video-room-msg";
  return request({
    url: url,
    method: "POST",
    headers: { "content-type": "application/x-www-form-urlencoded" },
    data: qs.stringify(params),
  });
}

export function rooms(data) {
  return request({
    url: "/rooms",
    method: "POST",
    data,
    // headers: { "content-type": "application/x-www-form-urlencoded" },
  });
}
