# @turf/point-to-line-distance

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## pointToLineDistance

Returns the minimum distance between a [Point][1] and a [LineString][2], being the distance from a line the
minimum distance between the point and any segment of the `LineString`.

**Parameters**

-   `pt` **([Feature][3]&lt;[Point][4]> | [Array][5]&lt;[number][6]>)** Feature or Geometry
-   `line` **[Feature][3]&lt;[LineString][7]>** GeoJSON Feature or Geometry
-   `options` **[Object][8]** Optional parameters (optional, default `{}`)
    -   `options.units` **[string][9]** can be anything supported by turf/convertLength, eg degrees, radians, miles, or kilometers (optional, default `'kilometers'`)
    -   `options.method` **[string][9]** wehther to calculate the distance based on geodesic (spheroid) or planar (flat) method. Valid options are 'geodesic' or 'planar'. (optional, default `'geodesic'`)

**Examples**

```javascript
var pt = turf.point([0, 0]);
var line = turf.lineString([[1, 1],[-1, 1]]);

var distance = turf.pointToLineDistance(pt, line, {units: 'miles'});
//=69.11854715938406
```

Returns **[number][6]** distance between point and line

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[3]: https://tools.ietf.org/html/rfc7946#section-3.2

[4]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[7]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/point-to-line-distance
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
