package com.zbkj.admin.task.wallet;

import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.service.service.HuifuWalletService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 账号明细等定时任务
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Component("WalletTradeTask")
public class WalletTradeTask {
    //日志
    private static final Logger logger = LoggerFactory.getLogger(WalletTradeTask.class);

    @Autowired
    private HuifuWalletService huifuWalletService;

    /**
     * 每天同步一次数据
     */
    public void tradeDetail() {
        // cron : 0 0 */1 * * ?
        logger.info("---WalletTradeTask task------trade Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
        try {
//            huifuWalletService.huifuWalletAccountTradeDetailSch();
            huifuWalletService.payTradeDetailTaskSch();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("WalletTradeTask.trade" + " | msg : " + e.getMessage());
        }
    }

    /**
     * 每天同步一次数据
     */
    public void reconciliationDetail() {
        // cron : 0 0 */2 * * ?
        logger.info("---WalletTradeTask task------reconciliation Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
        try {
            huifuWalletService.createHuifuWalletReconciliation();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("WalletTradeTask.reconciliation" + " | msg : " + e.getMessage());
        }
    }

    /**
     * 1小时查一次，每次查2天
     */
    public void translogDetail() {
        // cron : 0 0 1 * * ?
        logger.info("---WalletTradeTask task------translog Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
        try {
            huifuWalletService.huifuWalletAccountTranslogTask("","");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("WalletTradeTask.translog" + " | msg : " + e.getMessage());
        }
    }
}
