/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.huifu.bspay.sdk.opps.core.utils.RsaUtils;
import com.huifu.bspay.sdk.opps.core.utils.SequenceTools;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.dto.HuifuRequestDataDto;
import com.zbkj.common.dto.HuifuWalletAccountDetailDto;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.dto.HuifuWalletBusiDto;
import com.zbkj.common.dto.HuifuWalletTradeDto;
import com.zbkj.common.dto.HuifuWalletTransferDto;
import com.zbkj.common.dto.HuifuWalletTranslogDto;
import com.zbkj.common.dto.JsPayTransferDto;
import com.zbkj.common.excel.ExcelUtil;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.model.huifu.HuifuWallet;
import com.zbkj.common.model.huifu.HuifuWalletAccount;
import com.zbkj.common.model.huifu.HuifuWalletAccountDetail;
import com.zbkj.common.model.huifu.HuifuWalletBusi;
import com.zbkj.common.model.huifu.HuifuWalletProcess;
import com.zbkj.common.model.huifu.HuifuWalletReconciliation;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.common.model.huifu.HuifuWalletTranslog;
import com.zbkj.common.model.huifu.JsPayTrade;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.common.utils.FileUtil;
import com.zbkj.common.utils.IdcardUtils;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.BankConfigDao;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletAccountDetailDao;
import com.zbkj.service.dao.HuifuWalletBusiDao;
import com.zbkj.service.dao.HuifuWalletDao;
import com.zbkj.service.dao.HuifuWalletProcessDao;
import com.zbkj.service.dao.HuifuWalletReconciliationDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.dao.HuifuWalletTranslogDao;
import com.zbkj.service.dao.JsPayTradeDao;
import com.zbkj.service.huifu.constants.OpenProcess;
import com.zbkj.service.service.CommonConfigService;
import com.zbkj.service.service.CommonWalletService;
import com.zbkj.service.service.HuifuReconcileService;
import com.zbkj.service.service.HuifuWalletService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.TaskResidualService;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.WSApiRequest;
import com.zbkj.service.wangshang.constants.WSBusiCode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Component(value="wangShangWalletServiceImpl")
public class WangShangWalletServiceImpl
extends ServiceImpl<HuifuWalletDao, HuifuWallet>
implements HuifuWalletService {
    private static final Logger logger = LoggerFactory.getLogger(HuifuWalletService.class);
    @Resource
    private HuifuWalletDao huifuWalletDao;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Resource
    private HuifuWalletBusiDao huifuWalletBusiDao;
    @Resource
    private HuifuWalletAccountDetailDao huifuWalletAccountDetailDao;
    @Resource
    private HuifuWalletProcessDao huifuWalletProcessDao;
    @Resource
    private HuifuWalletTradeDao huifuWalletTradeDao;
    @Resource
    private JsPayTradeDao jsPayTradeDao;
    @Resource
    private HuifuWalletTranslogDao huifuWalletTranslogDao;
    @Resource
    private BankConfigDao bankConfigDao;
    @Resource
    private HuifuWalletReconciliationDao huifuWalletReconciliationDao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private CommonConfigService commonConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    HuifuReconcileService huifuReconcileService;
    @Autowired
    CommonWalletService commonWalletService;
    @Autowired
    TransactionLogService transactionLogService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private RedissonClient redisson;
    @Autowired
    TaskResidualService taskResidualService;
    private static final String TRANSFERKEY = "Callback:";
    private static final String TRANSFERFROZENKEY = "TransferFrozen:";
    private static final String SCHKEY = "SchTask:";
    private static final int expireTime = 600;
    private static final DecimalFormat decimalFormat = new DecimalFormat("#0.00");
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    @Override
    @Async
    public void syncTransferToPlat(HuifuWalletTransferDto dto) {
        try {
            dto.setPayChannel(PaymentChannel.WANGSHANG.toString());
            if (!this.transferToPlat(dto).booleanValue()) {
                this.taskResidualService.saveTaskResidual("transferToPlat", "\u5e73\u53f0\u5206\u8d26\u8865\u507f", "com.zbkj.service.service.impl.WangShangWalletServiceImpl", 1, "com.zbkj.common.dto.HuifuWalletTransferDto", JSONObject.toJSONString((Object)dto));
            }
        }
        catch (Exception e) {
            logger.error(">>>>>>>>> \u4f01\u4e1a\u5206\u8d26\u7ed9\u5e73\u53f0transferToPlat.\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage());
            this.taskResidualService.saveTaskResidual("transferToPlat", "\u5e73\u53f0\u5206\u8d26\u8865\u507f", "com.zbkj.service.service.impl.WangShangWalletServiceImpl", 1, "com.zbkj.common.dto.HuifuWalletTransferDto", JSONObject.toJSONString((Object)dto));
        }
    }

    @Override
    @Async
    public void syncUpdateSumFrozenAmount(String uniId, BigDecimal amount) {
        try {
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            logger.error(">>>>>>>>> \u4f01\u4e1a\u51bb\u7ed3\u91d1\u989d\u8ba1\u7b97modifyBalance.\u5f00\u59cb\uff1a");
            if (!this.commonWalletService.modifyBalance(uniId, amount, PaymentChannel.WANGSHANG.toString())) {
                this.taskResidualService.saveTaskResidual("modifyBalance", "\u51bb\u7ed3\u91d1\u989d\u8ba1\u7b97\u8865\u507f", "com.zbkj.service.service.CommonWalletService", 3, "String,BigDecimal,String", uniId + "," + amount + "," + PaymentChannel.WANGSHANG.toString());
            }
        }
        catch (Exception e) {
            logger.error(">>>>>>>>> \u4f01\u4e1a\u51bb\u7ed3\u91d1\u989d\u8ba1\u7b97modifyBalance.\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage());
            this.taskResidualService.saveTaskResidual("modifyBalance", "\u51bb\u7ed3\u91d1\u989d\u8ba1\u7b97\u8865\u507f", "com.zbkj.service.service.CommonWalletService", 3, "String,BigDecimal,String", uniId + "," + amount + "," + PaymentChannel.WANGSHANG.toString());
        }
    }

    @Async
    public void syncRefundToPlat(HuifuWalletTransferDto dto) {
        try {
            dto.setPayChannel(PaymentChannel.WANGSHANG.toString());
            if (!this.refundToPlat(dto).booleanValue()) {
                this.taskResidualService.saveTaskResidual("refundToPlat", "\u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1a\u8865\u507f", "com.zbkj.service.service.impl.WangShangWalletServiceImpl", 1, "com.zbkj.common.dto.HuifuWalletTransferDto", JSONObject.toJSONString((Object)dto));
            }
        }
        catch (Exception e) {
            logger.error(">>>>>>>>> \u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage());
            this.taskResidualService.saveTaskResidual("refundToPlat", "\u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1a\u8865\u507f", "com.zbkj.service.service.impl.WangShangWalletServiceImpl", 1, "com.zbkj.common.dto.HuifuWalletTransferDto", JSONObject.toJSONString((Object)dto));
        }
    }

    @Override
    public Map<String, String> getHuifuWalletServiceOpenInfo(HuifuWallet huifuWallet) {
        if (huifuWallet.getUniId() == null) {
            return null;
        }
        huifuWallet = this.huifuWalletDao.getHuifuWalletByUniId(huifuWallet.getUniId(), PaymentChannel.WANGSHANG.toString());
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (huifuWallet == null) {
            resultMap.put("isCompleteOpen", "0");
            resultMap.put("isAuthorize", "0");
        } else {
            resultMap.put("isCompleteOpen", huifuWallet.getIsCompleteOpen());
            resultMap.put("isAuthorize", "1");
        }
        resultMap.put("openRegTime", this.systemConfigService.getValueByKey("ws_open_reg_time"));
        resultMap.put("openWalletTime", this.systemConfigService.getValueByKey("ws_open_wallet_time"));
        return resultMap;
    }

    @Override
    public HuifuWalletProcess getHuifuWalletCurrentProcess(HuifuWalletProcess dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            return null;
        }
        HuifuWalletProcess buildProcess = this.huifuWalletProcessDao.getHuifuWalletCurrentProcess(dto.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (buildProcess == null) {
            buildProcess = new HuifuWalletProcess();
            buildProcess.setUniId(dto.getUniId());
            buildProcess.setCreateTime(new Date());
            buildProcess.setStep(Integer.valueOf(OpenProcess.QYKH.getSort()));
            buildProcess.setIsComplete("0");
            buildProcess.setDescription(OpenProcess.QYKH.getDesc());
            buildProcess.setPayChannel(PaymentChannel.WANGSHANG.toString());
            this.huifuWalletProcessDao.insert(buildProcess);
            HuifuWallet huifuWallet = new HuifuWallet();
            huifuWallet.setUniId(dto.getUniId());
            huifuWallet.setCreateTime(new Date());
            huifuWallet.setIsCompleteOpen("0");
            huifuWallet.setPayChannel(PaymentChannel.WANGSHANG.toString());
            this.huifuWalletDao.insertHuifuWallet(huifuWallet);
        }
        return buildProcess;
    }

    private void checkValidateCode(String phone, String code) throws CrmebWalletException {
        Object validateCode = this.redisUtil.get("sms:validate:code:" + phone);
        if (ObjectUtil.isNull((Object)validateCode)) {
            throw new CrmebWalletException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        if (!validateCode.toString().equals(code)) {
            throw new CrmebWalletException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.redisUtil.delete(new String[]{"sms:validate:code:" + phone});
    }

    public static String RET(Map<String, Object> response, int type) {
        if (type == 1) {
            return response.get("resp_code").toString();
        }
        return response.get("resp_desc").toString();
    }

    private String uploadFile(String url, String type) {
        Map<String, Object> response;
        String downloadToFolder = this.commonConfigService.getValueByKey("payment_reconciliation_download_folder");
        if (!cn.hutool.core.io.FileUtil.exist((String)downloadToFolder)) {
            cn.hutool.core.io.FileUtil.mkdir((String)downloadToFolder);
        }
        String licenseLocal = FileUtil.downloadHttpUrl((String)url, (String)(downloadToFolder + "/"), (String)(System.currentTimeMillis() + type + ".jpg"));
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("type", type);
        p.put("filePath", licenseLocal);
        try {
            response = WSApiRequest.api(WSBusiCode.UPLOAD, p);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            return response.get("photoUrl").toString();
        }
        return "";
    }

    @Override
    public String saveAccountInfo(HuifuWalletAccountDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new CrmebWalletException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getComName())) {
            throw new CrmebWalletException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getHfComType())) {
            throw new CrmebWalletException("\u4f01\u4e1a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getContactName())) {
            throw new CrmebWalletException("\u8054\u7cfb\uff08\u7ecf\u529e\uff09\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getContactPhone())) {
            throw new CrmebWalletException("\u8054\u7cfb\uff08\u7ecf\u529e\uff09\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getContactIdcardType())) {
            throw new CrmebWalletException("\u8054\u7cfb\uff08\u7ecf\u529e\uff09\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getContactIdcardNo())) {
            throw new CrmebWalletException("\u8054\u7cfb\uff08\u7ecf\u529e\uff09\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getLicenseValidityType())) {
            throw new CrmebWalletException("\u8bc1\u7167\u6709\u6548\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getLicenseBeginDate())) {
            throw new CrmebWalletException("\u8bc1\u7167\u6709\u6548\u671f\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getRegProvId())) {
            throw new CrmebWalletException("\u6ce8\u518c\u5730\u5740(\u7701)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getRegAreaId())) {
            throw new CrmebWalletException("\u6ce8\u518c\u5730\u5740(\u5e02)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getRegAddress())) {
            throw new CrmebWalletException("\u6ce8\u518c\u5730\u5740(\u8be6\u7ec6\u4fe1\u606f)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getLegalRepName())) {
            throw new CrmebWalletException("\u6cd5\u5b9a\u4ee3\u8868\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getIdcardType())) {
            throw new CrmebWalletException("\u6cd5\u5b9a\u4ee3\u8868\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getIdcardNo())) {
            throw new CrmebWalletException("\u6cd5\u5b9a\u4ee3\u8868\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("00".equals(dto.getIdcardType()) && !IdcardUtils.validateCard((String)dto.getIdcardNo())) {
            throw new CrmebWalletException("\u6cd5\u4eba\u8eab\u4efd\u8bc1\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty((String)dto.getLegalCertValidityType())) {
            throw new CrmebWalletException("\u8bc1\u7167\u6709\u6548\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getLegalCertBeginDate())) {
            throw new CrmebWalletException("\u8eab\u4efd\u8bc1\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getCardName())) {
            throw new CrmebWalletException("\u5361\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getCardNo())) {
            throw new CrmebWalletException("\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getProvId())) {
            throw new CrmebWalletException("\u94f6\u884c\u6240\u5728\u7701\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getAreaId())) {
            throw new CrmebWalletException("\u94f6\u884c\u6240\u5728\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getCardType())) {
            throw new CrmebWalletException("\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBankCode())) {
            throw new CrmebWalletException("\u94f6\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBranchCode())) {
            throw new CrmebWalletException("\u652f\u884c\u8054\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBranchName())) {
            throw new CrmebWalletException("\u652f\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getBankCode().length() == 7) {
            dto.setBankCode("0" + dto.getBankCode());
        }
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getUniId(), PaymentChannel.WANGSHANG.toString());
        dto.setPayChannel(PaymentChannel.WANGSHANG.toString());
        HashMap<String, Object> p = new HashMap<String, Object>();
        String outMchId = SequenceTools.getReqSeqId32();
        dto.setOutMerchantId(outMchId);
        p.put("reqSeqId", outMchId);
        p.put("regName", dto.getComName());
        p.put("shortName", dto.getShortName());
        p.put("licenseValidityType", dto.getLicenseValidityType());
        p.put("licenseBeginDate", DateUtil.formatDate((Date)DateUtil.parse((String)dto.getLicenseBeginDate(), (String)"yyyyMMdd")));
        p.put("licenseEndDate", DateUtil.formatDate((Date)DateUtil.parse((String)dto.getLicenseEndDate(), (String)"yyyyMMdd")));
        p.put("licenseCode", dto.getComCerNo());
        p.put("regProvId", dto.getRegProvId());
        p.put("regAreaId", dto.getRegAreaId());
        p.put("regDistrictId", dto.getRegDistrictId());
        p.put("regDetail", dto.getRegAddress() + "001");
        p.put("legalName", dto.getLegalRepName());
        p.put("legalCertNo", dto.getIdcardNo());
        p.put("legalCertType", dto.getIdcardType());
        p.put("licensePhoto", this.uploadFile(dto.getLicensePhoto(), "03"));
        p.put("certPhotoA", this.uploadFile(dto.getCertPhotoA(), "01"));
        p.put("certPhotoB", this.uploadFile(dto.getCertPhotoB(), "02"));
        p.put("legalCertValidityType", dto.getLegalCertValidityType());
        p.put("legalCertBeginDate", DateUtil.formatDate((Date)DateUtil.parse((String)dto.getLegalCertBeginDate(), (String)"yyyyMMdd")));
        p.put("legalCertEndDate", DateUtil.formatDate((Date)DateUtil.parse((String)dto.getLegalCertEndDate(), (String)"yyyyMMdd")));
        p.put("contactName", dto.getContactName());
        p.put("contactMobile", dto.getContactPhone());
        p.put("contactIdcardType", dto.getContactIdcardType());
        p.put("contactIdcardNo", dto.getContactIdcardNo());
        p.put("card_type", dto.getCardType());
        p.put("card_name", dto.getCardName());
        p.put("card_no", dto.getCardNo());
        p.put("prov_id", dto.getProvId());
        p.put("area_id", dto.getAreaId());
        p.put("bank_code", dto.getBankCode());
        p.put("branch_code", dto.getBranchCode());
        p.put("branch_name", dto.getBranchName());
        p.put("mp", dto.getMp());
        if (account != null && account.getAcctStat() != null) {
            p.put("merchantId", account.getWalletAccountNo());
            wSBusiCode = WSBusiCode.ENTMODIFY;
        } else {
            wSBusiCode = WSBusiCode.ENT;
        }
        try {
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e2) {
            this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            HuifuWalletAccountDto finalAccount = account;
            HuifuWalletAccountDto hwaDto = dto;
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                HuifuWalletBusiDto busi;
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                Date now = new Date();
                if (finalAccount == null) {
                    hwaDto.setCreateTime(now);
                    hwaDto.setWalletAccountNo(outMchId);
                    hwaDto.setOrderNo(String.valueOf(response.get("orderNo")));
                    this.huifuWalletAccountDao.insertHuifuWalletAccount((HuifuWalletAccount)hwaDto);
                    HuifuWalletAccountDto accountN = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(hwaDto.getUniId(), PaymentChannel.WANGSHANG.toString());
                    HuifuWalletBusiDto busiDto = new HuifuWalletBusiDto();
                    busiDto.setCardName(hwaDto.getCardName());
                    busiDto.setCardNo(hwaDto.getCardNo());
                    busiDto.setCardType(hwaDto.getCardType());
                    busiDto.setCashType(hwaDto.getCashType());
                    busiDto.setBranchCode(hwaDto.getBranchCode());
                    busiDto.setBranchName(hwaDto.getBranchName());
                    busiDto.setBankCode(hwaDto.getBankCode());
                    busiDto.setProvId(hwaDto.getProvId());
                    busiDto.setAreaId(hwaDto.getAreaId());
                    busiDto.setCreateTime(new Date());
                    busiDto.setAccountId(accountN.getId());
                    busiDto.setPayChannel(PaymentChannel.WANGSHANG.toString());
                    this.huifuWalletBusiDao.insertHuifuWalletBusi((HuifuWalletBusi)busiDto);
                    HuifuWalletProcess huifuWalletProcess = this.huifuWalletProcessDao.getHuifuWalletCurrentProcess(hwaDto.getUniId(), PaymentChannel.WANGSHANG.toString());
                    if (huifuWalletProcess == null) {
                        huifuWalletProcess = new HuifuWalletProcess();
                        huifuWalletProcess.setUniId(hwaDto.getUniId());
                        huifuWalletProcess.setCreateTime(new Date());
                        huifuWalletProcess.setStep(Integer.valueOf(OpenProcess.QYKH.getSort()));
                        huifuWalletProcess.setIsComplete("1");
                        huifuWalletProcess.setDescription(OpenProcess.QYKH.getDesc());
                        huifuWalletProcess.setPayChannel(PaymentChannel.WANGSHANG.toString());
                        this.huifuWalletProcessDao.insert(huifuWalletProcess);
                        HuifuWallet huifuWallet = new HuifuWallet();
                        huifuWallet.setUniId(hwaDto.getUniId());
                        huifuWallet.setCreateTime(new Date());
                        huifuWallet.setIsCompleteOpen("0");
                        huifuWallet.setPayChannel(PaymentChannel.WANGSHANG.toString());
                        this.huifuWalletDao.insertHuifuWallet(huifuWallet);
                    } else if (OpenProcess.QYKH.getSort() == huifuWalletProcess.getStep().intValue()) {
                        huifuWalletProcess.setUpdateTime(now);
                        huifuWalletProcess.setIsComplete("1");
                        this.huifuWalletProcessDao.updateById(huifuWalletProcess);
                    }
                } else if (finalAccount.getAcctStat() == null) {
                    hwaDto.setUpdateTime(now);
                    hwaDto.setFailReason("");
                    hwaDto.setWalletAccountNo(outMchId);
                    hwaDto.setOrderNo(String.valueOf(response.get("orderNo")));
                    this.huifuWalletAccountDao.updateHuifuWalletAccountAll((HuifuWalletAccount)hwaDto);
                    busi = this.huifuWalletBusiDao.getHuifuWalletBusiByAccountId(finalAccount.getId());
                    busi.setUpdateTime(now);
                    busi.setCardName(hwaDto.getCardName());
                    busi.setCardNo(hwaDto.getCardNo());
                    busi.setCardType(hwaDto.getCardType());
                    busi.setCashType(hwaDto.getCashType());
                    busi.setBranchCode(hwaDto.getBranchCode());
                    busi.setBranchName(hwaDto.getBranchName());
                    busi.setBankCode(hwaDto.getBankCode());
                    busi.setProvId(hwaDto.getProvId());
                    busi.setAreaId(hwaDto.getAreaId());
                    this.huifuWalletBusiDao.updateById(busi);
                    HuifuWalletProcess huifuWalletProcess = this.huifuWalletProcessDao.getHuifuWalletCurrentProcess(hwaDto.getUniId(), PaymentChannel.WANGSHANG.toString());
                    if (OpenProcess.YWRZ.getSort() == huifuWalletProcess.getStep().intValue()) {
                        huifuWalletProcess.setUpdateTime(now);
                        huifuWalletProcess.setIsComplete("1");
                        this.huifuWalletProcessDao.updateById(huifuWalletProcess);
                    }
                } else {
                    hwaDto.setUpdateTime(now);
                    hwaDto.setFailReason("");
                    hwaDto.setOrderNo(String.valueOf(response.get("outTradeNo")));
                    this.huifuWalletAccountDao.updateHuifuWalletAccountAll((HuifuWalletAccount)hwaDto);
                    busi = this.huifuWalletBusiDao.getHuifuWalletBusiByAccountId(finalAccount.getId());
                    busi.setUpdateTime(now);
                    busi.setCardName(hwaDto.getCardName());
                    busi.setCardNo(hwaDto.getCardNo());
                    busi.setCardType(hwaDto.getCardType());
                    busi.setCashType(hwaDto.getCashType());
                    busi.setBranchCode(hwaDto.getBranchCode());
                    busi.setBranchName(hwaDto.getBranchName());
                    busi.setBankCode(hwaDto.getBankCode());
                    busi.setProvId(hwaDto.getProvId());
                    busi.setAreaId(hwaDto.getAreaId());
                    this.huifuWalletBusiDao.updateById(busi);
                }
                HuifuWalletProcess huifuWalletProcess = this.huifuWalletProcessDao.getHuifuWalletCurrentProcess(hwaDto.getUniId(), PaymentChannel.WANGSHANG.toString());
                if (OpenProcess.QYKH.getSort() == huifuWalletProcess.getStep().intValue()) {
                    HuifuWalletProcess buildProcess = new HuifuWalletProcess();
                    buildProcess.setUniId(hwaDto.getUniId());
                    buildProcess.setCreateTime(now);
                    buildProcess.setStep(Integer.valueOf(OpenProcess.YWRZ.getSort()));
                    buildProcess.setIsComplete("0");
                    buildProcess.setDescription(OpenProcess.YWRZ.getDesc());
                    buildProcess.setPayChannel(PaymentChannel.WANGSHANG.toString());
                    this.huifuWalletProcessDao.insert(buildProcess);
                }
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u5f00\u6237\u6570\u636e-\u64cd\u4f5c\u5931\u8d25");
            }
            account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(hwaDto.getUniId(), PaymentChannel.WANGSHANG.toString());
            return account.getId() + "";
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String saveAccountInfoStepTwo(HuifuWalletBusiDto dto) throws CrmebWalletException {
        WSBusiCode wSBusiCode;
        String operType;
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getCardName())) {
            throw new CrmebWalletException("\u5361\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getCardNo())) {
            throw new CrmebWalletException("\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getProvId())) {
            throw new CrmebWalletException("\u94f6\u884c\u6240\u5728\u7701\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getAreaId())) {
            throw new CrmebWalletException("\u94f6\u884c\u6240\u5728\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getCashType())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getCardType())) {
            throw new CrmebWalletException("\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBankCode())) {
            throw new CrmebWalletException("\u94f6\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBranchCode())) {
            throw new CrmebWalletException("\u652f\u884c\u8054\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBranchName())) {
            throw new CrmebWalletException("\u652f\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (account == null) {
            throw new CrmebWalletException("\u672a\u5b8c\u6210\u4f01\u4e1a\u4fe1\u606f\u5f55\u5165");
        }
        if (dto.getBankCode().length() == 7) {
            dto.setBankCode("0" + dto.getBankCode());
        }
        HuifuWalletBusiDto busi = this.huifuWalletBusiDao.getHuifuWalletBusiByAccountId(account.getId());
        dto.setReqSeqId(SequenceTools.getReqSeqId32());
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("reqSeqId", dto.getReqSeqId());
        p.put("card_type", dto.getCardType());
        p.put("cash_type", dto.getCashType());
        p.put("card_name", dto.getCardName());
        p.put("card_no", dto.getCardNo());
        p.put("prov_id", dto.getProvId());
        p.put("area_id", dto.getAreaId());
        p.put("bank_code", dto.getBankCode());
        p.put("branch_code", dto.getBranchCode());
        p.put("branch_name", dto.getBranchName());
        p.put("mp", dto.getMp());
        Map response = null;
        try {
            if (busi != null) {
                operType = "2";
                wSBusiCode = WSBusiCode.BUSIMODIFY;
            } else {
                operType = "1";
                wSBusiCode = WSBusiCode.BUSIOPEN;
            }
        }
        catch (Exception e2) {
            this.transactionLogService.save("saveAccountInfoStepTwo", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute;
            if (response.get("resp_business") != null) {
                List list = JSONObject.parseArray((String)response.get("resp_business").toString(), JSONObject.class);
                String errMsg = "";
                for (JSONObject json : list) {
                    if (!"F".equals(json.get((Object)"code") + "")) continue;
                    errMsg = errMsg + json.get((Object)"msg") + ";";
                }
                if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                    this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                    throw new CrmebWalletException(errMsg);
                }
            }
            if (!(execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                Date now = new Date();
                if ("1".equals(operType)) {
                    dto.setCreateTime(now);
                    dto.setTokenNo(String.valueOf(response.get("token_no")));
                    dto.setAccountId(account.getId());
                    this.huifuWalletBusiDao.insertHuifuWalletBusi((HuifuWalletBusi)dto);
                    HuifuWallet huifuWallet = this.huifuWalletDao.getHuifuWalletByUniId(account.getUniId(), PaymentChannel.WANGSHANG.toString());
                    HuifuWalletProcess huifuWalletProcess = this.huifuWalletProcessDao.getHuifuWalletCurrentProcess(account.getUniId(), PaymentChannel.WANGSHANG.toString());
                    if (OpenProcess.YWRZ.getSort() == huifuWalletProcess.getStep().intValue()) {
                        huifuWalletProcess.setUpdateTime(now);
                        huifuWalletProcess.setIsComplete("1");
                        this.huifuWalletProcessDao.updateById(huifuWalletProcess);
                    }
                    huifuWallet.setUniId(account.getUniId());
                    huifuWallet.setUpdateTime(now);
                    huifuWallet.setIsCompleteOpen("1");
                    huifuWallet.setOpenTime(now);
                    huifuWallet.setPayChannel(PaymentChannel.WANGSHANG.toString());
                    this.huifuWalletDao.updateHuifuWallet(huifuWallet);
                } else if ("2".equals(operType)) {
                    dto.setUpdateTime(now);
                    dto.setId(busi.getId());
                    dto.setTokenNo(String.valueOf(response.get("token_no")));
                    this.huifuWalletBusiDao.updateHuifuWalletBusiAll((HuifuWalletBusi)dto);
                } else {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            })).booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u4e1a\u52a1\u5165\u9a7b-\u64cd\u4f5c\u5931\u8d25");
            }
            return "1";
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String getActiveUrl(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (dto == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u4fe1\u606f\u672a\u5f55\u5165");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", dto.getOutMerchantId());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        try {
            wSBusiCode = WSBusiCode.YHACTIVE;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save("getActiveCode", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            try {
                this.transactionLogService.save(WSBusiCode.YHACTIVE.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                System.out.println(response.get("url").toString());
                return WangShangWalletServiceImpl.createErWeiMaToBase64(response.get("url").toString());
            }
            catch (Exception e) {
                throw new CrmebWalletException(e.getMessage());
            }
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String getACXLoginUrl(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (dto == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u4fe1\u606f\u672a\u5f55\u5165");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", dto.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        try {
            wSBusiCode = WSBusiCode.YHLOGIN;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.YHLOGIN.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            try {
                this.transactionLogService.save(WSBusiCode.YHLOGIN.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                return WangShangWalletServiceImpl.createErWeiMaToBase64(response.get("url").toString());
            }
            catch (Exception e) {
                throw new CrmebWalletException(e.getMessage());
            }
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    public static String createErWeiMaToBase64(String data) throws Exception {
        int width = 300;
        int height = 300;
        String format = "jpg";
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(data, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage image = WangShangWalletServiceImpl.toBufferedImage(bitMatrix);
        return WangShangWalletServiceImpl.bufferedImageToBase64(image);
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        int width = resMatrix.getWidth();
        int height = resMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, resMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String bufferedImageToBase64(BufferedImage bufferedImage) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, "jpg", stream);
            byte[] bytes = Base64.encodeBase64((byte[])stream.toByteArray());
            String base64 = new String(bytes);
            String string = "data:image/jpeg;base64," + base64;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public HuifuWalletAccountDto getHuifuWalletAccountStatus(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (dto == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u4fe1\u606f\u672a\u5f55\u5165");
        }
        HuifuWalletProcess hp = this.huifuWalletProcessDao.getLastStepProcess(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (hp != null && (hp.getStep() == 2 || hp.getStep() == 3) && "0".equals(hp.getIsComplete())) {
            Map<String, Object> response;
            WSBusiCode wSBusiCode;
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("orderNo", dto.getOrderNo());
            p.put("reqSeqId", SequenceTools.getReqSeqId32());
            try {
                wSBusiCode = WSBusiCode.SHRZQUERY;
                response = WSApiRequest.api(wSBusiCode, p);
            }
            catch (Exception e2) {
                this.transactionLogService.save("getHuifuWalletAccount", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
                throw new CrmebWalletException(e2.getMessage());
            }
            Integer accountId = dto.getId();
            if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
                Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                    this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                    String registerStatus = String.valueOf(response.get("registerStatus"));
                    String merchantId = String.valueOf(response.get("merchantId"));
                    String failReason = String.valueOf(response.get("failReason"));
                    Date now = new Date();
                    HuifuWalletAccount hwa = (HuifuWalletAccount)this.huifuWalletAccountDao.selectById(accountId);
                    HuifuWallet huifuWallet = this.huifuWalletDao.getHuifuWalletByUniId(hwa.getUniId(), PaymentChannel.WANGSHANG.toString());
                    if ("1".equals(huifuWallet.getIsCompleteOpen())) {
                        return true;
                    }
                    if ("1".equals(registerStatus)) {
                        hwa.setUpdateTime(now);
                        hwa.setFailReason("");
                        if (hp.getStep() == 2) {
                            hwa.setWalletAccountNo(merchantId);
                            this.huifuWalletAccountDao.updateById(hwa);
                            hp.setUpdateTime(now);
                            hp.setIsComplete("1");
                            this.huifuWalletProcessDao.updateById(hp);
                            HuifuWalletProcess buildProcess = new HuifuWalletProcess();
                            buildProcess.setUniId(hwa.getUniId());
                            buildProcess.setCreateTime(now);
                            buildProcess.setStep(Integer.valueOf(OpenProcess.SHJHZ.getSort()));
                            buildProcess.setIsComplete("0");
                            buildProcess.setDescription(OpenProcess.SHJHZ.getDesc());
                            buildProcess.setPayChannel(PaymentChannel.WANGSHANG.toString());
                            this.huifuWalletProcessDao.insert(buildProcess);
                        } else if (hp.getStep() == 3) {
                            hwa.setAcctStat("N");
                            this.huifuWalletAccountDao.updateById(hwa);
                            hp.setUpdateTime(now);
                            hp.setIsComplete("1");
                            this.huifuWalletProcessDao.updateById(hp);
                            huifuWallet.setUniId(hwa.getUniId());
                            huifuWallet.setUpdateTime(now);
                            huifuWallet.setIsCompleteOpen("1");
                            huifuWallet.setOpenTime(now);
                            huifuWallet.setPayChannel(PaymentChannel.WANGSHANG.toString());
                            this.huifuWalletDao.updateHuifuWallet(huifuWallet);
                        }
                    } else if ("2".equals(registerStatus)) {
                        hwa.setFailReason(failReason);
                        this.huifuWalletAccountDao.updateById(hwa);
                        if (hp.getStep() == 2) {
                            this.huifuWalletProcessDao.deleteById((Serializable)hp);
                            HuifuWalletProcess huifuWalletProcess = this.huifuWalletProcessDao.getLastStepProcess(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
                            huifuWalletProcess.setUpdateTime(now);
                            huifuWalletProcess.setIsComplete("0");
                            this.huifuWalletProcessDao.updateById(huifuWalletProcess);
                        }
                    }
                    return Boolean.TRUE;
                });
                if (!execute.booleanValue()) {
                    throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u8d26\u6237\u67e5\u8be2-\u64cd\u4f5c\u5931\u8d25");
                }
            } else {
                this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
            }
            dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        }
        return dto;
    }

    @Override
    public HuifuWalletAccountDto huifuWalletAccountUpdateStatus(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        Map<String, Object> response;
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (dto == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u4fe1\u606f\u672a\u5f55\u5165");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("orderNo", dto.getOrderNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        WSBusiCode wSBusiCode = WSBusiCode.SHXGQUERY;
        try {
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e2) {
            this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        Integer accountId = dto.getId();
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                String status = String.valueOf(response.get("status"));
                String failReason = String.valueOf(response.get("failReason"));
                Date now = new Date();
                HuifuWalletAccount hwa = (HuifuWalletAccount)this.huifuWalletAccountDao.selectById(accountId);
                hwa.setUpdateTime(now);
                if ("1".equals(status)) {
                    hwa.setFailReason("");
                    hwa.setAcctStat("N");
                } else if ("2".equals(status)) {
                    hwa.setAcctStat("F");
                    hwa.setFailReason(failReason);
                }
                this.huifuWalletAccountDao.updateById(hwa);
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u8d26\u6237\u67e5\u8be2-\u64cd\u4f5c\u5931\u8d25");
            }
        } else {
            this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
        }
        dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        return dto;
    }

    @Override
    public HuifuWalletAccountDto huifuWalletAccountActiveStatus(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        Map<String, Object> response;
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (dto == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u4fe1\u606f\u672a\u5f55\u5165");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", dto.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        WSBusiCode wSBusiCode = WSBusiCode.YHQUERY;
        try {
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e2) {
            this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        Integer accountId = dto.getId();
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                String status = String.valueOf(response.get("registerStatus"));
                System.out.println(status);
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u8d26\u6237\u67e5\u8be2-\u64cd\u4f5c\u5931\u8d25");
            }
        } else {
            this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
        }
        dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        return dto;
    }

    @Override
    public Object getHuifuWalletAccountDetail(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (dto == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u4fe1\u606f\u672a\u5f55\u5165");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", dto.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        try {
            wSBusiCode = WSBusiCode.SHQUERY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.SHQUERY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        Integer accountId = dto.getId();
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            return response.get("merchantDetail");
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public HuifuWalletAccountDto getHuifuWalletAccount(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (dto == null) {
            return new HuifuWalletAccountDto();
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getAcctStat())) {
            this.getHuifuWalletAccountArrangementStatus(huifuWalletAccount);
        }
        if ("N".equals((dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString())).getAcctStat())) {
            dto.setAccountStatus("1");
        } else {
            dto.setAccountStatus("0");
        }
        HuifuWalletBusiDto busi = this.huifuWalletBusiDao.getHuifuWalletBusiByAccountId(dto.getId());
        if (busi != null) {
            dto.setBranchName(busi.getBranchName());
            dto.setBankCode(busi.getBankCode());
            dto.setBranchCode(busi.getBranchCode());
            dto.setCashType(busi.getCashType());
            dto.setCardNo(busi.getCardNo());
            dto.setCardName(busi.getCardName());
            dto.setCardType(busi.getCardType());
            dto.setProvId(busi.getProvId());
            dto.setAreaId(busi.getAreaId());
        }
        return dto;
    }

    @Override
    public void getHuifuWalletAccountArrangementStatus(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        HuifuWalletAccount hwa;
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (dto == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", dto.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        try {
            wSBusiCode = WSBusiCode.TAUTHSTATUS;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.TAUTHSTATUS.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            String status = response.get("status").toString();
            if (status.equals(dto.getArrangementStatus())) {
                return;
            }
            hwa = (HuifuWalletAccount)this.huifuWalletAccountDao.selectById(dto.getId());
            hwa.setArrangementStatus(status);
            if ("INVALID_TO_BE_CONFIRM".equals(status) || "UN_VALID".equals(status)) {
                hwa.setFailReason("\u5408\u7ea6\u672a\u786e\u8ba4\u6216\u65e0\u6548");
                hwa.setAcctStat("F");
            } else if ("NOT_EXIST".equals(status)) {
                hwa.setFailReason("\u5408\u7ea6\u4e0d\u5b58\u5728");
                hwa.setAcctStat("C");
            } else {
                hwa.setFailReason("");
                hwa.setAcctStat("N");
                String arrangementNo = response.get("arrangementNo").toString();
                hwa.setArrangementNo(arrangementNo);
            }
        } else {
            this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
        }
        hwa.setUpdateTime(new Date());
        this.huifuWalletAccountDao.updateById(hwa);
    }

    @Override
    public String checkArrangementAudit(HuifuWalletAccountDto huifuWalletAccount) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (dto == null) {
            throw new CrmebWalletException("\u8d26\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", dto.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("arrangementNo", dto.getArrangementNo());
        p.put("auditResult", "1".equals(huifuWalletAccount.getAuditResult()) ? "AGREE" : "REJECT");
        try {
            wSBusiCode = WSBusiCode.TAUTH;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save("checkArrangementAudit", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            return "1";
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public BigDecimal getHuifuWallectBalanceByUniId(String uniId) throws CrmebWalletException {
        Map<String, String> amounts = this.requestHuifuWalletAmount(uniId);
        return new BigDecimal(amounts.get("availableAmount"));
    }

    @Override
    public BigDecimal getWallectFrozenAmountByUniId(String uniId) throws CrmebWalletException {
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(uniId, PaymentChannel.WANGSHANG.toString());
        if (account == null) {
            throw new CrmebWalletException("\u672a\u627e\u5230\u8d26\u6237\u4fe1\u606f\uff01");
        }
        return new BigDecimal(account.getFrozenAmount());
    }

    @Override
    public Map<String, String> getHuifuWalletAccountAmount(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)huifuWalletAccount.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.requestHuifuWalletAmount(huifuWalletAccount.getUniId());
    }

    private Map<String, String> requestHuifuWalletAmount(String uniId) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(uniId, PaymentChannel.WANGSHANG.toString());
        if (account == null) {
            throw new CrmebWalletException("\u672a\u627e\u5230\u8d26\u6237\u4fe1\u606f\uff01");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", account.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        try {
            wSBusiCode = WSBusiCode.YEQUERY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.YEQUERY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            HashMap<String, String> resultMap = new HashMap<String, String>();
            String frozenAmount = StringUtils.isEmpty((CharSequence)account.getFrozenAmount()) ? "0" : account.getFrozenAmount();
            String BALANCE = response.get("BALANCE").toString();
            String TRADE_DEPOSIT = response.get("TRADE_DEPOSIT") == null ? "0" : response.get("TRADE_DEPOSIT").toString();
            String ledger_bal = new BigDecimal(BALANCE).add(new BigDecimal(TRADE_DEPOSIT)).toString();
            BigDecimal ky = BigDecimal.ZERO;
            if (Double.parseDouble(ledger_bal) > 0.0) {
                ky = new BigDecimal(ledger_bal).divide(new BigDecimal("100"));
            }
            BigDecimal availableAmount = ky.subtract(new BigDecimal(frozenAmount));
            resultMap.put("totalAmount", decimalFormat.format(ky));
            resultMap.put("availableAmount", decimalFormat.format(availableAmount));
            resultMap.put("frozenAmount", frozenAmount);
            Double _frozenAmount = Double.parseDouble(frozenAmount);
            Double _BALANCE = Double.parseDouble(BALANCE);
            if (_BALANCE > 0.0) {
                _BALANCE = _BALANCE / 100.0;
            }
            if (_BALANCE >= _frozenAmount) {
                _BALANCE = _BALANCE - _frozenAmount;
                _frozenAmount = 0.0;
            } else {
                _frozenAmount = _frozenAmount - _BALANCE;
                _BALANCE = 0.0;
            }
            Double _TRADE_DEPOSIT = Double.parseDouble(TRADE_DEPOSIT);
            if (_TRADE_DEPOSIT > 0.0) {
                _TRADE_DEPOSIT = _TRADE_DEPOSIT / 100.0;
            }
            if (_TRADE_DEPOSIT >= _frozenAmount) {
                _TRADE_DEPOSIT = _TRADE_DEPOSIT - _frozenAmount;
                _frozenAmount = 0.0;
            } else {
                _TRADE_DEPOSIT = 0.0;
            }
            resultMap.put("BALANCE", _BALANCE.toString());
            resultMap.put("TRADE_DEPOSIT", _TRADE_DEPOSIT.toString());
            return resultMap;
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public Map<String, String> getAccountBlanance(HuifuWalletAccount huifuWalletAccount) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(huifuWalletAccount.getUniId(), PaymentChannel.WANGSHANG.toString());
        if (account == null) {
            throw new CrmebWalletException("\u672a\u627e\u5230\u8d26\u6237\u4fe1\u606f\uff01");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", account.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        try {
            wSBusiCode = WSBusiCode.ZHYEQUERY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.ZHYEQUERY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            HashMap<String, String> resultMap = new HashMap<String, String>();
            String BALANCE = response.get("PAY").toString();
            BigDecimal ky = BigDecimal.ZERO;
            if (Double.parseDouble(BALANCE) > 0.0) {
                ky = new BigDecimal(BALANCE).divide(new BigDecimal("100"));
            }
            String ledger_bal = decimalFormat.format(ky);
            resultMap.put("totalAmount", ledger_bal);
            BigDecimal availableAmount = BigDecimal.ZERO;
            if (Double.parseDouble(ledger_bal) > 0.0) {
                availableAmount = ky.subtract(new BigDecimal(account.getFrozenAmount()));
            }
            String aAmount = decimalFormat.format(ky);
            resultMap.put("availableAmount", aAmount);
            resultMap.put("frozenAmount", account.getFrozenAmount());
            return resultMap;
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    private synchronized BigDecimal findBalance(String walletAccountNo) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", walletAccountNo);
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        try {
            wSBusiCode = WSBusiCode.YEQUERY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.YEQUERY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            HashMap resultMap = new HashMap();
            BigDecimal ky = BigDecimal.ZERO;
            String BALANCE = response.get("BALANCE").toString();
            if (!"0".equals(BALANCE)) {
                ky = new BigDecimal(BALANCE);
            }
            String TRADE_DEPOSIT = "0";
            if (response.get("TRADE_DEPOSIT") != null) {
                TRADE_DEPOSIT = response.get("TRADE_DEPOSIT").toString();
            }
            if (!"0".equals(TRADE_DEPOSIT)) {
                ky = ky.add(new BigDecimal(TRADE_DEPOSIT));
            }
            ky = ky.divide(new BigDecimal("100"));
            return ky;
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public PageInfo<HuifuWalletAccountDetail> thisHuifuWalletAccountTradeDetail(HuifuWalletAccountDetailDto dto) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageNumber() == null) {
            throw new CrmebWalletException("\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new CrmebWalletException("\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            throw new CrmebWalletException("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            throw new CrmebWalletException("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dto.setStartDate(dto.getStartDate().replace("-", ""));
        dto.setEndDate(dto.getEndDate().replace("-", ""));
        dto.setIsHideCheck("1");
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<HuifuWalletAccountDetail> detailList = this.huifuWalletAccountDetailDao.selectByUniIdAndDate(dto);
        return new PageInfo(detailList);
    }

    @Override
    public String exportHuifuWalletAccountTradeDetail(HuifuWalletAccountDetailDto dto, HttpServletResponse response) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            throw new CrmebWalletException("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            throw new CrmebWalletException("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "\u6536\u652f\u660e\u7ec6" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u6536\u652f\u660e\u7ec6");
            dto.setStartDate(dto.getStartDate().replace("-", ""));
            dto.setEndDate(dto.getEndDate().replace("-", ""));
            dto.setIsHideCheck("1");
            List<HuifuWalletAccountDetail> detailList = this.huifuWalletAccountDetailDao.selectByUniIdAndDate(dto);
            CellStyle stringStyle = ExcelUtil.getStringStyle((HSSFWorkbook)wb);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));
            String headerTitle = "";
            headerTitle = MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14", detailList.size());
            HSSFCellStyle titleStyle1 = wb.createCellStyle();
            HSSFFont titleFont1 = wb.createFont();
            titleFont1.setFontHeightInPoints((short)11);
            titleFont1.setColor(HSSFColor.RED.index);
            titleFont1.setFontName("\u9ed1\u4f53");
            titleStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle1.setFont(titleFont1);
            titleStyle1.setWrapText(true);
            HSSFRow rowFirst = sheet1.createRow(0);
            rowFirst.setHeight((short)1000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 13));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle1);
            HSSFRow secondFirst = sheet1.createRow(1);
            String[] secondArr = new String[]{"\u5e8f\u53f7", "\u4ea4\u6613\u6d41\u6c34\u53f7", "\u4e1a\u52a1\u6d41\u6c34\u53f7", "\u4ea4\u6613\u7c7b\u578b", "\u4ea4\u6613\u72b6\u6001", "\u521b\u5efa\u65f6\u95f4", "\u4ea4\u6613\u91d1\u989d", "\u4ea4\u6613\u540e\u4f59\u989d", "\u51fa\u8d26\u65b9\u540d\u79f0", "\u51fa\u8d26\u65b9\u5546\u6237\u53f7", "\u5165\u8d26\u65b9\u540d\u79f0", "\u5165\u8d26\u65b9\u5546\u6237\u53f7", "\u4ea4\u6613\u65e5\u671f", "\u4ea4\u6613\u65f6\u95f4", "\u5907\u6ce8", "\u652f\u4ed8\u6e20\u9053"};
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                int column = i == 0 ? 1500 : (i == 5 ? 5000 : (i == 1 || i == 2 || i == 8 || i == 10 ? 10000 : (i == 14 ? 14000 : 4000)));
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(titleStyle);
            }
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                cell.setCellValue(secondArr[i]);
                cell.setCellStyle(titleStyle);
            }
            CellStyle greenStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.SEA_GREEN.index);
            CellStyle redStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.RED.index);
            CellStyle blueStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.BLUE.index);
            HSSFRow row = null;
            int rowIndex = 2;
            for (HuifuWalletAccountDetail result : detailList) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue((double)(rowIndex - 1));
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.getTradeFlowNo() != null ? result.getTradeFlowNo().toString() : null);
                HSSFCell cell1_2 = row.createCell(2);
                cell1_2.setCellValue(result.getFlowNo() != null ? result.getFlowNo().toString() : null);
                HSSFCell cell2 = row.createCell(3);
                cell2.setCellValue(result.getTradeType() != null ? result.getTradeType().toString() : null);
                HSSFCell cell3 = row.createCell(4);
                cell3.setCellValue(result.getHandStatus() != null ? result.getHandStatus().toString() : null);
                if (ObjectUtil.equal((Object)result.getHandStatus(), (Object)"\u6210\u529f")) {
                    cell3.setCellStyle(greenStyle);
                } else if (ObjectUtil.equal((Object)result.getHandStatus(), (Object)"\u5931\u8d25")) {
                    cell3.setCellStyle(redStyle);
                } else {
                    cell3.setCellStyle(blueStyle);
                }
                HSSFCell cell4 = row.createCell(5);
                cell4.setCellValue(result.getCreateDate() != null ? result.getCreateDate().toString() : null);
                HSSFCell cell5 = row.createCell(6);
                cell5.setCellValue(result.getAmount() != null ? result.getAmount().toString() : null);
                cell5.setCellStyle(redStyle);
                HSSFCell cell5_7 = row.createCell(7);
                cell5_7.setCellValue(result.getBalance() != null ? result.getBalance().toString() : null);
                HSSFCell cell6 = row.createCell(8);
                cell6.setCellValue(result.getAccountOutName() != null ? result.getAccountOutName().toString() : null);
                HSSFCell cell7 = row.createCell(9);
                cell7.setCellValue(result.getAccountOut() != null ? result.getAccountOut().toString() : null);
                HSSFCell cell8 = row.createCell(10);
                cell8.setCellValue(result.getAccountInName() != null ? result.getAccountInName().toString() : null);
                HSSFCell cell9 = row.createCell(11);
                cell9.setCellValue(result.getAccountIn() != null ? result.getAccountIn().toString() : null);
                HSSFCell cell10 = row.createCell(12);
                cell10.setCellValue(result.getTradeDate() != null ? result.getTradeDate().toString() : null);
                HSSFCell cell11 = row.createCell(13);
                cell11.setCellValue(result.getAccountsDealDate() != null ? result.getAccountsDealDate().toString() : null);
                HSSFCell cell12 = row.createCell(14);
                cell12.setCellValue(result.getMemo() != null ? result.getMemo().toString() : null);
                HSSFCell cell13 = row.createCell(15);
                cell13.setCellValue(result.getPayChannel() != null ? result.getPayChannel().toString() : null);
                ++rowIndex;
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new CrmebWalletException(e.getMessage());
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return "0";
    }

    @Override
    public String huifuWalletAccountTradeDetailSch() {
        return this.huifuWalletAccountTradeDetailTask("", "");
    }

    @Override
    public String huifuWalletAccountTradeDetailTask(String startDate, String endDate) {
        if (StringUtils.isEmpty((CharSequence)startDate) || StringUtils.isEmpty((CharSequence)endDate)) {
            startDate = DateUtil.formatDate((Date)DateUtil.yesterday());
            endDate = DateUtil.formatDate((Date)DateUtil.date());
        }
        List<HuifuWalletAccountDto> accountList = this.huifuWalletAccountDao.getLastDayTradeHuifuWalletAccount(startDate + " 00:00:00", endDate + " 23:59:59", PaymentChannel.WANGSHANG.toString());
        HashMap kvMap = Maps.newHashMap();
        for (HuifuWalletAccountDto dto : accountList) {
            kvMap.put(dto.getWalletAccountNo(), dto.getComName());
        }
        ArrayList detailList = Lists.newArrayList();
        List<String> existsFlowNoList = this.huifuWalletAccountDetailDao.selectFlowNoByDate(startDate.replace("-", ""), endDate.replace("-", ""), PaymentChannel.WANGSHANG.toString());
        block5: for (HuifuWalletAccountDto account : accountList) {
            int pageNumber = 1;
            try {
                WSBusiCode wSBusiCode;
                Map response;
                HashMap<String, Object> p;
                while (true) {
                    p = new HashMap<String, Object>();
                    p.put("huifuId", account.getWalletAccountNo());
                    p.put("reqSeqId", SequenceTools.getReqSeqId32());
                    p.put("acctDate", startDate.replace("-", ""));
                    p.put("pageNum", pageNumber);
                    p.put("pageSize", 100);
                    response = null;
                    try {
                        wSBusiCode = WSBusiCode.CWQUERY;
                    }
                    catch (Exception e) {
                        this.transactionLogService.save("huifuWalletAccountTradeDetailTask", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
                        throw new CrmebWalletException(e.getMessage());
                    }
                    if (!"00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) break;
                    this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                    if (StringUtils.isEmpty((CharSequence)response.get("result_count").toString()) || Integer.parseInt(response.get("result_count").toString()) == 0) continue block5;
                    ArrayList recordlist = (ArrayList)JSON.parseObject((String)response.get("acct_log_list").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
                    for (Map record : recordlist) {
                        HuifuWalletAccountDetailDto detail = this.packHuifuWalletAccountDetail(record, kvMap);
                        detail.setUniId(account.getUniId());
                        detail.setWalletAccountNo(account.getWalletAccountNo());
                        detail.setPayChannel(PaymentChannel.WANGSHANG.toString());
                        if (existsFlowNoList.contains(detail.getTradeFlowNo() + account.getUniId())) continue;
                        detailList.add(detail);
                    }
                    if (recordlist.size() < 100) continue block5;
                    ++pageNumber;
                }
                this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                this.log.error(WangShangWalletServiceImpl.RET(response, 2));
            }
            catch (Exception e) {}
        }
        if (CollectionUtil.isEmpty((Collection)detailList)) {
            return "1";
        }
        this.huifuWalletAccountDetailDao.insertBatch(detailList);
        return "1";
    }

    @Override
    public void updateBalance(String startDate, String endDate) {
        if (StringUtils.isEmpty((CharSequence)startDate) || StringUtils.isEmpty((CharSequence)endDate)) {
            startDate = DateUtil.formatDate((Date)DateUtil.yesterday());
            endDate = DateUtil.formatDate((Date)DateUtil.date());
        }
        List<HuifuWalletAccountDto> accountList = this.huifuWalletAccountDao.getLastDayTradeHuifuWalletAccount(startDate + " 00:00:00", endDate + " 23:59:59", PaymentChannel.WANGSHANG.toString());
        block4: for (HuifuWalletAccountDto account : accountList) {
            int pageNumber = 1;
            try {
                WSBusiCode wSBusiCode;
                Map response;
                HashMap<String, Object> p;
                while (true) {
                    p = new HashMap<String, Object>();
                    p.put("huifuId", account.getWalletAccountNo());
                    p.put("reqSeqId", SequenceTools.getReqSeqId32());
                    p.put("acctDate", startDate.replace("-", ""));
                    p.put("pageNum", pageNumber);
                    p.put("pageSize", 100);
                    response = null;
                    try {
                        wSBusiCode = WSBusiCode.CWQUERY;
                    }
                    catch (Exception e) {
                        this.transactionLogService.save("huifuWalletAccountTradeDetailTask", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
                        this.log.error(e.getMessage());
                        continue block4;
                    }
                    if (!"00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) break;
                    this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                    if (StringUtils.isEmpty((CharSequence)response.get("result_count").toString()) || Integer.parseInt(response.get("result_count").toString()) == 0) continue block4;
                    ArrayList recordlist = (ArrayList)JSON.parseObject((String)response.get("acct_log_list").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
                    for (Map record : recordlist) {
                        this.huifuWalletAccountDetailDao.updateBalance(account.getUniId(), record.get("hfSeqId").toString(), record.get("balance_amt").toString());
                    }
                    if (recordlist.size() < 100) continue block4;
                    ++pageNumber;
                }
                this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                this.log.error(WangShangWalletServiceImpl.RET(response, 2));
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void payTradeDetailTaskSch() {
        List<Map<String, String>> list = this.huifuWalletTradeDao.findHuifuWalletTradeByDay(PaymentChannel.WANGSHANG.toString());
        for (Map<String, String> map : list) {
            this.getPayTradeDetailTask(map.get("uniId"), map.get("accountNo"), map.get("hfSeqId"), map.get("tradeDate"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void getPayTradeDetailTask(String uniId, String accountNo, String hfSeqId, String tradeDate) {
        block28: {
            String lockId = SCHKEY + hfSeqId;
            RLock lock = this.redisson.getLock(lockId);
            try {
                Map<String, Object> response;
                WSBusiCode wSBusiCode;
                if (!lock.tryLock(3L, 10L, TimeUnit.SECONDS)) break block28;
                logger.debug(lockId + ":getLock: " + Thread.currentThread().getId());
                HuifuWalletAccountDto aDto = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(uniId, PaymentChannel.WANGSHANG.toString());
                HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(hfSeqId);
                int cf = this.huifuWalletAccountDetailDao.checkFlowNo(trade.getReqSeqId(), aDto.getUniId());
                if (cf > 0) {
                    return;
                }
                HashMap<String, Object> p = new HashMap<String, Object>();
                p.put("hfSeqId", trade.getHfSeqId());
                p.put("reqSeqId", trade.getReqSeqId());
                try {
                    wSBusiCode = WSBusiCode.DKQUERY;
                    response = WSApiRequest.api(wSBusiCode, p);
                }
                catch (Exception e) {
                    this.transactionLogService.save(WSBusiCode.DKQUERY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
                    throw new CrmebException(e.getMessage());
                }
                if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
                    this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                    HuifuWalletTrade huifuWalletTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(hfSeqId);
                    String transStat = response.get("trans_stat").toString();
                    if ("SUCCESS".equals(transStat)) {
                        huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"S"));
                    } else {
                        huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"F"));
                    }
                    huifuWalletTrade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)response.get("trans_finish_time").toString(), (String)"yyyyMMddHHmmss")));
                    huifuWalletTrade.setUpdateTime(new Date());
                    this.huifuWalletTradeDao.updateById(huifuWalletTrade);
                    ArrayList detailList = Lists.newArrayList();
                    HuifuWalletAccountDetailDto detail = new HuifuWalletAccountDetailDto();
                    detail.setUniId(huifuWalletTrade.getUniId());
                    detail.setWalletAccountNo(aDto.getWalletAccountNo());
                    detail.setTradeDate(DateUtils.formatDate((Date)trade.getCreateTime(), (Object[])new Object[]{"yyyyMMdd"}));
                    detail.setTradeFlowNo(trade.getHfSeqId());
                    detail.setFlowNo(trade.getReqSeqId());
                    detail.setAccountsDealType("\u5185\u90e8\u6237\u5904\u7406");
                    detail.setAccountsDealDate(response.get("trans_finish_time").toString());
                    detail.setAmount(new BigDecimal(response.get("ord_amt").toString()).divide(new BigDecimal("100")).toString());
                    detail.setDirection("\u51fa\u8d26");
                    transStat = transStat.equals("SUCCESS") ? "\u6210\u529f" : (transStat.equals("FAIL") ? "\u5931\u8d25" : "\u5904\u7406\u4e2d");
                    detail.setHandStatus(transStat);
                    String tradeType = StringUtils.isNotEmpty((CharSequence)huifuWalletTrade.getRemark()) && huifuWalletTrade.getRemark().contains("\u9000\u6b3e") ? "\u53cd\u5411\u4ea4\u6613" : "\u6b63\u5411\u4ea4\u6613";
                    detail.setTradeType(tradeType);
                    detail.setCreateDate(DateUtils.formatDate((Date)huifuWalletTrade.getCreateTime(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
                    detail.setServiceType("\u5b9e\u65f6");
                    detail.setAccountIn(trade.getIncomeAccountNo());
                    detail.setAccountOut(trade.getExpendAccountNo());
                    detail.setMemo(trade.getRemark());
                    detail.setPayChannel(huifuWalletTrade.getPayChannel());
                    HuifuWalletAccountDto accountIn = null;
                    HuifuWalletAccountDto accountOut = null;
                    if (StringUtil.isEmpty((String)detail.getAccountIn())) {
                        detail.setAccountInName("\u65e0");
                    } else {
                        accountIn = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(detail.getAccountIn());
                        detail.setAccountInName(StringUtils.isEmpty((CharSequence)accountIn.getComName()) ? "\u65e0" : accountIn.getComName());
                    }
                    if (StringUtil.isEmpty((String)detail.getAccountOut())) {
                        detail.setAccountOutName("\u65e0");
                    } else {
                        accountOut = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(detail.getAccountOut());
                        detail.setAccountOutName(StringUtils.isEmpty((CharSequence)accountOut.getComName()) ? "\u65e0" : accountOut.getComName());
                    }
                    if (accountOut != null && accountIn != null) {
                        int count = this.huifuWalletAccountDetailDao.checkFlowNo(detail.getTradeFlowNo(), detail.getUniId());
                        if (count == 0) {
                            detailList.add(detail);
                        }
                        HuifuWalletAccountDetailDto detail2 = new HuifuWalletAccountDetailDto();
                        BeanUtils.copyProperties((Object)detail, (Object)detail2);
                        detail2.setUniId(accountIn.getUniId());
                        detail2.setWalletAccountNo(accountIn.getWalletAccountNo());
                        detail2.setDirection("\u5165\u8d26");
                        count = this.huifuWalletAccountDetailDao.checkFlowNo(detail2.getTradeFlowNo(), detail2.getUniId());
                        if (count == 0) {
                            detailList.add(detail2);
                        }
                    } else if (accountOut != null && accountIn == null) {
                        int count = this.huifuWalletAccountDetailDao.checkFlowNo(detail.getTradeFlowNo(), detail.getUniId());
                        if (count == 0) {
                            detailList.add(detail);
                        }
                    } else if (accountIn != null && accountOut == null) {
                        detail.setDirection("\u5165\u8d26");
                        int count = this.huifuWalletAccountDetailDao.checkFlowNo(detail.getTradeFlowNo(), detail.getUniId());
                        if (count == 0) {
                            detailList.add(detail);
                        }
                    }
                    if (detailList.size() > 0) {
                        this.huifuWalletAccountDetailDao.insertBatch(detailList);
                    }
                } else {
                    this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                    logger.error(WangShangWalletServiceImpl.RET(response, 2));
                }
            }
            catch (InterruptedException e) {
                logger.error("huifuWalletRechargeCallback error", (Throwable)e);
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    logger.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                    lock.unlock();
                }
            }
        }
    }

    @Override
    public void tradeDetailTask(String accountNo, String hfSeqId, int ordType) throws CrmebWalletException {
        try {
            WSBusiCode wSBusiCode;
            HashMap<String, String> p = new HashMap<String, String>();
            p.put("huifuId", accountNo);
            p.put("hfSeqId", hfSeqId);
            p.put("ordType", ordType == 1 ? "consume" : "refund");
            Map response = null;
            try {
                wSBusiCode = WSBusiCode.JYFZQUERY;
            }
            catch (Exception e) {
                this.transactionLogService.save("tradeDetailTask", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
                throw new CrmebWalletException(e.getMessage());
            }
            if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                if (StringUtils.isEmpty((CharSequence)response.get("total_size").toString()) || Integer.parseInt(response.get("total_size").toString()) == 0) {
                    return;
                }
                ArrayList recordlist = (ArrayList)JSON.parseObject((String)response.get("split_trans_responses").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
                HuifuWalletTrade huifuWalletTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(hfSeqId);
                ArrayList detailList = Lists.newArrayList();
                for (Map record : recordlist) {
                    HuifuWalletAccountDto account;
                    HuifuWalletAccountDetailDto detail = new HuifuWalletAccountDetailDto();
                    detail.setUniId(huifuWalletTrade.getUniId());
                    detail.setWalletAccountNo(accountNo);
                    String direction = record.get("ord_type").toString();
                    String splitType = record.get("split_type").toString();
                    detail.setTradeFlowNo(record.get("hfSeqId").toString());
                    detail.setFlowNo(record.get("trans_ord_id").toString());
                    detail.setAccountsDealType("\u5185\u90e8\u6237\u5904\u7406");
                    detail.setAccountsDealDate(record.get("trans_finish_time").toString());
                    detail.setAmount(record.get("split_amt").toString());
                    detail.setDirection("consume".equals(direction) ? "\u51fa\u8d26" : "\u5165\u8d26");
                    detail.setHandStatus("\u6210\u529f");
                    detail.setTradeType("consume".equals(direction) ? "\u6b63\u5411\u4ea4\u6613" : "\u53cd\u5411\u4ea4\u6613");
                    detail.setCreateDate(DateUtils.formatDate((Date)huifuWalletTrade.getCreateTime(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}));
                    detail.setTradeDate(DateUtils.formatDate((Date)huifuWalletTrade.getCreateTime(), (Object[])new Object[]{"yyyyMMdd"}));
                    detail.setServiceType("realTime".equals(splitType) ? "\u5b9e\u65f6" : "\u5ef6\u65f6");
                    detail.setAccountIn(record.get("in_huifu_id").toString());
                    detail.setAccountOut(record.get("huifu_id").toString());
                    detail.setPayChannel(huifuWalletTrade.getPayChannel());
                    if (StringUtil.isEmpty((String)detail.getAccountIn())) {
                        detail.setAccountInName("\u65e0");
                    } else {
                        account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(detail.getAccountIn());
                        detail.setAccountInName(StringUtils.isEmpty((CharSequence)account.getComName()) ? "\u65e0" : account.getComName());
                    }
                    if (StringUtil.isEmpty((String)detail.getAccountOut())) {
                        detail.setAccountOutName("\u65e0");
                    } else {
                        account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(detail.getAccountOut());
                        detail.setAccountOutName(StringUtils.isEmpty((CharSequence)account.getComName()) ? "\u65e0" : account.getComName());
                    }
                    detail.setMemo(huifuWalletTrade.getRemark());
                    int count = this.huifuWalletAccountDetailDao.checkFlowNo(detail.getTradeFlowNo(), detail.getUniId());
                    if (count <= 0) continue;
                    detailList.add(detail);
                }
                if (detailList.size() > 0) {
                    this.huifuWalletAccountDetailDao.insertBatch(detailList);
                }
            } else {
                this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                this.log.error(WangShangWalletServiceImpl.RET(response, 2));
            }
        }
        catch (Exception e) {
            throw new CrmebWalletException(e.getMessage());
        }
    }

    private HuifuWalletAccountDetailDto packHuifuWalletAccountDetail(Map<String, Object> record, Map<String, String> kvMap) {
        String direction = record.get("debit_type").toString();
        HuifuWalletAccountDetailDto detail = new HuifuWalletAccountDetailDto();
        detail.setTradeDate(record.get("trans_date_time").toString());
        detail.setTradeFlowNo(record.get("hfSeqId").toString());
        detail.setFlowNo(record.get("acct_log_id").toString());
        detail.setAccountsDealType("\u5185\u90e8\u6237\u5904\u7406");
        detail.setAccountsDealDate(record.get("acct_date").toString());
        detail.setAmount(record.get("trans_amt").toString());
        detail.setBalance(record.get("balance_amt").toString());
        detail.setDirection("D".equals(direction) ? "\u51fa\u8d26" : "\u5165\u8d26");
        detail.setHandStatus("\u6210\u529f");
        detail.setTradeType(record.get("acct_trans_type").toString());
        return detail;
    }

    @Override
    public String getWalletRechargeToken(HuifuWalletAccountDto dto) throws CrmebWalletException {
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getWalletAccountNo())) {
            throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305\u8d26\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAmount() == null) {
            throw new CrmebWalletException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getAmount().compareTo(new BigDecimal("8.00")) < 1) {
            throw new CrmebWalletException("\u91d1\u989d\u5fc5\u987b\u5927\u4e8e8.00\u5143");
        }
        BigDecimal fzAmt = new BigDecimal("8.00");
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(dto.getWalletAccountNo());
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("acctId", dto.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("transAmt", decimalFormat.format(dto.getAmount()));
        p.put("divAmt", decimalFormat.format(dto.getAmount().subtract(fzAmt)));
        p.put("bankId", "");
        p.put("goodsDesc", "\u8d26\u6237\u4f59\u989d\u5145\u503c");
        p.put("orderType", "P");
        p.put("frontUrl", this.systemConfigService.getValueByKey("front_pay_callback_url") + "/payWallet/success");
        p.put("notifyUrl", this.systemConfigService.getValueByKey("hf_api_url") + "/api/front/wallet/huifuWalletRechargeCallback");
        Map response = null;
        try {
            wSBusiCode = WSBusiCode.WYPAY;
        }
        catch (Exception e) {
            this.transactionLogService.save("getWalletRechargeToken", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
            huifuWalletTrade.setUniId(account.getUniId());
            huifuWalletTrade.setHfSeqId(response.get("hfSeqId").toString());
            huifuWalletTrade.setIncomeAccountNo(account.getWalletAccountNo());
            huifuWalletTrade.setReqSeqId(response.get("reqSeqId").toString());
            huifuWalletTrade.setAmount(new BigDecimal(response.get("trans_amt").toString()));
            huifuWalletTrade.setGoodDesc("\u4f59\u989d+" + response.get("trans_amt") + "\u5143");
            huifuWalletTrade.setRemark("\u8d26\u6237\u4f59\u989d\u5145\u503c\uff08\u624b\u7eed\u8d39" + decimalFormat.format(fzAmt) + "\u5143\uff09");
            huifuWalletTrade.setErrorMsg(WangShangWalletServiceImpl.RET(response, 2));
            huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)response.get("trans_stat").toString()));
            huifuWalletTrade.setTradeType("01");
            huifuWalletTrade.setCreateTime(new Date());
            huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
            this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
            return response.get("form_url").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String huifuWalletRechargeCallback(HuifuRequestDataDto dto) {
        this.transactionLogService.save("huifuWalletRechargeCallback", "1", JSON.toJSONString((Object)dto), "ok", PaymentChannel.WANGSHANG.toString());
        if (!"00000000".equals(dto.getResp_code())) {
            return "";
        }
        if (!RsaUtils.verify((String)dto.getData(), (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsfgsLgysfEWahRJsczK4pox8qno3VIg9kBq7OBJcU/LBaGB+zaP3IU48tUH0ByE/7hO8VVtDy7EUJi0sMQgV57i0aU0FE6hXNnYw8mkkch08KkFhBD/UNxgTlr9fFScGkoB4uree3UbraZHPeeGc5ZB5nqlrcT64RT6Q19zP3zGAsTfR4YSRSV3zwg5eiJXfnwvRxKfjVUwg8TdhAZg5D+q1LrrAyKr7OcDHQ5z6uICBudp8E/mTvZEeUwB31qcY5viWQjtLnJ10qCPrhpf4N9MCYdVBpKh9Y1NklBHvb5Cui9bGzdnayOpDgGJ0SyIQvQGdNeJMlsQO3BNId4JzTwIDAQAB", (String)dto.getSign())) {
            logger.info("\u4f01\u4e1a\u94b1\u5305\u5145\u503c\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0cfail=\u9a8c\u7b7e\u5931\u8d25");
            return "";
        }
        Map response = (Map)JSON.parseObject((String)dto.getData(), Map.class);
        String status = Constants.tradeStatus((String)response.get("trans_stat").toString());
        String reqSeqId = response.get("reqSeqId").toString();
        String lockId = TRANSFERKEY + reqSeqId;
        RLock lock = this.redisson.getLock(lockId);
        try {
            if (lock.tryLock(3L, 10L, TimeUnit.SECONDS)) {
                logger.debug(lockId + ":getLock: " + Thread.currentThread().getId());
                HuifuWalletTrade huifuWalletTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(response.get("hfSeqId").toString());
                if (status.equals(huifuWalletTrade.getTradeStatus())) {
                    String string = "RECV_ORD_ID_" + huifuWalletTrade.getHfSeqId();
                    return string;
                }
                Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                    huifuWalletTrade.setTransFinishTime(response.get("trans_date") + "" + response.get("trans_time"));
                    huifuWalletTrade.setErrorMsg(WangShangWalletServiceImpl.RET(response, 2));
                    huifuWalletTrade.setTradeStatus(status);
                    huifuWalletTrade.setUpdateTime(new Date());
                    this.huifuWalletTradeDao.updateHuifuWalletTrade(huifuWalletTrade);
                    logger.info("\u4f01\u4e1a\u94b1\u5305\u5145\u503c\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc2={},errorMsg={}", (Object)reqSeqId, (Object)huifuWalletTrade.getErrorMsg());
                    return Boolean.TRUE;
                });
                if (!execute.booleanValue()) {
                    logger.error("\u4f01\u4e1a\u94b1\u5305\u5145\u503c\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5165\u5e93\u5931\u8d25\uff0crequest={}", (Object)response.get("resp_data").toString());
                    String string = "";
                    return string;
                }
                String string = "RECV_ORD_ID_" + reqSeqId;
                return string;
            }
            String huifuWalletTrade = "";
            return huifuWalletTrade;
        }
        catch (InterruptedException e2) {
            logger.error("huifuWalletRechargeCallback error", (Throwable)e2);
            String string = "";
            return string;
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                logger.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String huifuWalletExtractCallback(String messageBody) {
        Map<String, Object> response = this.pathToJson(messageBody);
        logger.info("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0c\u53c2\u6570\uff0cresponse={}", (Object)response.toString());
        this.transactionLogService.save("huifuWalletExtractCallback", "1", response.toString(), "ok", PaymentChannel.WANGSHANG.toString());
        if (!"00000000".equals(response.get("resp_code").toString())) {
            return "ok";
        }
        String sign = response.get("sign").toString();
        if (!RsaUtils.verify((String)response.get("resp_data").toString(), (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsfgsLgysfEWahRJsczK4pox8qno3VIg9kBq7OBJcU/LBaGB+zaP3IU48tUH0ByE/7hO8VVtDy7EUJi0sMQgV57i0aU0FE6hXNnYw8mkkch08KkFhBD/UNxgTlr9fFScGkoB4uree3UbraZHPeeGc5ZB5nqlrcT64RT6Q19zP3zGAsTfR4YSRSV3zwg5eiJXfnwvRxKfjVUwg8TdhAZg5D+q1LrrAyKr7OcDHQ5z6uICBudp8E/mTvZEeUwB31qcY5viWQjtLnJ10qCPrhpf4N9MCYdVBpKh9Y1NklBHvb5Cui9bGzdnayOpDgGJ0SyIQvQGdNeJMlsQO3BNId4JzTwIDAQAB", (String)sign)) {
            logger.info("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0cfail=\u9a8c\u7b7e\u5931\u8d25");
            return "";
        }
        JSONObject dataObj = JSON.parseObject((String)response.get("resp_data").toString());
        String reqSeqId = dataObj.getString("reqSeqId");
        String lockId = TRANSFERKEY + reqSeqId;
        RLock lock = this.redisson.getLock(lockId);
        try {
            if (lock.tryLock(3L, 10L, TimeUnit.SECONDS)) {
                logger.debug(lockId + ":getLock: " + Thread.currentThread().getId());
                HuifuWalletTrade huifuWalletTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(dataObj.get((Object)"hfSeqId").toString());
                if ("1".equals(huifuWalletTrade.getTradeStatus())) {
                    logger.info("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc1={}", (Object)reqSeqId);
                    String string = "RECV_ORD_ID_" + reqSeqId;
                    return string;
                }
                Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                    huifuWalletTrade.setTransFinishTime(dataObj.get((Object)"req_date").toString());
                    huifuWalletTrade.setErrorMsg(WangShangWalletServiceImpl.RET(response, 2));
                    huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)dataObj.get((Object)"trans_stat").toString()));
                    huifuWalletTrade.setUpdateTime(new Date());
                    this.huifuWalletTradeDao.updateHuifuWalletTrade(huifuWalletTrade);
                    logger.info("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5f00\u59cb\uff0csucc2={},errorMsg={}", (Object)reqSeqId, (Object)huifuWalletTrade.getErrorMsg());
                    return Boolean.TRUE;
                });
                if (!execute.booleanValue()) {
                    logger.error("\u4f01\u4e1a\u94b1\u5305\u63d0\u73b0\u56de\u8c03\uff0c\u5f02\u6b65\u56de\u8c03\u5165\u5e93\u5931\u8d25\uff0crequest={}", (Object)response.get("resp_data").toString());
                    String string = "";
                    return string;
                }
                String string = "RECV_ORD_ID_" + reqSeqId;
                return string;
            }
            String huifuWalletTrade = "";
            return huifuWalletTrade;
        }
        catch (InterruptedException e2) {
            logger.error("huifuWalletExtractCallback error", (Throwable)e2);
            String string = "";
            return string;
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                logger.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                lock.unlock();
            }
        }
    }

    private Map<String, Object> pathToJson(String urlData) {
        String data = null;
        try {
            data = URLDecoder.decode(urlData, "UTF-8");
        }
        catch (Exception e) {
            logger.error("\u89e3\u7801\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        Map collect = Arrays.stream(data.split("&")).map(str -> str.split("=")).collect(Collectors.toMap(x -> x[0], x -> ((String[])x).length == 2 ? x[1] : "", (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        return collect;
    }

    @Override
    public HuifuWalletTrade getWalletTradeInfo(HuifuWalletTrade huifuWalletTrade) throws CrmebWalletException {
        if (huifuWalletTrade.getId() == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        huifuWalletTrade = this.huifuWalletTradeDao.getHuifuWalletTradeById(huifuWalletTrade.getId());
        return huifuWalletTrade;
    }

    @Override
    public List<HuifuWalletTrade> getHuifuWalletTradeBySeqAndCode(HuifuWalletTrade huifuWalletTrade) throws CrmebWalletException {
        if (huifuWalletTrade.getBusinessCode() == null) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<HuifuWalletTrade> list = this.huifuWalletTradeDao.getHuifuWalletTradeBySeqAndCode(huifuWalletTrade);
        return list;
    }

    @Override
    public String huifuWalletAccountExtract(HuifuWalletAccountDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        String fee;
        Date date = new Date();
        if (dto.getAmount() == null) {
            throw new CrmebWalletException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getUniId(), PaymentChannel.WANGSHANG.toString());
        Map<String, String> map = this.getHuifuWalletAccountAmount((HuifuWalletAccount)account);
        if (map != null && map.get("availableAmount") != null) {
            BigDecimal availableAmount = new BigDecimal(String.valueOf(map.get("availableAmount")));
            if (availableAmount.compareTo(dto.getAmount()) < 0) {
                throw new CrmebWalletException("\u63d0\u73b0\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u7528\u4f59\u989d");
            }
        } else {
            throw new CrmebWalletException("\u672a\u8bfb\u53d6\u5230\u8d26\u6237\u4f59\u989d\u76f8\u5173\u4fe1\u606f");
        }
        String cashAmt = dto.getAmount().multiply(BigDecimal.valueOf(100L)).intValue() + "";
        BigDecimal bdFee = new BigDecimal(cashAmt).multiply(new BigDecimal(fee = "0.0005"));
        bdFee = bdFee.intValue() < 1 ? BigDecimal.ONE : bdFee.setScale(0, RoundingMode.DOWN);
        String platformFee = bdFee.intValue() + "";
        HashMap<String, Object> p = new HashMap<String, Object>();
        String reqSeqId = SequenceTools.getReqSeqId32();
        p.put("merchantId", account.getWalletAccountNo());
        p.put("reqSeqId", reqSeqId);
        p.put("cashAmt", cashAmt);
        p.put("platformFee", platformFee);
        try {
            wSBusiCode = WSBusiCode.ENCHASHMENT;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e2) {
            this.transactionLogService.save("huifuWalletAccountExtract", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
                huifuWalletTrade.setReqSeqId(reqSeqId);
                huifuWalletTrade.setHfSeqId(response.get("orderNo").toString());
                huifuWalletTrade.setBusinessPartnerSeq(response.get("orderNo").toString());
                huifuWalletTrade.setBusinessCode("1");
                huifuWalletTrade.setCreateTime(date);
                huifuWalletTrade.setUpdateTime(new Date());
                huifuWalletTrade.setUniId(account.getUniId());
                huifuWalletTrade.setExpendAccountNo(account.getWalletAccountNo());
                huifuWalletTrade.setAmount(dto.getAmount());
                huifuWalletTrade.setGoodDesc("\u4f59\u989d-" + dto.getAmount() + "\u5143");
                huifuWalletTrade.setRemark("\u8d26\u6237\u4f59\u989d\u63d0\u73b0");
                huifuWalletTrade.setTradeType("02");
                huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"P"));
                huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
                String platFeeD = new BigDecimal(platformFee).divide(new BigDecimal("100")).toString();
                huifuWalletTrade = new HuifuWalletTrade();
                huifuWalletTrade.setReqSeqId(reqSeqId + "FEE");
                huifuWalletTrade.setHfSeqId(response.get("orderNo").toString() + "FEE");
                huifuWalletTrade.setBusinessPartnerSeq(response.get("orderNo").toString() + "FEE");
                huifuWalletTrade.setBusinessCode("1");
                huifuWalletTrade.setCreateTime(date);
                huifuWalletTrade.setUpdateTime(new Date());
                huifuWalletTrade.setUniId(account.getUniId());
                huifuWalletTrade.setExpendAccountNo(account.getWalletAccountNo());
                huifuWalletTrade.setAmount(new BigDecimal(platFeeD));
                huifuWalletTrade.setGoodDesc("\u624b\u7eed\u8d39-" + platFeeD + "\u5143");
                huifuWalletTrade.setRemark("\u63d0\u73b0\u5355\uff1a" + response.get("orderNo").toString() + "\u6263\u9664\u624b\u7eed\u8d39" + platFeeD + "\u5143\uff08\uff09");
                huifuWalletTrade.setTradeType("02");
                huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"P"));
                huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u63d0\u73b0-\u64cd\u4f5c\u5931\u8d25");
            }
            return response.get("orderNo").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String huifuWalletAccountExtractConfirm(HuifuWalletAccountDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        Date date = new Date();
        if (StringUtil.isEmpty((String)dto.getOrderNo())) {
            throw new CrmebWalletException("\u8ba2\u5355\u53f7\u4e22\u5931");
        }
        if (StringUtil.isEmpty((String)dto.getContactPhone())) {
            throw new CrmebWalletException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getActiveCode())) {
            throw new CrmebWalletException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(dto.getOrderNo());
        if (trade == null) {
            throw new CrmebWalletException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        String reqSeqId = SequenceTools.getReqSeqId32();
        p.put("merchantId", trade.getExpendAccountNo());
        p.put("reqSeqId", reqSeqId);
        p.put("cashAmt", trade.getAmount().multiply(new BigDecimal("100")).toString().replace(".00", ""));
        p.put("smsCode", dto.getActiveCode());
        p.put("orderNo", dto.getOrderNo());
        HuifuWalletTrade tradeFee = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(dto.getOrderNo() + "FEE");
        if (tradeFee != null) {
            p.put("platformFee", tradeFee.getAmount().multiply(new BigDecimal("100")).toString().replace(".00", ""));
        }
        try {
            wSBusiCode = WSBusiCode.ENCHASHMENTCONFIRM;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e2) {
            this.transactionLogService.save(WSBusiCode.ENCHASHMENTCONFIRM.toString(), "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                HuifuWalletTrade wTrade = (HuifuWalletTrade)this.huifuWalletTradeDao.selectById(trade.getId());
                wTrade.setReqSeqId(reqSeqId);
                wTrade.setUpdateTime(new Date());
                this.huifuWalletTradeDao.updateById(wTrade);
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u63d0\u73b0\u786e\u8ba4-\u64cd\u4f5c\u5931\u8d25");
            }
            return "1";
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
            trade.setUpdateTime(new Date());
            trade.setErrorMsg(WangShangWalletServiceImpl.RET(response, 2));
            trade.setTradeStatus("F");
            this.huifuWalletTradeDao.updateById(trade);
            if (tradeFee != null) {
                tradeFee.setUpdateTime(new Date());
                tradeFee.setErrorMsg(WangShangWalletServiceImpl.RET(response, 2));
                tradeFee.setTradeStatus("F");
                this.huifuWalletTradeDao.updateById(tradeFee);
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u63d0\u73b0\u786e\u8ba4-\u64cd\u4f5c\u5931\u8d25");
        }
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String refundQuery(HuifuWalletAccountDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(dto.getOrderNo());
        HuifuWalletTranslog translog = this.huifuWalletTranslogDao.getByTransId(dto.getOrderNo());
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", translog.getCardNo());
        p.put("orderNo", trade.getHfSeqId());
        p.put("reqSeqId", trade.getReqSeqId());
        try {
            String relateOrderNo = StringUtil.isEmpty((String)trade.getRemark()) ? "" : trade.getRemark().split("\uff08")[1].split("\uff09")[0];
            p.put("relateOrderNo", relateOrderNo);
        }
        catch (Exception relateOrderNo) {
            // empty catch block
        }
        try {
            wSBusiCode = WSBusiCode.BREFUNDQUERY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save("refundQuery", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            return JSON.toJSONString(response);
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String batchQuery(HuifuWalletAccountDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)dto.getOrderNo()) && (StringUtils.isEmpty((CharSequence)dto.getStartDate()) || StringUtils.isEmpty((CharSequence)dto.getEndDate()))) {
            throw new CrmebWalletException("\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getUniId(), PaymentChannel.WANGSHANG.toString());
        Map<String, String> map = this.requestHuifuWalletAmount(dto.getUniId());
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("merchantId", account.getWalletAccountNo());
        p.put("orderNo", dto.getOrderNo());
        p.put("TRADE_DEPOSIT", map.get("TRADE_DEPOSIT"));
        if (StringUtil.isNotEmpty((String)dto.getStartDate())) {
            p.put("startTime", dto.getStartDate().replace("-", ""));
        }
        if (StringUtil.isNotEmpty((String)dto.getEndDate())) {
            p.put("endTime", dto.getEndDate().replace("-", ""));
        }
        try {
            wSBusiCode = WSBusiCode.BATCHQUERY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save("refundQuery", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            if (response.get("vostroInfoList") != null) {
                return JSON.toJSONString((Object)response.get("vostroInfoList"));
            }
            return "";
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String refundApply(HuifuWalletAccountDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        Date date = new Date();
        if (dto.getAmount() == null) {
            throw new CrmebWalletException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getUniId(), PaymentChannel.WANGSHANG.toString());
        Map<String, String> map = this.getHuifuWalletAccountAmount((HuifuWalletAccount)account);
        if (map != null && map.get("TRADE_DEPOSIT") != null) {
            BigDecimal availableAmount = new BigDecimal(String.valueOf(map.get("TRADE_DEPOSIT")));
            if (availableAmount.compareTo(dto.getAmount()) < 0) {
                throw new CrmebWalletException("\u53ef\u9000\u91d1\u989d\u53d1\u751f\u53d8\u5316\u8bf7\u5237\u65b0\u5217\u8868\u91cd\u8bd5");
            }
        } else {
            throw new CrmebWalletException("\u672a\u8bfb\u53d6\u5230\u8d26\u6237\u4f59\u989d\u76f8\u5173\u4fe1\u606f");
        }
        String cashAmt = dto.getAmount().multiply(BigDecimal.valueOf(100L)).intValue() + "";
        HashMap<String, Object> p = new HashMap<String, Object>();
        String reqSeqId = SequenceTools.getReqSeqId32();
        p.put("merchantId", account.getWalletAccountNo());
        p.put("reqSeqId", reqSeqId);
        p.put("refundAmount", cashAmt);
        p.put("orderNo", dto.getOrderNo());
        try {
            wSBusiCode = WSBusiCode.REFUNDAPPLY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e2) {
            this.transactionLogService.save("refundQuery", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
                huifuWalletTrade.setReqSeqId(reqSeqId);
                huifuWalletTrade.setHfSeqId(response.get("orderNo").toString());
                huifuWalletTrade.setBusinessPartnerSeq(response.get("orderNo").toString());
                huifuWalletTrade.setBusinessCode("1");
                huifuWalletTrade.setCreateTime(date);
                huifuWalletTrade.setUpdateTime(new Date());
                huifuWalletTrade.setUniId(account.getUniId());
                huifuWalletTrade.setExpendAccountNo(account.getWalletAccountNo());
                huifuWalletTrade.setAmount(dto.getAmount());
                huifuWalletTrade.setGoodDesc("\u4f59\u989d-" + dto.getAmount() + "\u5143");
                huifuWalletTrade.setRemark("\u8d26\u6237\u539f\u5145\u503c\u8ba2\u5355\uff08" + dto.getOrderNo() + "\uff09\u539f\u8def\u9000\u56de\uff1a" + dto.getAmount() + "\u5143");
                huifuWalletTrade.setTradeType("02");
                huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"P"));
                huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
                HuifuWalletTranslog translog = new HuifuWalletTranslog();
                translog.setCardNo(dto.getCardNo());
                translog.setCardName(dto.getCardName());
                translog.setUniId(dto.getUniId());
                translog.setCreateTime(new Date());
                translog.setTransId(response.get("orderNo").toString());
                translog.setTransAmt(dto.getAmount().toString());
                translog.setRemark(huifuWalletTrade.getRemark());
                translog.setTransStat("\u5904\u7406\u4e2d");
                translog.setFeeAmt("0.00");
                translog.setTransType("\u9000\u6b3e");
                translog.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletTranslogDao.insert(translog);
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u63d0\u73b0-\u64cd\u4f5c\u5931\u8d25");
            }
            return response.get("orderNo").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String huifuWalletAccountRefundApply(HuifuWalletAccountDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        Date date = new Date();
        if (StringUtil.isEmpty((String)dto.getOrderNo())) {
            throw new CrmebWalletException("\u8ba2\u5355\u53f7\u4e22\u5931");
        }
        HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(dto.getOrderNo());
        if (trade == null) {
            throw new CrmebWalletException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("outType", "1");
        p.put("merchantId", trade.getIncomeAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("cashAmt", trade.getAmount().multiply(new BigDecimal("100")).toString().replace(".00", ""));
        p.put("oldReqSeqId", trade.getHfSeqId());
        p.put("orderNo", trade.getOrderNo());
        p.put("reason", "\u9000\u6b3e\u539f\u56e0");
        p.put("memo", "\u9000\u6b3e");
        try {
            wSBusiCode = WSBusiCode.XYREFUNDAPPLY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.XYREFUNDAPPLY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            return response.get("orderNo").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public Map<String, Object> huifuWalletAccountRefundQuery(HuifuWalletAccountDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        Date date = new Date();
        if (StringUtil.isEmpty((String)dto.getOrderNo())) {
            throw new CrmebWalletException("\u8ba2\u5355\u53f7\u4e22\u5931");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("outType", "1");
        p.put("oldHfSeqId", "202507562462963086");
        p.put("merchantId", "226801000196320389561");
        p.put("reqSeqId", "202507251619519437rcc33zfq9blg3");
        p.put("hfSeqId", dto.getOrderNo());
        try {
            WSBusiCode wSBusiCode = WSBusiCode.XYREFUNDQUERY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.XYREFUNDQUERY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            return response;
        }
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public Map<String, Object> executeReconcile(String tradeDate) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)tradeDate)) {
            throw new CrmebException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("fileDate", tradeDate);
        try {
            wSBusiCode = WSBusiCode.ZDQUERY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.ZDQUERY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            return response;
        }
        this.transactionLogService.save("executeReconcile", "0", JSONObject.toJSONString(p), WangShangWalletServiceImpl.RET(response, 2), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String freeze(HuifuWalletTransferDto dto) throws CrmebWalletException {
        dto.setTradeType("04");
        return this.huifuWalletAccountLock(dto);
    }

    @Override
    public String thaw(HuifuWalletTransferDto dto) throws CrmebWalletException {
        dto.setTradeType("05");
        return this.huifuWalletAccountLock(dto);
    }

    @Override
    public String huifuWalletAccountLock(HuifuWalletTransferDto dto) throws CrmebWalletException {
        HuifuWalletAccountDto platAccount;
        HuifuWalletAccountDto inAccount;
        String lockAmount;
        String platBusinessPartnerSeq;
        String businessPartnerSeq;
        logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.param:" + JSON.toJSONString((Object)dto));
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new CrmebWalletException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("05".equals(dto.getTradeType())) {
            Order order = this.orderService.getByOrderNo(dto.getBusinessPartnerSeq());
            businessPartnerSeq = order.getPlatOrderNo() + "Y" + dto.getBusinessPartnerSeq();
            platBusinessPartnerSeq = order.getPlatOrderNo() + "-P" + dto.getSellFeePriority() + "Y" + dto.getBusinessPartnerSeq();
            int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(businessPartnerSeq, dto.getTradeType());
            if (countTrade > 0) {
                logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff0cBusinessPartnerSeq=" + dto.getBusinessPartnerSeq());
                return "";
            }
            int isThaw = this.huifuWalletTradeDao.calculateTheThawingAmounByReq(order.getPlatOrderNo(), dto.getAmount(), "-P");
            if (isThaw == 0) {
                throw new CrmebWalletException("\u5f53\u524d\u89e3\u51bb\u91d1\u989d\u8d85\u51fa\u5269\u4f59\u53ef\u89e3\u51bb\u989d\u5ea6\uff0c\u65e0\u6cd5\u5b8c\u6210\u89e3\u51bb\uff0cBusinessPartnerSeq=" + dto.getBusinessPartnerSeq());
            }
        } else {
            businessPartnerSeq = dto.getBusinessPartnerSeq();
            platBusinessPartnerSeq = businessPartnerSeq + "-P" + dto.getSellFeePriority();
            int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(businessPartnerSeq, dto.getTradeType());
            if (countTrade > 0) {
                logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff0cBusinessPartnerSeq=" + dto.getBusinessPartnerSeq());
                return "";
            }
        }
        logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u6b65\u9aa4:2");
        boolean redisRepetition = this.redisUtil.getRedisRepetition(businessPartnerSeq);
        if (!redisRepetition) {
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u6b65\u9aa4:3");
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new CrmebWalletException("\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getContactPhone())) {
                throw new CrmebWalletException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new CrmebWalletException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.checkValidateCode(dto.getContactPhone(), dto.getActiveCode());
        }
        if (dto.getSellFeePriority() == 0) {
            lockAmount = decimalFormat.format(new BigDecimal(dto.getPlatAmount()));
            dto.setPlatAmount(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())).toString());
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        } else {
            lockAmount = decimalFormat.format(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())));
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
        }
        if (inAccount == null) {
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u6b65\u9aa4:4");
        logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.frozenAmount:" + lockAmount);
        String finalBusinessPartnerSeq = businessPartnerSeq;
        String finalPlatBusinessPartnerSeq = platBusinessPartnerSeq;
        HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.syncUpdateSumFrozenAmount(inAccount.getUniId(), "04".equals(dto.getTradeType()) ? new BigDecimal(lockAmount) : ("05".equals(dto.getTradeType()) ? new BigDecimal("-" + lockAmount) : BigDecimal.ZERO));
            logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u6b65\u9aa4:5");
            huifuWalletTrade.setBusinessCode(dto.getBusinessCode());
            huifuWalletTrade.setBusinessPartnerSeq(finalBusinessPartnerSeq);
            huifuWalletTrade.setReqSeqId(SequenceTools.getReqSeqId32());
            huifuWalletTrade.setCreateTime((Date)DateUtil.date());
            huifuWalletTrade.setUpdateTime(new Date());
            huifuWalletTrade.setGoodDesc(dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
            huifuWalletTrade.setTransFinishTime(DateUtils.getDateTime());
            huifuWalletTrade.setIncomeAccountNo(inAccount.getWalletAccountNo());
            huifuWalletTrade.setRemark(dto.getComment());
            huifuWalletTrade.setUniId(dto.getInId());
            huifuWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
            huifuWalletTrade.setTradeType(dto.getTradeType());
            huifuWalletTrade.setTradeStatus("1");
            huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
            this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
            logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u6b65\u9aa4:6");
            if (Double.parseDouble(dto.getPlatAmount()) > 0.0) {
                HuifuWalletTrade pTrade = new HuifuWalletTrade();
                BeanUtils.copyProperties((Object)huifuWalletTrade, (Object)pTrade);
                this.syncUpdateSumFrozenAmount(platAccount.getUniId(), "04".equals(dto.getTradeType()) ? new BigDecimal(dto.getPlatAmount()) : ("05".equals(dto.getTradeType()) ? new BigDecimal("-" + dto.getPlatAmount()) : BigDecimal.ZERO));
                pTrade.setAmount(new BigDecimal(dto.getPlatAmount()));
                pTrade.setReqSeqId(SequenceTools.getReqSeqId32());
                pTrade.setUniId(platAccount.getUniId());
                pTrade.setIncomeAccountNo(platAccount.getWalletAccountNo());
                pTrade.setRemark("\u8ba2\u5355\u3010" + finalPlatBusinessPartnerSeq + "\u3011\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u8d39\uff1a" + dto.getPlatAmount() + "\u5143" + ("05".equals(dto.getTradeType()) ? " \u786e\u8ba4" : ""));
                pTrade.setBusinessPartnerSeq(finalPlatBusinessPartnerSeq);
                this.huifuWalletTradeDao.insertHuifuWalletTrade(pTrade);
                logger.info(">>>>>>>>> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock\uff1a\u63a5\u53e3\u8bf7\u6c427");
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u6b65\u9aa4:8");
            throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u8ba2\u5355\u4ea4\u6613\uff08D/J\uff09-\u64cd\u4f5c\u5931\u8d25");
        }
        logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u6b65\u9aa4:end");
        return huifuWalletTrade.getReqSeqId();
    }

    @Override
    public String platHuifuWalletAccountLock(HuifuWalletTransferDto dto) throws CrmebWalletException {
        HuifuWalletAccountDto platAccount;
        HuifuWalletAccountDto inAccount;
        String lockAmount;
        boolean redisRepetition;
        String platBusinessPartnerSeq;
        logger.info("=======> (\u5e73\u53f0\u5206\u8d26\u4e1a\u52a1)\u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.platHuifuWalletAccountLock.param:" + JSON.toJSONString((Object)dto));
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new CrmebWalletException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info("=======> (\u5e73\u53f0\u5206\u8d26\u4e1a\u52a1)\u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.platHuifuWalletAccountLock.\u6b65\u9aa4:1");
        if ("05".equals(dto.getTradeType())) {
            Order order = this.orderService.getByOrderNo(dto.getBusinessPartnerSeq());
            String businessPartnerSeq = order.getPlatOrderNo() + "-P" + dto.getSellFeePriority();
            platBusinessPartnerSeq = businessPartnerSeq + "Y" + dto.getBusinessPartnerSeq();
            int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(platBusinessPartnerSeq, dto.getTradeType());
            if (countTrade > 0) {
                logger.info("=======> (\u5e73\u53f0\u5206\u8d26\u4e1a\u52a1)\u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.platHuifuWalletAccountLock.\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff0cBusinessPartnerSeq=" + platBusinessPartnerSeq);
                return "";
            }
            int isThaw = this.huifuWalletTradeDao.calculateTheThawingAmounByReq(businessPartnerSeq, dto.getAmount(), "");
            if (isThaw == 0) {
                throw new CrmebWalletException("\u5f53\u524d\u89e3\u51bb\u91d1\u989d\u8d85\u51fa\u5269\u4f59\u53ef\u89e3\u51bb\u989d\u5ea6\uff0c\u65e0\u6cd5\u5b8c\u6210\u89e3\u51bb\uff0cBusinessPartnerSeq=" + platBusinessPartnerSeq);
            }
        } else {
            platBusinessPartnerSeq = dto.getBusinessPartnerSeq() + "-P" + dto.getSellFeePriority();
            int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(platBusinessPartnerSeq, dto.getTradeType());
            if (countTrade > 0) {
                logger.info("=======> (\u5e73\u53f0\u5206\u8d26\u4e1a\u52a1)\u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.platHuifuWalletAccountLock.\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff0cBusinessPartnerSeq=" + platBusinessPartnerSeq);
                return "";
            }
        }
        if (!(redisRepetition = this.redisUtil.getRedisRepetition(platBusinessPartnerSeq))) {
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        logger.info("=======> (\u5e73\u53f0\u5206\u8d26\u4e1a\u52a1)\u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.platHuifuWalletAccountLock.\u6b65\u9aa4:3");
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new CrmebWalletException("\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getContactPhone())) {
                throw new CrmebWalletException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new CrmebWalletException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.checkValidateCode(dto.getContactPhone(), dto.getActiveCode());
        }
        if (dto.getSellFeePriority() == 0) {
            lockAmount = decimalFormat.format(new BigDecimal(dto.getPlatAmount()));
            dto.setPlatAmount(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())).toString());
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        } else {
            lockAmount = decimalFormat.format(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())));
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
        }
        if (inAccount == null) {
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        logger.info("=======> (\u5e73\u53f0\u5206\u8d26\u4e1a\u52a1)\u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.platHuifuWalletAccountLock.frozenAmount:" + lockAmount);
        if (Double.parseDouble(dto.getPlatAmount()) > 0.0) {
            HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
            String finalPlatBusinessPartnerSeq = platBusinessPartnerSeq;
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                huifuWalletTrade.setBusinessCode(dto.getBusinessCode());
                huifuWalletTrade.setBusinessPartnerSeq(finalPlatBusinessPartnerSeq);
                huifuWalletTrade.setCreateTime((Date)DateUtil.date());
                huifuWalletTrade.setUpdateTime(new Date());
                huifuWalletTrade.setGoodDesc(dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
                huifuWalletTrade.setTransFinishTime(DateUtils.getDateTime());
                huifuWalletTrade.setTradeType(dto.getTradeType());
                huifuWalletTrade.setTradeStatus("1");
                this.syncUpdateSumFrozenAmount(platAccount.getUniId(), "04".equals(dto.getTradeType()) ? new BigDecimal(dto.getPlatAmount()) : ("05".equals(dto.getTradeType()) ? new BigDecimal("-" + dto.getPlatAmount()) : BigDecimal.ZERO));
                huifuWalletTrade.setAmount(new BigDecimal(dto.getPlatAmount()));
                huifuWalletTrade.setReqSeqId(SequenceTools.getReqSeqId32());
                huifuWalletTrade.setUniId(platAccount.getUniId());
                huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
                huifuWalletTrade.setIncomeAccountNo(platAccount.getWalletAccountNo());
                huifuWalletTrade.setRemark("\u8ba2\u5355\u3010" + dto.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u8d39\uff1a" + dto.getPlatAmount() + "\u5143" + ("05".equals(dto.getTradeType()) ? " \u786e\u8ba4" : ""));
                this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
                logger.info(">>>>>>>>> (\u5e73\u53f0\u5206\u8d26\u4e1a\u52a1)\u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.platHuifuWalletAccountLock\uff1a\u63a5\u53e3\u8bf7\u6c427");
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                logger.info("=======> (\u5e73\u53f0\u5206\u8d26\u4e1a\u52a1)\u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.platHuifuWalletAccountLock.\u6b65\u9aa4:8");
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u8ba2\u5355\u4ea4\u6613\uff08D/J\uff09-\u64cd\u4f5c\u5931\u8d25");
            }
            return huifuWalletTrade.getReqSeqId();
        }
        logger.info("=======> (\u5e73\u53f0\u5206\u8d26\u4e1a\u52a1)\u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.platHuifuWalletAccountLock.\u6b65\u9aa4:end");
        return "";
    }

    @Override
    public BigDecimal extractedLock(String uniId, String tradeType, String amount) throws CrmebWalletException {
        BigDecimal frozenAmount;
        BigDecimal updAmount = new BigDecimal(amount);
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(uniId, PaymentChannel.WANGSHANG.toString());
        if (account == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u672a\u5f00\u901a\u94b1\u5305\u529f\u80fd");
        }
        Map<String, String> map = this.getHuifuWalletAccountAmount((HuifuWalletAccount)account);
        if (map != null && map.get("availableAmount") != null) {
            frozenAmount = new BigDecimal(String.valueOf(map.get("frozenAmount")));
            BigDecimal availableAmount = new BigDecimal(String.valueOf(map.get("availableAmount")));
            if ("04".equals(tradeType)) {
                frozenAmount = frozenAmount.add(updAmount);
            } else if ("05".equals(tradeType)) {
                if (frozenAmount.compareTo(updAmount) < 0) {
                    throw new CrmebWalletException("\u91d1\u989d\u5212\u62e8\u4e0d\u5bf9\u7b49\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                frozenAmount = frozenAmount.subtract(updAmount);
            } else if ("03".equals(tradeType) && availableAmount.compareTo(updAmount) < 0) {
                throw new CrmebWalletException("\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u786e\u8ba4\u652f\u4ed8\uff0c\u8bf7\u5145\u503c\u6216\u786e\u8ba4\u8ba2\u5355\u4ed8\u6b3e\u5df2\u8d26\u540e\u518d\u505a\u786e\u8ba4\u3002");
            }
        } else {
            throw new CrmebWalletException("\u672a\u8bfb\u53d6\u5230\u8d26\u6237\u4f59\u989d\u76f8\u5173\u4fe1\u606f");
        }
        logger.info(">>>>>>>>> extractedLock.\u51bb\u7ed3\u8d26\u6237uniId\uff1a" + uniId + "\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a" + tradeType + "\uff0c\u539f\u51bb\u7ed3\u91d1\u989d\uff1a" + map.get("frozenAmount") + "\uff0c\u73b0\u51bb\u7ed3\u91d1\u989d\uff1a" + frozenAmount);
        return frozenAmount;
    }

    @Override
    public String payAndThaw(HuifuWalletTransferDto dto) throws CrmebWalletException {
        dto.setTradeType("05");
        return this.huifuWalletAccountTransfer(dto);
    }

    @Override
    public String pay(HuifuWalletTransferDto dto) throws CrmebWalletException {
        dto.setTradeType("03");
        return this.huifuWalletAccountTransfer(dto);
    }

    @Override
    public void offlinePayPlatTransfer(HuifuWalletTransferDto dto) throws CrmebWalletException {
        HuifuWalletAccountDto platAccount;
        HuifuWalletAccountDto inAccount;
        String tradeType;
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer.param\uff1a" + JSONObject.toJSONString((Object)dto));
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new CrmebWalletException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getSellFeePriority() == null) {
            throw new CrmebWalletException("\u9500\u552e\u5206\u8d26\u4f18\u5148\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getPlatAmount())) {
            throw new CrmebWalletException("\u5e73\u53f0\u5206\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new CrmebWalletException("\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getContactPhone())) {
                throw new CrmebWalletException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new CrmebWalletException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.checkValidateCode(dto.getContactPhone(), dto.getActiveCode());
        }
        String string = tradeType = StringUtils.isEmpty((CharSequence)dto.getTradeType()) ? "04" : dto.getTradeType();
        if (dto.getSellFeePriority() == 0) {
            dto.setPlatAmount(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())).toString());
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        } else {
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
        }
        if (inAccount == null) {
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (Double.parseDouble(dto.getPlatAmount()) > 0.0) {
            logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c427");
            HuifuWalletTransferDto dtoP = new HuifuWalletTransferDto();
            BeanUtils.copyProperties((Object)dto, (Object)dtoP);
            dtoP.setAmount(dto.getPlatAmount());
            dtoP.setOutId(inAccount.getUniId());
            dtoP.setInId(platAccount.getUniId());
            String comment = dto.getSellFeePriority() == 0 ? "\u8ba2\u5355\u3010" + dtoP.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5546\u54c1\u8d39\uff1a" + dto.getPlatAmount() + "\u5143" : "\u8ba2\u5355\u3010" + dtoP.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u8d39\uff1a" + dto.getPlatAmount() + "\u5143";
            dtoP.setComment(comment);
            dtoP.setBusinessPartnerSeq(dtoP.getBusinessPartnerSeq() + "-P" + dto.getSellFeePriority());
            dtoP.setTradeType(tradeType);
            logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c428");
            this.extractedLock(dtoP.getOutId(), "03", dtoP.getAmount());
            this.syncTransferToPlat(dtoP);
            logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c429");
        }
    }

    @Override
    public String huifuWalletAccountTransfer(HuifuWalletTransferDto dto) throws CrmebWalletException {
        Map<Object, Object> response;
        HuifuWalletAccountDto platAccount;
        HuifuWalletAccountDto inAccount;
        String lockAmount;
        String tradeType;
        Date date = new Date();
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u5f00\u59cb");
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer.param\uff1a" + JSONObject.toJSONString((Object)dto));
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new CrmebWalletException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getSellFeePriority() == null) {
            throw new CrmebWalletException("\u9500\u552e\u5206\u8d26\u4f18\u5148\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getPlatAmount())) {
            throw new CrmebWalletException("\u5e73\u53f0\u5206\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean redisRepetition = this.redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade > 0) {
            logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new CrmebWalletException("\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getContactPhone())) {
                throw new CrmebWalletException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new CrmebWalletException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.checkValidateCode(dto.getContactPhone(), dto.getActiveCode());
        }
        String string = tradeType = StringUtils.isEmpty((CharSequence)dto.getTradeType()) ? "04" : dto.getTradeType();
        if ("04".equals(tradeType)) {
            this.extractedLock(dto.getOutId(), "03", dto.getAmount());
        }
        String objId = dto.getInId();
        if ("03".equals(tradeType)) {
            objId = dto.getOutId();
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        HuifuWalletAccountDto outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getOutId(), PaymentChannel.WANGSHANG.toString());
        if (outAccount == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u672a\u5f00\u901a\u94b1\u5305\u529f\u80fd");
        }
        if (dto.getSellFeePriority() == 0) {
            lockAmount = dto.getPlatAmount();
            dto.setPlatAmount(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())).toString());
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        } else {
            lockAmount = decimalFormat.format(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())));
            inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
        }
        if (inAccount == null) {
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u51bb\u7ed3\u91d1\u989d\uff1a" + lockAmount);
        String reqSeqId = SequenceTools.getReqSeqId32();
        p.put("outHuifuId", outAccount.getWalletAccountNo());
        p.put("reqSeqId", reqSeqId);
        p.put("scene", "PROTOCOL_WITHHOLD");
        p.put("ordAmt", dto.getAmount());
        p.put("inWalletAccountNo", inAccount.getWalletAccountNo());
        p.put("comment", dto.getComment());
        p.put("goodDesc", dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u53c2\u6570\u8bbe\u7f6e\u5b8c\u6210");
        WSBusiCode wSBusiCode = WSBusiCode.YEPAY;
        if (outAccount.getWalletAccountNo().equals(inAccount.getWalletAccountNo())) {
            response = Maps.newHashMap();
            response.put("resp_code", "00000000");
            response.put("resp_desc", "\u4ed8\u65b9\u53c2\u4e0e\u8005Id\u76f8\u540c\u65f6\u8df3\u8fc7\u652f\u4ed8\u8bf7\u6c42");
            response.put("reqSeqId", reqSeqId);
            response.put("hfSeqId", dto.getBusinessPartnerSeq());
        } else {
            try {
                response = WSApiRequest.api(wSBusiCode, p);
            }
            catch (Exception e2) {
                this.transactionLogService.save("huifuWalletAccountTransfer", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
                throw new CrmebWalletException(e2.getMessage());
            }
        }
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c423\uff1a" + response.toString());
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
                huifuWalletTrade.setBusinessCode(dto.getBusinessCode());
                huifuWalletTrade.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
                huifuWalletTrade.setReqSeqId(response.get("reqSeqId").toString());
                huifuWalletTrade.setHfSeqId(response.get("hfSeqId").toString());
                huifuWalletTrade.setCreateTime(date);
                huifuWalletTrade.setUpdateTime(new Date());
                huifuWalletTrade.setGoodDesc(dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
                huifuWalletTrade.setExpendAccountNo(outAccount.getWalletAccountNo());
                huifuWalletTrade.setIncomeAccountNo(inAccount.getWalletAccountNo());
                huifuWalletTrade.setRemark(dto.getComment());
                huifuWalletTrade.setUniId(outAccount.getUniId());
                huifuWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
                huifuWalletTrade.setTradeType(dto.getTradeType());
                huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"P"));
                huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
                if ("04".equals(tradeType)) {
                    this.syncUpdateSumFrozenAmount(inAccount.getUniId(), "04".equals(dto.getTradeType()) ? new BigDecimal(lockAmount) : ("05".equals(dto.getTradeType()) ? new BigDecimal("-" + lockAmount) : BigDecimal.ZERO));
                }
                return Boolean.TRUE;
            });
            logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c425");
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u4ea4\u6613\u652f\u4ed8-\u64cd\u4f5c\u5931\u8d25");
            }
            logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c426");
            if (Double.parseDouble(dto.getPlatAmount()) > 0.0) {
                logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c427");
                HuifuWalletTransferDto dtoP = new HuifuWalletTransferDto();
                BeanUtils.copyProperties((Object)dto, (Object)dtoP);
                dtoP.setAmount(dto.getPlatAmount());
                dtoP.setOutId(inAccount.getUniId());
                dtoP.setInId(platAccount.getUniId());
                String comment = dto.getSellFeePriority() == 0 ? "\u8ba2\u5355\u3010" + dtoP.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5546\u54c1\u8d39\uff1a" + dto.getPlatAmount() + "\u5143" : "\u8ba2\u5355\u3010" + dtoP.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u8d39\uff1a" + dto.getPlatAmount() + "\u5143";
                dtoP.setComment(comment);
                dtoP.setBusinessPartnerSeq(dtoP.getBusinessPartnerSeq() + "-P" + dto.getSellFeePriority());
                dtoP.setTradeType(tradeType);
                logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c428");
                this.syncTransferToPlat(dtoP);
                logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c429");
            }
            logger.info("===>huifuWalletAccountTransfer.\u672c\u6b21\u8f6c\u8d26\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a) / 1000L + "\u79d2");
            logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u652f\u4ed8\u786e\u8ba4\uff1asucc");
            return response.get("reqSeqId").toString();
        }
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a\u63a5\u53e3\u8bf7\u6c4210");
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public Boolean transferToPlat(HuifuWalletTransferDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isNotEmpty((CharSequence)dto.getPayChannel()) && !PaymentChannel.WANGSHANG.toString().equals(dto.getPayChannel())) {
            return false;
        }
        Date date = new Date();
        logger.info(">>>>>>>>> \u4e8c\u7ea7\u5206\u8d26\u4e1a\u52a1transferToPlat\uff1a" + dto.getBusinessPartnerSeq() + ",\u5f00\u59cb");
        logger.info(">>>>>>>>> \u4e8c\u7ea7\u5206\u8d26\u4e1a\u52a1transferToPlat.param\uff1a" + JSONObject.toJSONString((Object)dto));
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            return false;
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            return false;
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            return false;
        }
        boolean redisRepetition = this.redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            return false;
        }
        logger.info(">>>>>>>>> \u4e8c\u7ea7\u5206\u8d26\u4e1a\u52a1transferToPlat\uff1a1");
        int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade > 0) {
            return true;
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tradeType = StringUtils.isEmpty((CharSequence)dto.getTradeType()) ? "04" : dto.getTradeType();
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3transferToPlat\uff1a2");
        this.extractedLock(dto.getOutId(), "03", dto.getAmount());
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3transferToPlat\uff1a3");
        logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3transferToPlat\uff1a" + dto.getBusinessPartnerSeq() + ",\u51bb\u7ed3\u91d1\u989d\uff1a" + dto.getAmount());
        HashMap<String, Object> p = new HashMap<String, Object>();
        HuifuWalletAccountDto outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getOutId(), PaymentChannel.WANGSHANG.toString());
        if (outAccount == null) {
            logger.error("===>transferToPlat.\u4e8c\u7ea7\u5206\u8d26\u5f02\u5e38\uff1a\u4f01\u4e1a\u672a\u5f00\u901a\u94b1\u5305\u529f\u80fd");
            return false;
        }
        HuifuWalletAccountDto inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        if (outAccount == null) {
            logger.error("===>transferToPlat.\u4e8c\u7ea7\u5206\u8d26\u5f02\u5e38\uff1a\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return false;
        }
        String lockAmount = "0";
        String availableAmount = "0";
        if ("04".equals(dto.getTradeType())) {
            lockAmount = dto.getAmount();
        } else {
            availableAmount = dto.getAmount();
        }
        p.put("scene", "PROTOCOL_WITHHOLD");
        p.put("freezeAmount", lockAmount);
        p.put("availableAmount", availableAmount);
        p.put("outHuifuId", outAccount.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("ordAmt", dto.getAmount());
        p.put("inAmount", decimalFormat.format(new BigDecimal(dto.getAmount())));
        p.put("inWalletAccountNo", inAccount.getWalletAccountNo());
        p.put("comment", dto.getComment());
        p.put("goodDesc", dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
        try {
            wSBusiCode = WSBusiCode.YEPAY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e2) {
            this.transactionLogService.save("transferToPlat", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            logger.error("===>transferToPlat.\u4e8c\u7ea7\u5206\u8d26\u5f02\u5e38\uff1a" + e2.getMessage());
            return false;
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
                huifuWalletTrade.setBusinessCode(dto.getBusinessCode());
                huifuWalletTrade.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
                huifuWalletTrade.setReqSeqId(response.get("reqSeqId").toString());
                huifuWalletTrade.setHfSeqId(response.get("hfSeqId").toString());
                huifuWalletTrade.setCreateTime(date);
                huifuWalletTrade.setUpdateTime(new Date());
                huifuWalletTrade.setGoodDesc(dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
                huifuWalletTrade.setExpendAccountNo(outAccount.getWalletAccountNo());
                huifuWalletTrade.setIncomeAccountNo(inAccount.getWalletAccountNo());
                huifuWalletTrade.setRemark(dto.getComment());
                huifuWalletTrade.setUniId(outAccount.getUniId());
                huifuWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
                huifuWalletTrade.setTradeType(dto.getTradeType());
                huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"P"));
                huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
                if ("04".equals(tradeType)) {
                    this.syncUpdateSumFrozenAmount(inAccount.getUniId(), "04".equals(dto.getTradeType()) ? new BigDecimal(dto.getAmount()) : ("05".equals(dto.getTradeType()) ? new BigDecimal("-" + dto.getAmount()) : BigDecimal.ZERO));
                }
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                logger.error("===>transferToPlat.\u4e8c\u7ea7\u5206\u8d26\u5f02\u5e38\uff1a\u4f01\u4e1a\u94b1\u5305-\u4ea4\u6613\u652f\u4ed8-\u64cd\u4f5c\u5931\u8d25");
                return false;
            }
            logger.info("===>huifuWalletAccountTransfer.\u672c\u6b21\u8f6c\u8d26\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a) / 1000L + "\u79d2");
            logger.info(">>>>>>>>> \u4f01\u4e1a\u8f6c\u8d26\u63a5\u53e3huifuWalletAccountTransfer\uff1a" + dto.getBusinessPartnerSeq() + "," + response.get("reqSeqId").toString() + ",\u652f\u4ed8\u786e\u8ba4\uff1asucc");
            return true;
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        logger.error("===>transferToPlat.\u4e8c\u7ea7\u5206\u8d26\u5f02\u5e38\uff1a" + WangShangWalletServiceImpl.RET(response, 2));
        return false;
    }

    @Override
    public void offlinePayPlatRefund(HuifuWalletTransferDto dto) throws CrmebWalletException {
        HuifuWalletAccountDto platAccount;
        HuifuWalletAccountDto outAccount;
        String tradeType;
        logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund.param\uff1a" + JSONObject.toJSONString((Object)dto));
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new CrmebWalletException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getPlatAmount())) {
            throw new CrmebWalletException("\u5e73\u53f0\u5206\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String oldBusinessPartnerSeq = dto.getBusinessPartnerSeq();
        dto.setBusinessPartnerSeq(oldBusinessPartnerSeq + "T");
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new CrmebWalletException("\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getContactPhone())) {
                throw new CrmebWalletException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new CrmebWalletException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.checkValidateCode(dto.getContactPhone(), dto.getActiveCode());
        }
        String string = tradeType = StringUtils.isEmpty((CharSequence)dto.getTradeType()) ? "05" : dto.getTradeType();
        if (dto.getSellFeePriority() == 0) {
            dto.setPlatAmount(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())).toString());
            outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        } else {
            outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
        }
        if (outAccount == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u672a\u5f00\u901a\u94b1\u5305\u529f\u80fd");
        }
        if (Double.parseDouble(dto.getPlatAmount()) > 0.0) {
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c427");
            HuifuWalletTransferDto dtoP = new HuifuWalletTransferDto();
            BeanUtils.copyProperties((Object)dto, (Object)dtoP);
            dtoP.setAmount(dto.getPlatAmount());
            dtoP.setOutId(platAccount.getUniId());
            dtoP.setInId(outAccount.getUniId());
            dtoP.setComment("\u8ba2\u5355\u3010" + dtoP.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u8d39\u9000\u6b3e\uff1a" + dto.getPlatAmount() + "\u5143");
            dtoP.setBusinessPartnerSeq(oldBusinessPartnerSeq + "-PT");
            dtoP.setTradeType(tradeType);
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c428");
            this.syncRefundToPlat(dtoP);
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c429");
        }
    }

    @Override
    public String huifuWalletAccountRefund(HuifuWalletTransferDto dto) throws CrmebWalletException {
        Map<Object, Object> response;
        HuifuWalletAccountDto platAccount;
        HuifuWalletAccountDto outAccount;
        String lockAmount;
        Date date = new Date();
        logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a" + dto.getBusinessPartnerSeq() + ",\u5f00\u59cb");
        logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund.param\uff1a" + JSONObject.toJSONString((Object)dto));
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new CrmebWalletException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getPlatAmount())) {
            throw new CrmebWalletException("\u5e73\u53f0\u5206\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String businessPartnerSeq = dto.getBusinessPartnerSeq();
        if ("05".equals(dto.getTradeType())) {
            Order order = this.orderService.getByOrderNo(dto.getBusinessPartnerSeq());
            businessPartnerSeq = order.getPlatOrderNo() + "T" + dto.getBusinessPartnerSeq();
            int isThaw = this.huifuWalletTradeDao.calculateTheThawingAmounByReq(order.getPlatOrderNo(), dto.getAmount(), "-P");
            if (isThaw == 0) {
                throw new CrmebWalletException("\u5f53\u524d\u89e3\u51bb\u91d1\u989d\u8d85\u51fa\u5269\u4f59\u53ef\u89e3\u51bb\u989d\u5ea6\uff0c\u65e0\u6cd5\u5b8c\u6210\u89e3\u51bb\uff0cBusinessPartnerSeq=" + businessPartnerSeq);
            }
        } else {
            throw new CrmebWalletException("\u5f53\u524d\u4e3a\u9000\u6b3e\u4e1a\u52a1\uff0c\u4ec5\u652f\u6301\u89e3\u51bb\u64cd\u4f5c\uff0cBusinessPartnerSeq=" + dto.getBusinessPartnerSeq());
        }
        boolean redisRepetition = this.redisUtil.getRedisRepetition(businessPartnerSeq);
        if (!redisRepetition) {
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a" + businessPartnerSeq + ",\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(businessPartnerSeq, dto.getTradeType());
        if (countTrade > 0) {
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a" + businessPartnerSeq + ",\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new CrmebWalletException("\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getContactPhone())) {
                throw new CrmebWalletException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new CrmebWalletException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.checkValidateCode(dto.getContactPhone(), dto.getActiveCode());
        }
        String tradeType = StringUtils.isEmpty((CharSequence)dto.getTradeType()) ? "05" : dto.getTradeType();
        HashMap<String, Object> p = new HashMap<String, Object>();
        HuifuWalletAccountDto inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getOutId(), PaymentChannel.WANGSHANG.toString());
        if (inAccount == null) {
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u5165\u8d26\u65b9\u5b58\u5728");
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (dto.getSellFeePriority() == 0) {
            lockAmount = dto.getPlatAmount();
            dto.setPlatAmount(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())).toString());
            outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        } else {
            lockAmount = decimalFormat.format(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())));
            outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
            platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
        }
        this.extractedLock(outAccount.getUniId(), tradeType, lockAmount);
        logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a" + businessPartnerSeq + ",\u51bb\u7ed3\u91d1\u989d\uff1a" + lockAmount);
        if (outAccount == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u672a\u5f00\u901a\u94b1\u5305\u529f\u80fd");
        }
        if (Double.parseDouble(dto.getPlatAmount()) > 0.0) {
            HuifuWalletTransferDto dtoP = new HuifuWalletTransferDto();
            BeanUtils.copyProperties((Object)dto, (Object)dtoP);
            dtoP.setAmount(dto.getPlatAmount());
            dtoP.setOutId(platAccount.getUniId());
            dtoP.setInId(outAccount.getUniId());
            dtoP.setComment("\u8ba2\u5355\u3010" + dtoP.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u8d39\u9000\u6b3e\uff1a" + dto.getPlatAmount() + "\u5143");
            dtoP.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
            dtoP.setTradeType(tradeType);
            this.syncRefundToPlat(dtoP);
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c429");
        }
        String reqSeqId = SequenceTools.getReqSeqId32();
        p.put("scene", "PROTOCOL_WITHHOLD");
        p.put("freezeAmount", lockAmount);
        p.put("availableAmount", dto.getPlatAmount());
        p.put("outHuifuId", outAccount.getWalletAccountNo());
        p.put("reqSeqId", reqSeqId);
        p.put("ordAmt", dto.getAmount());
        p.put("isPlatAcct", "0");
        p.put("platAmount", "0.00");
        p.put("inAmount", dto.getAmount());
        p.put("inWalletAccountNo", inAccount.getWalletAccountNo());
        p.put("comment", dto.getComment() + " \u9000\u6b3e");
        p.put("goodDesc", dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
        WSBusiCode wSBusiCode = WSBusiCode.YEPAY;
        if (outAccount.getWalletAccountNo().equals(inAccount.getWalletAccountNo())) {
            response = Maps.newHashMap();
            response.put("resp_code", "00000000");
            response.put("resp_desc", "\u4ed8\u65b9\u53c2\u4e0e\u8005Id\u76f8\u540c\u65f6\u8df3\u8fc7\u652f\u4ed8\u8bf7\u6c42");
            response.put("reqSeqId", reqSeqId);
            response.put("hfSeqId", dto.getBusinessPartnerSeq());
        } else {
            try {
                logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c421");
                response = WSApiRequest.api(wSBusiCode, p);
                logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c422");
            }
            catch (Exception e2) {
                this.transactionLogService.save("huifuWalletAccountRefund", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
                throw new CrmebWalletException(e2.getMessage());
            }
        }
        logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c423\uff1a" + response.toString());
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c424");
            String finalBusinessPartnerSeq = businessPartnerSeq;
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
                huifuWalletTrade.setBusinessCode(dto.getBusinessCode());
                huifuWalletTrade.setBusinessPartnerSeq(finalBusinessPartnerSeq);
                huifuWalletTrade.setReqSeqId(response.get("reqSeqId").toString());
                huifuWalletTrade.setHfSeqId(response.get("hfSeqId").toString());
                huifuWalletTrade.setCreateTime(date);
                huifuWalletTrade.setUpdateTime(new Date());
                huifuWalletTrade.setGoodDesc(dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
                huifuWalletTrade.setExpendAccountNo(outAccount.getWalletAccountNo());
                huifuWalletTrade.setIncomeAccountNo(inAccount.getWalletAccountNo());
                huifuWalletTrade.setRemark(dto.getComment() + " \u9000\u6b3e");
                huifuWalletTrade.setUniId(outAccount.getUniId());
                huifuWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
                huifuWalletTrade.setTradeType(dto.getTradeType());
                huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"P"));
                huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
                if ("05".equals(tradeType)) {
                    this.syncUpdateSumFrozenAmount(outAccount.getUniId(), "04".equals(dto.getTradeType()) ? new BigDecimal(lockAmount) : ("05".equals(dto.getTradeType()) ? new BigDecimal("-" + lockAmount) : BigDecimal.ZERO));
                }
                return Boolean.TRUE;
            });
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c425");
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u4ea4\u6613\u652f\u4ed8-\u64cd\u4f5c\u5931\u8d25");
            }
            logger.info("===>\u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund.\u672c\u6b21\u8f6c\u8d26\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a) / 1000L + "\u79d2");
            logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a" + businessPartnerSeq + ",\u652f\u4ed8\u786e\u8ba4\uff1asucc");
            return response.get("reqSeqId").toString();
        }
        logger.info(">>>>>>>>> \u4f01\u4e1a\u9000\u6b3e\u63a5\u53e3huifuWalletAccountRefund\uff1a\u63a5\u53e3\u8bf7\u6c4210");
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public Boolean refundToPlat(HuifuWalletTransferDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isNotEmpty((CharSequence)dto.getPayChannel()) && !PaymentChannel.WANGSHANG.toString().equals(dto.getPayChannel())) {
            return false;
        }
        Date date = new Date();
        logger.info(">>>>>>>>> \u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a" + dto.getBusinessPartnerSeq() + ",\u5f00\u59cb");
        logger.info(">>>>>>>>> \u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.param\uff1a" + JSONObject.toJSONString((Object)dto));
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            logger.error(">>>>>>>>> \u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            logger.error(">>>>>>>>> \u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            logger.error(">>>>>>>>> \u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        Order order = this.orderService.getByOrderNo(dto.getBusinessPartnerSeq());
        String businessPartnerSeq = order.getPlatOrderNo() + "-P" + dto.getSellFeePriority();
        String businessPartnerSeq2 = businessPartnerSeq + "T" + dto.getBusinessPartnerSeq();
        boolean redisRepetition = this.redisUtil.getRedisRepetition(businessPartnerSeq2);
        if (!redisRepetition) {
            logger.info(">>>>>>>>> \u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a" + businessPartnerSeq2 + ",\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            return false;
        }
        int isThaw = this.huifuWalletTradeDao.calculateTheThawingAmounByReq(businessPartnerSeq, dto.getAmount(), "");
        if (isThaw == 0) {
            throw new CrmebWalletException("\u5f53\u524d\u89e3\u51bb\u91d1\u989d\u8d85\u51fa\u5269\u4f59\u53ef\u89e3\u51bb\u989d\u5ea6\uff0c\u65e0\u6cd5\u5b8c\u6210\u89e3\u51bb\uff0cBusinessPartnerSeq=" + businessPartnerSeq2);
        }
        logger.info("=======> \u4f01\u4e1a\u8d26\u6237\u91d1\u989d\u51bb\u7ed3/\u89e3\u51bb.huifuWalletAccountLock.\u6b65\u9aa4:1.1");
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tradeType = StringUtils.isEmpty((CharSequence)dto.getTradeType()) ? "05" : dto.getTradeType();
        this.extractedLock(dto.getOutId(), tradeType, dto.getAmount());
        logger.info(">>>>>>>>> \u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat\uff1a" + businessPartnerSeq2 + ",\u51bb\u7ed3\u91d1\u989d\uff1a" + dto.getAmount());
        HashMap<String, Object> p = new HashMap<String, Object>();
        HuifuWalletAccountDto outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getOutId(), PaymentChannel.WANGSHANG.toString());
        if (outAccount == null) {
            logger.error("===>\u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a\u4f01\u4e1a\u672a\u5f00\u901a\u94b1\u5305\u529f\u80fd");
            return false;
        }
        HuifuWalletAccountDto inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        if (inAccount == null) {
            logger.error("===>\u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return false;
        }
        String lockAmount = "0";
        String availableAmount = "0";
        if ("04".equals(dto.getTradeType())) {
            lockAmount = dto.getAmount();
        } else {
            availableAmount = dto.getAmount();
        }
        p.put("scene", "PROTOCOL_WITHHOLD");
        p.put("freezeAmount", lockAmount);
        p.put("availableAmount", availableAmount);
        p.put("outHuifuId", outAccount.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("ordAmt", dto.getAmount());
        p.put("inAmount", dto.getAmount());
        p.put("inWalletAccountNo", inAccount.getWalletAccountNo());
        p.put("comment", dto.getComment());
        p.put("goodDesc", dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
        try {
            wSBusiCode = WSBusiCode.YEPAY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e2) {
            this.transactionLogService.save("refundToPlat", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            logger.error("===>\u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a" + e2.getMessage());
            return false;
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
                huifuWalletTrade.setBusinessCode(dto.getBusinessCode());
                huifuWalletTrade.setBusinessPartnerSeq(businessPartnerSeq2);
                huifuWalletTrade.setReqSeqId(response.get("reqSeqId").toString());
                huifuWalletTrade.setHfSeqId(response.get("hfSeqId").toString());
                huifuWalletTrade.setCreateTime(date);
                huifuWalletTrade.setUpdateTime(new Date());
                huifuWalletTrade.setGoodDesc(dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
                huifuWalletTrade.setExpendAccountNo(outAccount.getWalletAccountNo());
                huifuWalletTrade.setIncomeAccountNo(inAccount.getWalletAccountNo());
                huifuWalletTrade.setRemark(dto.getComment());
                huifuWalletTrade.setUniId(outAccount.getUniId());
                huifuWalletTrade.setAmount(new BigDecimal(dto.getAmount()));
                huifuWalletTrade.setTradeType(dto.getTradeType());
                huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"P"));
                huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
                if ("05".equals(tradeType)) {
                    this.syncUpdateSumFrozenAmount(outAccount.getUniId(), "04".equals(dto.getTradeType()) ? new BigDecimal(dto.getAmount()) : ("05".equals(dto.getTradeType()) ? new BigDecimal("-" + dto.getAmount()) : BigDecimal.ZERO));
                }
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                logger.error("===>\u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a\u4f01\u4e1a\u94b1\u5305-\u4ea4\u6613\u652f\u4ed8-\u64cd\u4f5c\u5931\u8d25");
                return false;
            }
            logger.info("===>\u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat.\u672c\u6b21\u8f6c\u8d26\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a) / 1000L + "\u79d2");
            logger.info(">>>>>>>>> \u5e73\u53f0\u9000\u6b3e\u7ed9\u4f01\u4e1arefundToPlat\uff1a" + businessPartnerSeq2 + "," + response.get("reqSeqId").toString() + ",\u652f\u4ed8\u786e\u8ba4\uff1asucc");
            return true;
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        logger.error("===>huifuWalletAccountTransfer.\u5e73\u53f0\u652f\u4ed8\u5f02\u5e38\uff1a" + WangShangWalletServiceImpl.RET(response, 2));
        return false;
    }

    @Override
    public String platAccountRetailTransfer(HuifuWalletTransferDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        Date date = new Date();
        logger.info(">>>>>>>>> \u5e73\u53f0\u5206\u9500\u8f6c\u8d26\u63a5\u53e3platAccountRetailTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u5f00\u59cb");
        logger.info(">>>>>>>>> \u5e73\u53f0\u5206\u9500\u8f6c\u8d26\u63a5\u53e3platAccountRetailTransfer.param\uff1a" + JSONObject.toJSONString((Object)dto));
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new CrmebWalletException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean redisRepetition = this.redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            logger.info(">>>>>>>>> \u5e73\u53f0\u5206\u9500\u8f6c\u8d26\u63a5\u53e3platAccountRetailTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade > 0) {
            logger.info(">>>>>>>>> \u5e73\u53f0\u5206\u9500\u8f6c\u8d26\u63a5\u53e3platAccountRetailTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsName())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsNumber())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsUnit())) {
            throw new CrmebWalletException("\u8ba2\u5355\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getNeedActiveCode())) {
            throw new CrmebWalletException("\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getNeedActiveCode())) {
            if (StringUtil.isEmpty((String)dto.getContactPhone())) {
                throw new CrmebWalletException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)dto.getActiveCode())) {
                throw new CrmebWalletException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.checkValidateCode(dto.getContactPhone(), dto.getActiveCode());
        }
        HuifuWalletAccountDto platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
        dto.setOutId(platAccount.getUniId());
        String tradeType = StringUtils.isEmpty((CharSequence)dto.getTradeType()) ? "05" : dto.getTradeType();
        logger.info(">>>>>>>>> \u5e73\u53f0\u5206\u9500\u8f6c\u8d26\u63a5\u53e3platAccountRetailTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u51bb\u7ed3\u91d1\u989d\uff1a" + dto.getAmount());
        HashMap<String, Object> p = new HashMap<String, Object>();
        HuifuWalletAccountDto outAccount = platAccount;
        if (outAccount == null) {
            throw new CrmebWalletException("\u4f01\u4e1a\u672a\u5f00\u901a\u94b1\u5305\u529f\u80fd");
        }
        HuifuWalletAccountDto inAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        if (outAccount == null) {
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String lockAmount = "0";
        String availableAmount = "0";
        if ("04".equals(dto.getTradeType())) {
            lockAmount = dto.getAmount();
        } else {
            availableAmount = dto.getAmount();
        }
        p.put("scene", "PROTOCOL_WITHHOLD");
        p.put("freezeAmount", lockAmount);
        p.put("availableAmount", availableAmount);
        p.put("outHuifuId", outAccount.getWalletAccountNo());
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("ordAmt", dto.getAmount());
        String inAmount = dto.getAmount();
        inAmount = decimalFormat.format(new BigDecimal(inAmount));
        p.put("inAmount", inAmount);
        p.put("inWalletAccountNo", inAccount.getWalletAccountNo());
        p.put("comment", dto.getComment());
        p.put("goodDesc", dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
        try {
            wSBusiCode = WSBusiCode.YEPAY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e2) {
            this.transactionLogService.save("platAccountRetailTransfer", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            String ina = inAmount;
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                HuifuWalletTrade huifuWalletTrade = new HuifuWalletTrade();
                huifuWalletTrade.setBusinessCode(dto.getBusinessCode());
                huifuWalletTrade.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
                huifuWalletTrade.setReqSeqId(response.get("reqSeqId").toString());
                huifuWalletTrade.setHfSeqId(response.get("hfSeqId").toString());
                huifuWalletTrade.setCreateTime(date);
                huifuWalletTrade.setUpdateTime(new Date());
                huifuWalletTrade.setGoodDesc(dto.getGoodsName() + "\u00d7" + dto.getGoodsNumber() + dto.getGoodsUnit());
                huifuWalletTrade.setExpendAccountNo(outAccount.getWalletAccountNo());
                huifuWalletTrade.setIncomeAccountNo(inAccount.getWalletAccountNo());
                huifuWalletTrade.setRemark(dto.getComment());
                huifuWalletTrade.setUniId(outAccount.getUniId());
                huifuWalletTrade.setAmount(new BigDecimal(ina));
                huifuWalletTrade.setTradeType(dto.getTradeType());
                huifuWalletTrade.setTradeStatus(Constants.tradeStatus((String)"P"));
                huifuWalletTrade.setPayChannel(PaymentChannel.WANGSHANG.toString());
                this.huifuWalletTradeDao.insertHuifuWalletTrade(huifuWalletTrade);
                this.syncUpdateSumFrozenAmount(inAccount.getUniId(), "04".equals(dto.getTradeType()) ? new BigDecimal(dto.getAmount()) : ("05".equals(dto.getTradeType()) ? new BigDecimal("-" + dto.getAmount()) : BigDecimal.ZERO));
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u4ea4\u6613\u652f\u4ed8-\u64cd\u4f5c\u5931\u8d25");
            }
            logger.info("===>\u5e73\u53f0\u5206\u9500\u8f6c\u8d26\u63a5\u53e3platAccountRetailTransfer.\u672c\u6b21\u8f6c\u8d26\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a) / 1000L + "\u79d2");
            logger.info(">>>>>>>>> \u5e73\u53f0\u5206\u9500\u8f6c\u8d26\u63a5\u53e3platAccountRetailTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u652f\u4ed8\u786e\u8ba4\uff1asucc");
            return response.get("reqSeqId").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String getHuifuAccountTradeVoucher(HuifuWalletTradeDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getTradeFlowNo())) {
            throw new CrmebWalletException("\u5168\u5c40\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getUniId(), PaymentChannel.WANGSHANG.toString());
        HuifuWalletReconciliation re = (HuifuWalletReconciliation)this.huifuWalletReconciliationDao.selectById((Serializable)((Object)dto.getTradeFlowNo()));
        HashMap p = Maps.newHashMap();
        p.put("merchantId", account.getWalletAccountNo());
        String reqSeqId = SequenceTools.getReqSeqId32();
        p.put("reqSeqId", reqSeqId);
        p.put("orderNo", re.getTradeSerialNo());
        if (StringUtils.isNotEmpty((CharSequence)re.getReceiptNo()) && "01".equals(re.getReceiptStatus())) {
            return re.getReceiptNo();
        }
        if (StringUtils.isNotEmpty((CharSequence)re.getReceiptNo()) && "02".equals(re.getReceiptStatus())) {
            Map<String, Object> response2;
            WSBusiCode wSBusiCode2;
            p.put("receiptNo", re.getReceiptNo());
            p.put("reqSeqId", re.getReqSeqId());
            try {
                wSBusiCode2 = WSBusiCode.HDQUERY;
                response2 = WSApiRequest.api(wSBusiCode2, p);
            }
            catch (Exception e) {
                this.transactionLogService.save(WSBusiCode.HDQUERY.toString(), "0", JSONObject.toJSONString((Object)p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
                throw new CrmebWalletException(e.getMessage());
            }
            if ("00000000".equals(WangShangWalletServiceImpl.RET(response2, 1))) {
                this.transactionLogService.save(wSBusiCode2.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response2), PaymentChannel.WANGSHANG.toString());
                return response2.get("PdfDownloadUrl").toString();
            }
            this.transactionLogService.save(wSBusiCode2.toString(), "0", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response2), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response2, 2));
        }
        try {
            wSBusiCode = WSBusiCode.HDAPPLY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save("getHuifuAccountTradeVoucher", "0", JSONObject.toJSONString((Object)p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            re.setReceiptNo(response.get("receiptNo").toString());
            re.setReceiptStatus("01");
            re.setUpdateTime(new Date());
            re.setReqSeqId(reqSeqId);
            this.huifuWalletReconciliationDao.updateById(re);
            return response.get("receiptNo").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String getBatchTradeVoucher(HuifuWalletTradeDto dto) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getUniId(), PaymentChannel.WANGSHANG.toString());
        String receiptStatus = "03";
        String receiptNo = "202507652476220403";
        HashMap p = Maps.newHashMap();
        p.put("merchantId", account.getWalletAccountNo());
        String reqSeqId = SequenceTools.getReqSeqId32();
        p.put("reqSeqId", reqSeqId);
        p.put("startDate", "20250723");
        p.put("endDate", "20250724");
        if (StringUtils.isNotEmpty((CharSequence)receiptNo) && "01".equals(receiptStatus)) {
            return receiptNo;
        }
        if (StringUtils.isNotEmpty((CharSequence)receiptNo) && "02".equals(receiptStatus)) {
            Map<String, Object> response2;
            WSBusiCode wSBusiCode2;
            p.put("receiptNo", receiptNo);
            p.put("reqSeqId", "20250724184901686m1y290b3xlt1i2");
            try {
                wSBusiCode2 = WSBusiCode.HDQUERY;
                response2 = WSApiRequest.api(wSBusiCode2, p);
            }
            catch (Exception e) {
                this.transactionLogService.save(WSBusiCode.HDQUERY.toString(), "0", JSONObject.toJSONString((Object)p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
                throw new CrmebWalletException(e.getMessage());
            }
            if ("00000000".equals(WangShangWalletServiceImpl.RET(response2, 1))) {
                this.transactionLogService.save(wSBusiCode2.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response2), PaymentChannel.WANGSHANG.toString());
                return response2.get("PdfDownloadUrl").toString();
            }
            this.transactionLogService.save(wSBusiCode2.toString(), "0", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response2), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response2, 2));
        }
        try {
            wSBusiCode = WSBusiCode.HDBATCHAPPLY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save("getHuifuAccountTradeVoucher", "0", JSONObject.toJSONString((Object)p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            System.out.println("====== > reqSeqId\uff1a" + reqSeqId);
            return response.get("receiptNo").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String taskTradeVoucher(String tradeDate) {
        return "1";
    }

    @Override
    public String setReconciliationConfig() throws CrmebWalletException {
        WSBusiCode wSBusiCode;
        HashMap p = Maps.newHashMap();
        Map<String, Object> response = null;
        try {
            wSBusiCode = WSBusiCode.ZDCONFIG;
        }
        catch (Exception e) {
            this.transactionLogService.save("setReconciliationConfig", "0", JSONObject.toJSONString((Object)p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            return "1";
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString((Object)p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String reconciliationReplay(String tradeDate) {
        this.huifuReconcileService.reconcileSplitWS(tradeDate);
        return "1";
    }

    @Override
    public String createHuifuWalletReconciliation() {
        String[] days;
        for (String day : days = new String[]{DateUtils.formatDate((Date)DateUtils.addDays((Date)new Date(), (int)-2), (Object[])new Object[]{"yyyyMMdd"}), DateUtils.formatDate((Date)DateUtils.addDays((Date)new Date(), (int)-1), (Object[])new Object[]{"yyyyMMdd"}), DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyyMMdd"})}) {
            this.huifuReconcileService.reconcileSplitWS(day);
        }
        return "1";
    }

    @Override
    public Map<String, Object> getHuifuWalletReconciliation(HuifuWalletTradeDto dto) throws CrmebWalletException {
        if (dto.getPageNumber() == null) {
            throw new CrmebWalletException("\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new CrmebWalletException("\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getFundFlowType())) {
            throw new CrmebWalletException("\u8d44\u91d1\u6d41\u5411\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNotEmpty((String)dto.getStartDate())) {
            dto.setStartDate(dto.getStartDate().replace("-", ""));
        }
        if (StringUtil.isNotEmpty((String)dto.getEndDate())) {
            dto.setEndDate(dto.getEndDate().replace("-", ""));
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, Object>> list = this.huifuWalletReconciliationDao.getWalletReconciliationList(dto);
        Map<String, Object> map = this.huifuWalletReconciliationDao.getWalletReconciliationSum(dto);
        PageInfo pageInfo = new PageInfo(list);
        if (map != null) {
            map.put("pageInfo", pageInfo);
        }
        return map;
    }

    @Override
    public String exportHuifuWalletReconciliation(HuifuWalletTradeDto dto, HttpServletResponse response) throws CrmebWalletException {
        if (StringUtil.isEmpty((String)dto.getFundFlowType())) {
            throw new CrmebWalletException("\u8d44\u91d1\u6d41\u5411\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getStartDate())) {
            dto.setStartDate(dto.getStartDate().replace("-", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getEndDate())) {
            dto.setEndDate(dto.getEndDate().replace("-", ""));
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "\u5bf9\u8d26\u6570\u636e" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u5bf9\u8d26\u6570\u636e");
            List<Map<String, Object>> list = this.huifuWalletReconciliationDao.getWalletReconciliationList(dto);
            CellStyle stringStyle = ExcelUtil.getStringStyle((HSSFWorkbook)wb);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setAlignment(HorizontalAlignment.CENTER);
            titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));
            Map<String, Object> map = this.huifuWalletReconciliationDao.getWalletReconciliationSum(dto);
            String headerTitle = "";
            headerTitle = map == null ? MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14 | \u603b\u91d1\u989d\uff1a\u3010{1}\u3011\u5143 | \u6210\u529f\u7b14\u6570\uff1a\u3010{2}\u3011\u7b14 | \u6210\u529f\u91d1\u989d\uff1a\u3010{3}\u3011\u5143 | \u5931\u8d25\u7b14\u6570\uff1a\u3010{4}\u3011\u7b14 | \u5931\u8d25\u91d1\u989d\uff1a\u3010{5}\u3011\u5143 | \u5904\u7406\u4e2d\u7b14\u6570\uff1a\u3010{6}\u3011\u7b14 | \u5904\u7406\u4e2d\u91d1\u989d\uff1a\u3010{7}\u3011\u5143", 0, 0, 0, 0, 0, 0, 0, 0) : MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14 | \u603b\u91d1\u989d\uff1a\u3010{1}\u3011\u5143 | \u6210\u529f\u7b14\u6570\uff1a\u3010{2}\u3011\u7b14 | \u6210\u529f\u91d1\u989d\uff1a\u3010{3}\u3011\u5143 | \u5931\u8d25\u7b14\u6570\uff1a\u3010{4}\u3011\u7b14 | \u5931\u8d25\u91d1\u989d\uff1a\u3010{5}\u3011\u5143 | \u5904\u7406\u4e2d\u7b14\u6570\uff1a\u3010{6}\u3011\u7b14 | \u5904\u7406\u4e2d\u91d1\u989d\uff1a\u3010{7}\u3011\u5143", String.valueOf(map.get("totalCount")), String.valueOf(map.get("sumAmount")), String.valueOf(map.get("successCount")), String.valueOf(map.get("successAmount")), String.valueOf(map.get("errorCount")), String.valueOf(map.get("errorAmount")), String.valueOf(map.get("processingCount")), String.valueOf(map.get("processingAmount")));
            HSSFCellStyle titleStyle1 = wb.createCellStyle();
            HSSFFont titleFont1 = wb.createFont();
            titleFont1.setFontHeightInPoints((short)11);
            titleFont1.setColor(HSSFColor.RED.index);
            titleFont1.setFontName("\u9ed1\u4f53");
            titleStyle1.setVerticalAlignment(VerticalAlignment.CENTER);
            titleStyle1.setFont(titleFont1);
            titleStyle1.setWrapText(true);
            HSSFRow rowFirst = sheet1.createRow(0);
            rowFirst.setHeight((short)1000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 13));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle1);
            HSSFRow secondFirst = sheet1.createRow(1);
            String[] secondArr = new String[]{"\u5e8f\u53f7", "\u4ea4\u6613\u6d41\u6c34\u53f7", "\u94f6\u884c\u4ea4\u6613\u7c7b\u578b", "\u4ea4\u6613\u72b6\u6001", "\u4ea4\u6613\u8ba2\u5355\u521b\u5efa\u65f6\u95f4", "\u4ea4\u6613\u91d1\u989d", "\u51fa\u8d26\u65b9\u6237\u540d", "\u51fa\u8d26\u65b9\u8d26\u53f7", "\u51fa\u8d26\u65b9\u94f6\u884c", "\u5165\u8d26\u65b9\u6237\u540d", "\u5165\u8d26\u65b9\u8d26\u53f7", "\u5165\u8d26\u65b9\u94f6\u884c", "\u5165\u8d26\u65b9\u8bc1\u4ef6\u53f7", "\u5907\u6ce8"};
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                int column = i == 0 ? 1500 : (i == 4 ? 5000 : (i == 1 || i == 7 || i == 10 || i == 13 ? 8000 : (i == 6 || i == 9 ? 10000 : (i == 13 ? 14000 : 4000))));
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(titleStyle);
            }
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                cell.setCellValue(secondArr[i]);
                cell.setCellStyle(titleStyle);
            }
            CellStyle greenStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.SEA_GREEN.index);
            CellStyle redStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.RED.index);
            CellStyle blueStyle = ExcelUtil.getColorStyle((HSSFWorkbook)wb, (short)IndexedColors.BLUE.index);
            HSSFRow row = null;
            int rowIndex = 2;
            for (Map<String, Object> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue((double)(rowIndex - 1));
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("tradeSerialNo") != null ? result.get("tradeSerialNo").toString() : null);
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("bankTradeType") != null ? result.get("bankTradeType").toString() : null);
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("tradeStatus") != null ? result.get("tradeStatus").toString() : null);
                if (ObjectUtil.equal((Object)result.get("tradeStatus"), (Object)"\u4ea4\u6613\u6210\u529f")) {
                    cell3.setCellStyle(greenStyle);
                } else if (ObjectUtil.equal((Object)result.get("tradeStatus"), (Object)"\u4ea4\u6613\u5931\u8d25")) {
                    cell3.setCellStyle(redStyle);
                } else {
                    cell3.setCellStyle(blueStyle);
                }
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("tradeStartTime") != null ? result.get("tradeStartTime").toString() : null);
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("tradeAmount") != null ? result.get("tradeAmount").toString() : null);
                cell5.setCellStyle(redStyle);
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("expendAccountName") != null ? result.get("expendAccountName").toString() : null);
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("expendAccountNo") != null ? result.get("expendAccountNo").toString() : null);
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("expendBank") != null ? result.get("expendBank").toString() : null);
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("incomeAccountName") != null ? result.get("incomeAccountName").toString() : null);
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("incomeAccountNo") != null ? result.get("incomeAccountNo").toString() : null);
                HSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(result.get("incomeBank") != null ? result.get("incomeBank").toString() : null);
                HSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(result.get("incomeCerNo") != null ? result.get("incomeCerNo").toString() : null);
                HSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(result.get("remark") != null ? result.get("remark").toString() : null);
                ++rowIndex;
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new CrmebWalletException(e.getMessage());
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return "0";
    }

    @Override
    public String huifuWalletAccountTranslogTask(String startDate, String endDate) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)startDate) || StringUtils.isEmpty((CharSequence)endDate)) {
            startDate = DateUtil.formatDate((Date)DateUtil.yesterday());
            endDate = DateUtil.formatDate((Date)DateUtil.date());
        }
        List<HuifuWalletAccountDto> accountList = this.huifuWalletAccountDao.getLastDayTradeHuifuWalletAccount(startDate + " 00:00:00", endDate + " 23:59:59", PaymentChannel.WANGSHANG.toString());
        ArrayList detailList = Lists.newArrayList();
        ArrayList updateDetailList = Lists.newArrayList();
        ArrayList flowNoList = Lists.newArrayList();
        List<String> existsReqNoList = this.huifuWalletTranslogDao.selectReqNoByDate(startDate.replace("-", ""), endDate.replace("-", ""));
        List<String> pReqNoList = this.huifuWalletTranslogDao.selectPReqNoByDate(startDate.replace("-", ""), endDate.replace("-", ""));
        for (HuifuWalletAccountDto account : accountList) {
            List<HuifuWalletTrade> tradeList = this.huifuWalletTradeDao.findHuifuWalletTradeByUniIdAndType(account.getUniId(), "02", PaymentChannel.WANGSHANG.toString());
            for (HuifuWalletTrade trade : tradeList) {
                Map<String, Object> response;
                WSBusiCode wSBusiCode;
                HashMap<String, Object> p = new HashMap<String, Object>();
                p.put("merchantId", account.getWalletAccountNo());
                p.put("reqSeqId", trade.getReqSeqId());
                p.put("orderNo", trade.getBusinessPartnerSeq());
                try {
                    wSBusiCode = WSBusiCode.TXQUERY;
                    response = WSApiRequest.api(wSBusiCode, p);
                }
                catch (Exception e) {
                    this.transactionLogService.save(WSBusiCode.TXQUERY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
                    throw new CrmebWalletException(e.getMessage());
                }
                if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
                    this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                    String transStat = response.get("status").toString();
                    if ("SUCCESS".equals(transStat)) {
                        trade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)response.get("withdrawFinishDate").toString(), (String)"yyyyMMddHHmmss")));
                        trade.setTradeStatus(Constants.tradeStatus((String)"S"));
                    } else {
                        if (!"FAIL".equals(transStat)) continue;
                        trade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)response.get("withdrawFinishDate").toString(), (String)"yyyyMMddHHmmss")));
                        trade.setTradeStatus(Constants.tradeStatus((String)"F"));
                        trade.setErrorMsg(response.get("errorDesc").toString());
                    }
                    trade.setUpdateTime(new Date());
                    this.huifuWalletTradeDao.updateById(trade);
                    HuifuWalletTranslog translog = new HuifuWalletTranslog();
                    translog.setUniId(account.getUniId());
                    translog.setCreateTime(new Date());
                    translog.setTransId(trade.getHfSeqId());
                    translog.setTransDate(response.get("withdrawFinishDate").toString().substring(0, 8));
                    translog.setTransAmt(new BigDecimal(response.get("totalAmount").toString()).divide(new BigDecimal("100")).toString());
                    transStat = transStat.equals("SUCCESS") ? "\u6210\u529f" : (transStat.equals("FAIL") ? "\u5931\u8d25" : "\u5904\u7406\u4e2d");
                    translog.setTransStat(transStat);
                    translog.setCardNo(response.get("bankCardNo").toString());
                    translog.setCardName(response.get("bankCertName").toString());
                    translog.setBankCode(account.getBankCode());
                    String feeAmt = "0";
                    if (response.get("platformFee") != null) {
                        feeAmt = new BigDecimal(response.get("platformFee").toString()).divide(new BigDecimal("100")).toString();
                    }
                    translog.setFeeAmt(feeAmt);
                    translog.setRemark(response.get("memo") + "");
                    translog.setTransDesc(response.get("errorDesc") + "");
                    translog.setPayChannel(PaymentChannel.WANGSHANG.toString());
                    translog.setTransType("\u53d6\u73b0");
                    String reqNo = translog.getTransDate() + translog.getTransId();
                    if (!existsReqNoList.contains(reqNo)) {
                        detailList.add(translog);
                    }
                    if (pReqNoList.contains(reqNo)) {
                        updateDetailList.add(translog);
                    }
                    if (flowNoList.contains(reqNo)) continue;
                    flowNoList.add(reqNo);
                    continue;
                }
                this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
                this.log.error(WangShangWalletServiceImpl.RET(response, 2));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)updateDetailList)) {
            for (HuifuWalletTranslog detail : updateDetailList) {
                if ("\u5904\u7406\u4e2d".equals(detail.getTransStat())) continue;
                this.huifuWalletTranslogDao.updateStatus(detail);
            }
        }
        if (CollectionUtil.isEmpty((Collection)detailList)) {
            return "1";
        }
        this.huifuWalletTranslogDao.insertBatch(detailList);
        return "1";
    }

    @Override
    public String huifuWalletAccountFeeFileApply(String stmtType, String startDate, String endDate) throws CrmebWalletException {
        Map<String, Object> response;
        WSBusiCode wSBusiCode;
        if (StringUtils.isEmpty((CharSequence)startDate) || StringUtils.isEmpty((CharSequence)endDate)) {
            return "";
        }
        if ("1".equals(stmtType)) {
            startDate = DateUtil.format((Date)DateUtil.parse((String)startDate), (String)"yyyyMMddHHmmss");
            endDate = DateUtil.format((Date)DateUtil.parse((String)endDate), (String)"yyyyMMddHHmmss");
        } else if ("2".equals(stmtType)) {
            startDate = DateUtil.format((Date)DateUtil.parse((String)startDate), (String)"yyyyMMdd");
            endDate = DateUtil.format((Date)DateUtil.parse((String)endDate), (String)"yyyyMMdd");
        } else {
            startDate = DateUtil.format((Date)DateUtil.parse((String)startDate), (String)"yyyyMM");
            endDate = DateUtil.format((Date)DateUtil.parse((String)endDate), (String)"yyyyMM");
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("stmtType", stmtType);
        p.put("startTime", startDate);
        p.put("endTime", endDate);
        try {
            wSBusiCode = WSBusiCode.FEEFILEAPPLY;
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.FEEFILEAPPLY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            return response.get("backOrderNo").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public Map<String, Object> huifuWalletAccountFeeFileQuery(String stmtType, String outRequestNo, String backOrderNo) throws CrmebWalletException {
        Map<String, Object> response;
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("stmtType", stmtType);
        p.put("outRequestNo", outRequestNo);
        p.put("backOrderNo", backOrderNo);
        WSBusiCode wSBusiCode = WSBusiCode.FEEFILEQUERY;
        try {
            response = WSApiRequest.api(wSBusiCode, p);
        }
        catch (Exception e) {
            this.transactionLogService.save(WSBusiCode.FEEFILEQUERY.toString(), "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            return response;
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public PageInfo<HuifuWalletTranslog> thisHuifuWalletTranslog(HuifuWalletTranslogDto dto) throws CrmebWalletException {
        if (StringUtils.isEmpty((CharSequence)dto.getUniId())) {
            throw new CrmebWalletException("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageNumber() == null) {
            throw new CrmebWalletException("\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            throw new CrmebWalletException("\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getStartDate())) {
            throw new CrmebWalletException("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getEndDate())) {
            throw new CrmebWalletException("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        dto.setStartDate(dto.getStartDate().replace("-", ""));
        dto.setEndDate(dto.getEndDate().replace("-", ""));
        List<HuifuWalletTranslog> detailList = this.huifuWalletTranslogDao.selectByUniIdAndDate(dto);
        return new PageInfo(detailList);
    }

    @Override
    public String huifuJspayTransfer(JsPayTransferDto dto) throws CrmebWalletException {
        WSBusiCode wSBusiCode;
        Date date = new Date();
        logger.info(">>>>>>>>> C\u7aef\u8f6c\u8d26\u63a5\u53e3huifuJspayTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u5f00\u59cb");
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new CrmebWalletException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean redisRepetition = this.redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            logger.info(">>>>>>>>> C\u7aef\u8f6c\u8d26\u63a5\u53e3huifuJspayTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade > 0) {
            logger.info(">>>>>>>>> C\u7aef\u8f6c\u8d26\u63a5\u53e3huifuJspayTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (StringUtil.isEmpty((String)dto.getGoodsDesc())) {
            throw new CrmebWalletException("\u5546\u54c1\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> p = new HashMap<String, String>();
        HuifuWalletAccountDto inAccount = dto.getSellFeePriority() == 0 ? this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no")) : this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(dto.getInId(), PaymentChannel.WANGSHANG.toString());
        if (inAccount == null) {
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        p.put("huifuId", "6666000138624387");
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("transAmt", dto.getAmount());
        p.put("isPlatAcct", "0");
        p.put("platAmount", "0.00");
        p.put("tradeType", dto.getTradeType());
        String inAmount = dto.getAmount();
        BigDecimal commissionAmount = new BigDecimal(inAmount).multiply(new BigDecimal("0.0063"));
        if (commissionAmount.compareTo(new BigDecimal("0.01")) < 0) {
            commissionAmount = new BigDecimal("0.01");
        }
        String cAmount = decimalFormat.format(commissionAmount);
        BigDecimal fee = new BigDecimal(inAmount).subtract(commissionAmount);
        inAmount = decimalFormat.format(fee);
        p.put("inAmount", inAmount);
        p.put("inWalletAccountNo", inAccount.getWalletAccountNo());
        p.put("commissionAmount", cAmount);
        String wxData = dto.getWxData() != null ? JSONObject.toJSONString((Object)dto.getWxData()) : "";
        String alipayData = dto.getAlipayData() != null ? JSONObject.toJSONString((Object)dto.getAlipayData()) : "";
        p.put("wxData", wxData);
        p.put("alipayData", alipayData);
        p.put("notifyUrl", this.systemConfigService.getValueByKey("hf_api_url") + "/api/front/wallet/huifuJspayCallback");
        p.put("remark", dto.getComment());
        p.put("goodDesc", dto.getGoodsDesc());
        logger.info(">>>>>>>>> C\u7aef\u8f6c\u8d26\u63a5\u53e3huifuJspayTransfer\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a" + ((Object)p).toString());
        Map response = null;
        try {
            wSBusiCode = WSBusiCode.JSPAY;
        }
        catch (Exception e2) {
            this.transactionLogService.save("huifuJspayTransfer", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1)) || "00000100".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            String ina = dto.getAmount();
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                JsPayTrade jsPayTrade = new JsPayTrade();
                jsPayTrade.setBusinessCode(dto.getBusinessCode());
                jsPayTrade.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
                jsPayTrade.setReqSeqId(response.get("reqSeqId").toString());
                jsPayTrade.setHfSeqId(response.get("hfSeqId").toString());
                jsPayTrade.setCreateTime(date);
                jsPayTrade.setUpdateTime(new Date());
                jsPayTrade.setGoodDesc(dto.getGoodsDesc());
                if (dto.getWxData() != null) {
                    jsPayTrade.setWxData(JSON.toJSONString((Object)dto.getWxData()));
                }
                if (dto.getAlipayData() != null) {
                    jsPayTrade.setAlipayData(JSON.toJSONString((Object)dto.getAlipayData()));
                }
                logger.info(">>>>>>>>> C\u7aef\u8f6c\u8d26\u63a5\u53e3huifuJspayTransfer\uff0cpay_info\u8f6c\u4e49\uff1a" + response.get("pay_info").toString().replace("\"", "\\\""));
                jsPayTrade.setPayInfo(response.get("pay_info").toString());
                jsPayTrade.setIncomeAccountNo(inAccount.getWalletAccountNo());
                jsPayTrade.setInUniId(inAccount.getUniId());
                jsPayTrade.setRemark(dto.getComment());
                jsPayTrade.setUniId(dto.getUniId());
                jsPayTrade.setAmount(new BigDecimal(ina));
                jsPayTrade.setCommissionAmount(new BigDecimal(cAmount));
                jsPayTrade.setTradeType(dto.getTradeType());
                jsPayTrade.setTradeStatus(Constants.tradeStatus((String)response.get("trans_stat").toString()));
                this.jsPayTradeDao.insert(jsPayTrade);
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u4ea4\u6613\u652f\u4ed8-\u64cd\u4f5c\u5931\u8d25");
            }
            logger.info("===>C\u7aef\u8f6c\u8d26\u63a5\u53e3huifuJspayTransfer.\u672c\u6b21\u8f6c\u8d26\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a) / 1000L + "\u79d2");
            logger.info(">>>>>>>>> C\u7aef\u8f6c\u8d26\u63a5\u53e3huifuJspayTransfer\uff1a" + dto.getBusinessPartnerSeq() + ",\u652f\u4ed8\u786e\u8ba4\uff1asucc");
            return response.get("pay_info").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    public static void main(String[] args) {
        String cashAmt = "5000";
        String fee = "0.0005";
        BigDecimal bdFee = new BigDecimal(cashAmt).multiply(new BigDecimal(fee));
        bdFee = bdFee.intValue() < 1 ? BigDecimal.ONE : bdFee.setScale(0, RoundingMode.UP);
        String platformFee = bdFee.toString();
        System.out.println(platformFee);
    }

    @Override
    public void jspayAddAccountDetail(JsPayTrade jsPayTrade) throws CrmebWalletException {
        WSBusiCode wSBusiCode;
        HuifuWalletAccountDto dto = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(jsPayTrade.getIncomeAccountNo());
        HuifuWalletAccountDetail detail = this.huifuWalletAccountDetailDao.geAccountDetailByTradeFlowNo(jsPayTrade.getHfSeqId(), dto.getUniId());
        if (detail != null) {
            return;
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("huifuId", "6666000138624387");
        p.put("orgHfSeqId", jsPayTrade.getHfSeqId());
        p.put("orgReqDate", DateUtils.formatDate((Date)jsPayTrade.getCreateTime(), (Object[])new Object[]{"yyyyMMdd"}));
        Map response = null;
        try {
            wSBusiCode = WSBusiCode.SCANPAYQUERY;
        }
        catch (Exception e) {
            this.transactionLogService.save("jspayAddAccountDetail", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            detail = new HuifuWalletAccountDetail();
            detail.setTradeDate(response.get("trans_time").toString());
            detail.setTradeFlowNo(jsPayTrade.getHfSeqId());
            detail.setFlowNo(response.get("out_trans_id").toString());
            detail.setAccountsDealType("\u5185\u90e8\u6237\u5904\u7406");
            detail.setAccountsDealDate(response.get("acct_date").toString());
            detail.setAmount(response.get("trans_amt").toString());
            detail.setBalance("");
            detail.setDirection("\u5165\u8d26");
            String acctStat = response.get("acct_stat").toString();
            String tradeStatus = "I".equals(acctStat) ? "\u521d\u59cb" : ("P".equals(acctStat) ? "\u5904\u7406\u4e2d" : ("S".equals(acctStat) ? "\u6210\u529f" : "\u5931\u8d25"));
            detail.setHandStatus(tradeStatus);
            detail.setTradeType(response.get("acct_trans_type").toString());
            detail.setUniId(dto.getUniId());
            detail.setAccountIn(dto.getWalletAccountNo());
            this.huifuWalletAccountDetailDao.insert(detail);
        } else {
            this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            this.log.error(WangShangWalletServiceImpl.RET(response, 2));
        }
    }

    @Override
    public String huifuJspayRefund(JsPayTransferDto dto) throws CrmebWalletException {
        WSBusiCode wSBusiCode;
        Date date = new Date();
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)dto.getAmount())) {
            throw new CrmebWalletException("\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getOldBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u539f\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JsPayTrade jpt = this.jsPayTradeDao.getHfReqIdByReq(dto.getOldBusinessPartnerSeq());
        if (jpt == null) {
            throw new CrmebWalletException("\u539f\u4e1a\u52a1\u4ea4\u6613\u8bb0\u5f55\u65e0\u6548\u6216\u4e0d\u5b58\u5728");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessCode())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)dto.getBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dto.setBusinessPartnerSeq(dto.getBusinessPartnerSeq() + "CT");
        logger.info(">>>>>>>>> C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund\uff1a" + dto.getBusinessPartnerSeq() + ",\u5f00\u59cb");
        boolean redisRepetition = this.redisUtil.getRedisRepetition(dto.getBusinessPartnerSeq());
        if (!redisRepetition) {
            logger.info(">>>>>>>>> C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        int countTrade = this.huifuWalletTradeDao.getHuifuWalletTradeByReq(dto.getBusinessPartnerSeq(), dto.getTradeType());
        if (countTrade > 0) {
            logger.info(">>>>>>>>> C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund\uff1a" + dto.getBusinessPartnerSeq() + ",\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
            throw new CrmebWalletException("\u4ea4\u6613\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        HashMap<String, String> p = new HashMap<String, String>();
        HuifuWalletAccountDto outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(jpt.getIncomeAccountNo());
        if (outAccount == null) {
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String platAmount = dto.getPlatAmount();
        String lockAmount = decimalFormat.format(jpt.getAmount().subtract(new BigDecimal(platAmount)));
        if (dto.getSellFeePriority() == 0) {
            lockAmount = decimalFormat.format(new BigDecimal(platAmount));
        }
        String tradeType = StringUtils.isEmpty((CharSequence)dto.getTradeType()) ? "05" : dto.getTradeType();
        lockAmount = decimalFormat.format(new BigDecimal(lockAmount).subtract(jpt.getCommissionAmount()));
        p.put("huifuId", "6666000138624387");
        p.put("reqSeqId", SequenceTools.getReqSeqId32());
        p.put("ordAmt", dto.getAmount());
        p.put("orgHfSeqId", jpt.getHfSeqId());
        p.put("orgReqDate", DateUtils.formatDate((Date)jpt.getCreateTime(), (Object[])new Object[]{"yyyyMMdd"}));
        p.put("notifyUrl", this.systemConfigService.getValueByKey("hf_api_url") + "/api/front/wallet/huifuJspayRefundCallback");
        p.put("remark", dto.getComment());
        Map response = null;
        try {
            wSBusiCode = WSBusiCode.SCANPAYREFUND;
        }
        catch (Exception e2) {
            this.transactionLogService.save("huifuJspayRefund", "0", JSONObject.toJSONString(p), e2.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e2.getMessage());
        }
        String lockAmountStr = lockAmount;
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1)) || "00000100".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.syncUpdateSumFrozenAmount(outAccount.getUniId(), "04".equals(dto.getTradeType()) ? new BigDecimal(lockAmountStr) : ("05".equals(dto.getTradeType()) ? new BigDecimal("-" + lockAmountStr) : BigDecimal.ZERO));
                logger.info(">>>>>>>>> C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund response\uff1a11133333");
                this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString((Object)p), JSONObject.toJSONString((Object)response), PaymentChannel.WANGSHANG.toString());
                JsPayTrade jsPayTrade = new JsPayTrade();
                jsPayTrade.setBusinessCode(dto.getBusinessCode());
                jsPayTrade.setBusinessPartnerSeq(dto.getBusinessPartnerSeq());
                jsPayTrade.setOldBusinessPartnerSeq(jpt.getBusinessPartnerSeq());
                jsPayTrade.setReqSeqId(response.get("reqSeqId").toString());
                jsPayTrade.setHfSeqId(response.get("hfSeqId").toString());
                jsPayTrade.setCreateTime(date);
                jsPayTrade.setUpdateTime(new Date());
                jsPayTrade.setGoodDesc("\uff08\u9000\u6b3e\uff09" + jpt.getGoodDesc());
                jsPayTrade.setTransFinishTime(response.get("trans_date") + "" + response.get("trans_time"));
                jsPayTrade.setPayInfo(response.get("acct_split_bunch").toString());
                jsPayTrade.setOutcomeAccountNo(outAccount.getWalletAccountNo());
                jsPayTrade.setInUniId(jpt.getUniId());
                jsPayTrade.setRemark(dto.getComment());
                jsPayTrade.setUniId(outAccount.getUniId());
                jsPayTrade.setAmount(new BigDecimal(dto.getAmount()));
                jsPayTrade.setTradeType(dto.getTradeType());
                jsPayTrade.setTradeStatus(Constants.tradeStatus((String)response.get("trans_stat").toString()));
                this.jsPayTradeDao.insert(jsPayTrade);
                return Boolean.TRUE;
            });
            if (!execute.booleanValue()) {
                throw new CrmebWalletException("\u4f01\u4e1a\u94b1\u5305-\u4ea4\u6613\u652f\u4ed8-\u64cd\u4f5c\u5931\u8d25");
            }
            logger.info(">>>>>>>>> C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund response\uff1a222222");
            if (Double.parseDouble(dto.getPlatAmount()) > 0.0) {
                HuifuWalletAccountDto platAccount;
                if (dto.getSellFeePriority() == 0) {
                    dto.setPlatAmount(new BigDecimal(dto.getAmount()).subtract(new BigDecimal(dto.getPlatAmount())).toString());
                    platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByUniId(jpt.getInUniId(), PaymentChannel.WANGSHANG.toString());
                } else {
                    platAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(this.systemConfigService.getValueByKey("ws_plat_no"));
                }
                logger.info(">>>>>>>>> C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund\uff1a\u4e8c\u7ea7\u5206\u8d26\u9000\u6b3e\u5f00\u59cb");
                HuifuWalletTransferDto dtoP = new HuifuWalletTransferDto();
                dtoP.setAmount(dto.getPlatAmount());
                dtoP.setOutId(platAccount.getUniId());
                dtoP.setInId(outAccount.getUniId());
                String comment = dto.getSellFeePriority() == 0 ? "\u8ba2\u5355\u3010" + dto.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5546\u54c1\u8d39\u9000\u6b3e\uff1a" + dto.getPlatAmount() + "\u5143" : "\u8ba2\u5355\u3010" + dto.getBusinessPartnerSeq() + "\u3011\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u8d39\u9000\u6b3e\uff1a" + dto.getPlatAmount() + "\u5143";
                dtoP.setComment(comment);
                dtoP.setBusinessPartnerSeq(dto.getBusinessPartnerSeq() + "-PT");
                dtoP.setTradeType(tradeType);
                dtoP.setBusinessCode(jpt.getBusinessCode());
                dtoP.setGoodsName(jpt.getGoodDesc());
                dtoP.setGoodsNumber("-");
                dtoP.setGoodsUnit("-");
                logger.info(">>>>>>>>> C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund\uff1a\u4e8c\u7ea7\u5206\u8d26\u9000\u6b3e\u62a5\u6587\u5185\u5bb9\uff1a" + JSON.toJSONString((Object)dtoP));
                this.syncRefundToPlat(dtoP);
                logger.info(">>>>>>>>> C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund\uff1a\u4e8c\u7ea7\u5206\u8d26\u9000\u6b3e\u4efb\u52a1\u751f\u6210");
            }
            logger.info("===>C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund.\u672c\u6b21\u8f6c\u8d26\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a) / 1000L + "\u79d2");
            logger.info(">>>>>>>>> C\u7aef\u9000\u6b3e\u63a5\u53e3huifuJspayRefund\uff1a" + dto.getBusinessPartnerSeq() + ",\u652f\u4ed8\u786e\u8ba4\uff1asucc");
            return response.get("hfSeqId").toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public String huifuJspayRefundQuery(JsPayTransferDto dto) throws CrmebWalletException {
        WSBusiCode wSBusiCode;
        Date date = new Date();
        logger.info(">>>>>>>>> C\u7aef\u4ea4\u6613\u9000\u6b3e\u67e5\u8be2\u63a5\u53e3huifuJspayRefundQuery\uff1a" + dto.getBusinessPartnerSeq() + ",\u5f00\u59cb");
        long a = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)dto.getOldBusinessPartnerSeq())) {
            throw new CrmebWalletException("\u539f\u4e1a\u52a1\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JsPayTrade jpt = this.jsPayTradeDao.getHfReqIdByReq(dto.getOldBusinessPartnerSeq());
        if (jpt == null) {
            throw new CrmebWalletException("\u539f\u4e1a\u52a1\u4ea4\u6613\u8bb0\u5f55\u65e0\u6548\u6216\u4e0d\u5b58\u5728");
        }
        HashMap<String, String> p = new HashMap<String, String>();
        HuifuWalletAccountDto outAccount = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(jpt.getIncomeAccountNo());
        if (outAccount == null) {
            throw new CrmebWalletException("\u5546\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        p.put("huifuId", jpt.getOutcomeAccountNo());
        p.put("orgHfSeqId", jpt.getHfSeqId());
        p.put("orgReqDate", DateUtils.formatDate((Date)jpt.getCreateTime(), (Object[])new Object[]{"yyyyMMdd"}));
        Object response = null;
        try {
            wSBusiCode = WSBusiCode.REFUNDQUERY;
        }
        catch (Exception e) {
            this.transactionLogService.save("huifuJspayRefundQuery", "0", JSONObject.toJSONString(p), e.getMessage(), PaymentChannel.WANGSHANG.toString());
            throw new CrmebWalletException(e.getMessage());
        }
        if ("00000000".equals(WangShangWalletServiceImpl.RET(response, 1))) {
            this.transactionLogService.save(wSBusiCode.toString(), "1", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
            logger.info("===>C\u7aef\u4ea4\u6613\u9000\u6b3e\u67e5\u8be2\u63a5\u53e3huifuJspayRefundQuery.\u672c\u6b21\u8f6c\u8d26\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a) / 1000L + "\u79d2");
            logger.info(">>>>>>>>> C\u7aef\u4ea4\u6613\u9000\u6b3e\u67e5\u8be2\u63a5\u53e3huifuJspayRefundQuery\uff1a" + dto.getBusinessPartnerSeq() + ",\u652f\u4ed8\u786e\u8ba4\uff1asucc");
            return response.toString();
        }
        this.transactionLogService.save(wSBusiCode.toString(), "0", JSONObject.toJSONString(p), JSONObject.toJSONString(response), PaymentChannel.WANGSHANG.toString());
        throw new CrmebWalletException(WangShangWalletServiceImpl.RET(response, 2));
    }

    @Override
    public void testLock(String uniId, String tradeType, String amount) {
        this.syncUpdateSumFrozenAmount(uniId, "04".equals(tradeType) ? new BigDecimal(amount) : ("05".equals(tradeType) ? new BigDecimal("-" + amount) : BigDecimal.ZERO));
    }
}

