/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxPlatformFeeConfig;
import com.zbkj.common.model.order.VirtualOrder;
import com.zbkj.common.model.order.VirtualOrderOperate;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.user.User;
import com.zbkj.common.request.CreateOrderRequest;
import com.zbkj.common.response.OrderNoResponse;
import com.zbkj.common.response.VirtualOrderResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.PreMerchantOrderVo;
import com.zbkj.common.vo.PreOrderInfoDetailVo;
import com.zbkj.common.vo.PreOrderInfoVo;
import com.zbkj.service.dao.VirtualOrderDao;
import com.zbkj.service.factory.PaymentFactory;
import com.zbkj.service.service.CommonWalletService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.VirtualOrderOperateService;
import com.zbkj.service.service.VirtualOrderService;
import com.zbkj.service.service.bcx.BcxPlatformFeeConfigService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class VirtualOrderServiceImpl
extends ServiceImpl<VirtualOrderDao, VirtualOrder>
implements VirtualOrderService {
    private final Logger logger = LoggerFactory.getLogger(VirtualOrderServiceImpl.class);
    @Resource
    private VirtualOrderDao dao;
    @Resource
    private VirtualOrderOperateService virtualOrderOperateService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private BcxPlatformFeeConfigService bcxPlatformFeeConfigService;
    @Autowired
    private PaymentFactory paymentFactory;
    @Autowired
    CommonWalletService commonWalletService;
    @Autowired
    private RedissonClient redisson;
    private static final String VIRTUALREFUNDKEY = "VirtualRefund:";

    @Override
    public VirtualOrder getByVirtualOrderNo(String virtualOrderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(VirtualOrder::getVirtualOrderNo, (Object)virtualOrderNo);
        lqw.last(" limit 1");
        return (VirtualOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public VirtualOrderResponse getVirtualOrderByVirtualOrderNo(String virtualOrderNo) {
        return this.dao.getVirtualOrderByVirtualOrderNo(virtualOrderNo);
    }

    @Override
    public List<VirtualOrderResponse> queryVirtualOrderList(Map<String, Object> queryParam) {
        return this.dao.queryVirtualOrderList(queryParam);
    }

    @Override
    public List<VirtualOrderResponse> queryExistAvailableNumByUid(Integer uid) {
        return this.dao.queryExistAvailableNumByUid(uid);
    }

    @Override
    public int countAvailableNumByUid(Integer uid) {
        return this.dao.countAvailableNumByUid(uid);
    }

    @Override
    public OrderNoResponse createOrder(CreateOrderRequest orderRequest, PreOrderInfoVo orderInfoVo, List<MyRecord> skuRecordList, User user) {
        PreMerchantOrderVo merchantOrderVo = (PreMerchantOrderVo)orderInfoVo.getMerchantOrderVoList().get(0);
        PreOrderInfoDetailVo detailVo = (PreOrderInfoDetailVo)merchantOrderVo.getOrderInfoList().get(0);
        VirtualOrder virtualOrder = new VirtualOrder();
        virtualOrder.setVirtualOrderNo(CrmebUtil.getOrderNo((String)"VIR"));
        virtualOrder.setMerId(orderInfoVo.getMerId());
        virtualOrder.setUid(user.getId());
        virtualOrder.setProductId(detailVo.getProductId());
        virtualOrder.setAttrValueId(detailVo.getAttrValueId());
        virtualOrder.setSku(detailVo.getSku());
        virtualOrder.setPrice(detailVo.getPrice());
        virtualOrder.setPayNum(detailVo.getPayNum());
        virtualOrder.setTotalPrice(detailVo.getPrice().multiply(new BigDecimal(detailVo.getPayNum())));
        virtualOrder.setDealNum(Integer.valueOf(0));
        virtualOrder.setRefundNum(Integer.valueOf(0));
        virtualOrder.setCreateOrderRequest(JSON.toJSONString((Object)orderRequest));
        virtualOrder.setPreOrderInfoVo(JSON.toJSONString((Object)orderInfoVo));
        virtualOrder.setCreateTime(new Date());
        virtualOrder.setUpdateTime(new Date());
        virtualOrder.setStatus(OrderConstants.ORDER_STATUS_WAIT_PAY);
        virtualOrder.setSourceId(detailVo.getSourceId());
        List merchantOrderVoList = orderInfoVo.getMerchantOrderVoList();
        List<Integer> productIds = merchantOrderVoList.stream().flatMap(ov -> ov.getOrderInfoList().stream()).map(PreOrderInfoDetailVo::getProductId).collect(Collectors.toList());
        if (productIds.size() != 1) {
            throw new CrmebException("\u4e00\u4e2a\u8ba2\u5355\u5185\u53ea\u80fd\u6709\u4e00\u79cd\u7c7b\u578b\u7684\u5546\u54c1");
        }
        Product product = (Product)this.productService.getById((Serializable)productIds.get(0));
        Integer bizType = this.orderService.getBizTypeByProductsType(productIds);
        virtualOrder.setBizType(bizType);
        virtualOrder.setProductName(product.getName());
        virtualOrder.setBizSubType(product.getBizSubType());
        BcxPlatformFeeConfig platFeeConfig = this.bcxPlatformFeeConfigService.queryByAnyId(orderInfoVo.getMerId(), detailVo.getProductId(), 0);
        if (platFeeConfig == null) {
            throw new CrmebException("\u5e73\u53f0\u670d\u52a1\u8d39\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
        }
        virtualOrder.setPlatFeeConfig(JSON.toJSONString((Object)platFeeConfig));
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean result = true;
            this.logger.info("\u865a\u62df\u8ba2\u5355-\u5f00\u59cb\u6263\u4ef6\u5546\u54c1\u5e93\u5b58:virtualOrder:{}", (Object)JSON.toJSONString((Object)virtualOrder));
            if (orderInfoVo.getType().equals(OrderConstants.ORDER_TYPE_NORMAL)) {
                this.logger.info("\u865a\u62df\u8ba2\u5355-\u5f00\u59cb\u6263\u4ef6\u5546\u54c1\u5e93\u5b58 --> \u666e\u901a\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)skuRecordList));
                for (MyRecord skuRecord : skuRecordList) {
                    result = this.productService.operationStock(skuRecord.getInt("productId"), skuRecord.getInt("num"), "sub");
                    if (!result.booleanValue()) {
                        e.setRollbackOnly();
                        this.logger.error("\u865a\u62df\u8ba2\u5355-\u751f\u6210\u8ba2\u5355\u6263\u51cf\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a{},\u5546\u54c1ID\uff1a{}", (Object)orderRequest.getPreOrderNo(), (Object)skuRecord.getInt("productId"));
                        return result;
                    }
                    result = this.productAttrValueService.operationStock(skuRecord.getInt("attrValueId"), skuRecord.getInt("num"), "sub", ProductConstants.PRODUCT_TYPE_NORMAL, skuRecord.getInt("attrValueVersion"));
                    if (result.booleanValue()) continue;
                    e.setRollbackOnly();
                    this.logger.error("\u865a\u62df\u8ba2\u5355-\u751f\u6210\u8ba2\u5355\u6263\u51cf\u5546\u54c1sku\u5e93\u5b58\u5931\u8d25,\u9884\u4e0b\u5355\u53f7\uff1a{},\u5546\u54c1skuID\uff1a{}", (Object)orderRequest.getPreOrderNo(), (Object)skuRecord.getInt("attrValueId"));
                    return result;
                }
            }
            this.save(virtualOrder);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u865a\u62df\u8ba2\u5355\u751f\u6210\u5931\u8d25");
        }
        OrderNoResponse response = new OrderNoResponse();
        response.setOrderNo(virtualOrder.getVirtualOrderNo());
        response.setPayPrice(virtualOrder.getTotalPrice());
        return response;
    }

    @Override
    public boolean virtualOrderPay(VirtualOrder virtualOrder, String uniId) {
        return (Boolean)this.transactionTemplate.execute(i -> {
            try {
                virtualOrder.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
                virtualOrder.setUpdateTime(new Date());
                this.updateById(virtualOrder);
                if (virtualOrder.getTotalPrice().compareTo(BigDecimal.ZERO) != 0) {
                    return this.commonWalletService.modifyBalance(uniId, virtualOrder.getTotalPrice(), this.systemConfigService.getValueByKey("pay_channel"));
                }
            }
            catch (Exception ex) {
                this.logger.error("virtualOrderPay.modifyBalance | msg : " + ex.getMessage());
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public boolean changeNumByVirtualOrderMap(Map<String, Long> virtualOrderMap, User user) {
        ArrayList olist = new ArrayList();
        AtomicReference<BigDecimal> amount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        ArrayList virtualOrderResponseList = new ArrayList();
        virtualOrderMap.forEach((key, value) -> {
            block9: {
                String lockId = VIRTUALREFUNDKEY + key;
                RLock lock = this.redisson.getLock(lockId);
                try {
                    if (lock.tryLock(3L, 10L, TimeUnit.SECONDS)) {
                        this.log.debug(lockId + ":getLock: " + Thread.currentThread().getId());
                        Integer num = Math.toIntExact(value);
                        VirtualOrderResponse orderResponse = this.getVirtualOrderByVirtualOrderNo((String)key);
                        if (orderResponse == null) {
                            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728\u9000\u6b3e\u5931\u8d25");
                        }
                        if (orderResponse.getAvailableNum() < num) {
                            throw new CrmebException("\u7528\u6237\u5269\u4f59\u53ef\u7528\u6570\u91cf\u4e0d\u8db3");
                        }
                        orderResponse.setRefundNum(Integer.valueOf(orderResponse.getRefundNum() + num));
                        virtualOrderResponseList.add(orderResponse);
                        olist.add(this.buildOperate(orderResponse, 2, num));
                        amount.set(((BigDecimal)amount.get()).add(orderResponse.getPrice().multiply(new BigDecimal(num))));
                        break block9;
                    }
                    throw new CrmebException("\u8d44\u6e90\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                catch (Exception e) {
                    this.log.error("changeNumByVirtualOrderMap Exception=" + e.getMessage());
                    throw new CrmebException(e.getMessage());
                }
                finally {
                    if (lock.isHeldByCurrentThread()) {
                        this.log.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                        lock.unlock();
                    }
                }
            }
        });
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            virtualOrderResponseList.stream().forEach(orderResponse -> this.dao.updateRefundNum((VirtualOrderResponse)orderResponse));
            this.virtualOrderOperateService.saveBatch(olist);
            try {
                BigDecimal price = (BigDecimal)amount.get();
                if (price.compareTo(BigDecimal.ZERO) != 0) {
                    return this.commonWalletService.modifyBalance(user.getIdentityNo(), price.negate(), this.systemConfigService.getValueByKey("pay_channel"));
                }
            }
            catch (Exception ex) {
                this.logger.error("changeNumByVirtualOrderMap.modifyBalance | msg : " + ex.getMessage());
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u9000\u6b3e\u5931\u8d25\uff01");
        }
        return true;
    }

    @Override
    public boolean dealNumByVirtualOrderMap(Map<String, Long> virtualOrderMap, User user) {
        ArrayList olist = new ArrayList();
        AtomicReference<BigDecimal> amount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        ArrayList virtualOrderResponseList = new ArrayList();
        virtualOrderMap.forEach((key, value) -> {
            block9: {
                String lockId = VIRTUALREFUNDKEY + key;
                RLock lock = this.redisson.getLock(lockId);
                try {
                    if (lock.tryLock(3L, 10L, TimeUnit.SECONDS)) {
                        this.log.debug(lockId + ":getLock: " + Thread.currentThread().getId());
                        Integer num = Math.toIntExact(value);
                        VirtualOrderResponse orderResponse = this.getVirtualOrderByVirtualOrderNo((String)key);
                        if (orderResponse == null) {
                            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728\u9000\u6b3e\u5931\u8d25");
                        }
                        if (orderResponse.getAvailableNum() < num) {
                            throw new CrmebException("\u7528\u6237\u5269\u4f59\u53ef\u7528\u6570\u91cf\u4e0d\u8db3");
                        }
                        orderResponse.setDealNum(Integer.valueOf(orderResponse.getDealNum() + num));
                        virtualOrderResponseList.add(orderResponse);
                        olist.add(this.buildOperate(orderResponse, 1, num));
                        amount.set(((BigDecimal)amount.get()).add(orderResponse.getPrice().multiply(new BigDecimal(num))));
                        break block9;
                    }
                    throw new CrmebException("\u8d44\u6e90\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                catch (Exception e) {
                    this.log.error("changeNumByVirtualOrderMap Exception=" + e.getMessage());
                    throw new CrmebException(e.getMessage());
                }
                finally {
                    if (lock.isHeldByCurrentThread()) {
                        this.log.debug(lockId + ":unLock: " + Thread.currentThread().getId());
                        lock.unlock();
                    }
                }
            }
        });
        Boolean execute = (Boolean)this.transactionTemplate.execute(i -> {
            virtualOrderResponseList.stream().forEach(orderResponse -> this.dao.updateDealNum((VirtualOrderResponse)orderResponse));
            this.virtualOrderOperateService.saveBatch(olist);
            try {
                BigDecimal price = (BigDecimal)amount.get();
                if (price.compareTo(BigDecimal.ZERO) != 0) {
                    return this.commonWalletService.modifyBalance(user.getIdentityNo(), price.negate(), this.systemConfigService.getValueByKey("pay_channel"));
                }
            }
            catch (Exception ex) {
                this.logger.error("dealNumByVirtualOrderMap.modifyBalance | msg : " + ex.getMessage());
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u865a\u5355\u6570\u91cf\u6d88\u8017\u5931\u8d25\uff01");
        }
        return true;
    }

    private VirtualOrderOperate buildOperate(VirtualOrderResponse virtualOrder, Integer type, Integer num) {
        VirtualOrderOperate operate = new VirtualOrderOperate();
        operate.setOperateNo(CrmebUtil.getUuid());
        operate.setVirtualOrderNo(virtualOrder.getVirtualOrderNo());
        operate.setMerId(virtualOrder.getMerId());
        operate.setUid(virtualOrder.getUid());
        operate.setProductId(virtualOrder.getProductId());
        operate.setProductName(virtualOrder.getProductName());
        operate.setAttrValueId(virtualOrder.getAttrValueId());
        operate.setSku(virtualOrder.getSku());
        operate.setPrice(virtualOrder.getPrice());
        operate.setOperateNum(num);
        operate.setTotalPrice(virtualOrder.getPrice().multiply(new BigDecimal(num)));
        operate.setOperateType(type == 1 ? "\u4ea4\u6613" : "\u9000\u6b3e");
        operate.setCreateTime(new Date());
        operate.setUpdateTime(new Date());
        return operate;
    }
}

