/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.product.ProductRule;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ProductRuleRequest;
import com.zbkj.common.request.ProductRuleSearchRequest;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.ProductRuleDao;
import com.zbkj.service.service.ProductRuleService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ProductRuleServiceImpl
extends ServiceImpl<ProductRuleDao, ProductRule>
implements ProductRuleService {
    @Resource
    private ProductRuleDao dao;

    @Override
    public PageInfo<ProductRule> getList(ProductRuleSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ProductRule::getMerId, (Object)systemAdmin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            lambdaQueryWrapper.like(ProductRule::getRuleName, (Object)request.getKeywords());
        }
        lambdaQueryWrapper.orderByDesc(ProductRule::getId);
        List list = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public boolean save(ProductRuleRequest ProductRuleRequest2) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (this.existRuleName(ProductRuleRequest2.getRuleName(), systemAdmin.getMerId()).booleanValue()) {
            throw new CrmebException("\u6b64\u89c4\u683c\u503c\u5df2\u7ecf\u5b58\u5728");
        }
        ProductRule ProductRule2 = new ProductRule();
        BeanUtils.copyProperties((Object)ProductRuleRequest2, (Object)ProductRule2);
        ProductRule2.setMerId(systemAdmin.getMerId());
        return this.save(ProductRule2);
    }

    private Boolean existRuleName(String ruleName, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{ProductRule::getId});
        lqw.eq(ProductRule::getRuleName, (Object)ruleName);
        lqw.eq(ProductRule::getMerId, (Object)merId);
        lqw.last(" limit 1");
        ProductRule productRule = (ProductRule)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)productRule);
    }

    @Override
    public Boolean updateRule(ProductRuleRequest ProductRuleRequest2) {
        if (ObjectUtil.isNull((Object)ProductRuleRequest2.getId())) {
            throw new CrmebException("\u8bf7\u5148\u9009\u62e9\u89c4\u683c");
        }
        ProductRule ProductRule2 = new ProductRule();
        BeanUtils.copyProperties((Object)ProductRuleRequest2, (Object)ProductRule2);
        return this.updateById(ProductRule2);
    }
}

