/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.order.OrderProfitSharing;
import com.zbkj.service.dao.OrderProfitSharingDao;
import com.zbkj.service.service.OrderProfitSharingService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrderProfitSharingServiceImpl
extends ServiceImpl<OrderProfitSharingDao, OrderProfitSharing>
implements OrderProfitSharingService {
    @Resource
    private OrderProfitSharingDao dao;

    @Override
    public OrderProfitSharing getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(OrderProfitSharing::getOrderNo, (Object)orderNo);
        lqw.last(" limit 1");
        return (OrderProfitSharing)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<OrderProfitSharing> findByDate(Integer merId, String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(OrderProfitSharing::getMerId, (Object)merId);
        }
        lqw.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<OrderProfitSharing> findByMonth(Integer merId, String month) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(OrderProfitSharing::getMerId, (Object)merId);
        }
        lqw.apply("date_format(create_time, '%Y-%m') = {0}", new Object[]{month});
        return this.dao.selectList((Wrapper)lqw);
    }
}

