/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.constants.WeChatConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.utils.WxUtil;
import com.zbkj.common.vo.wxvedioshop.ShopOrderAddResultVo;
import com.zbkj.common.vo.wxvedioshop.ShopOrderCommonVo;
import com.zbkj.common.vo.wxvedioshop.ShopOrderPayVo;
import com.zbkj.common.vo.wxvedioshop.ShopOrderVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderAddressInfoAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderDeliveryDetailAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderDetailAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderGetPaymentParamsRequestVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderGetPaymentParamsRersponseVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderPayInfoAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderPriceInfoVo;
import com.zbkj.service.service.WechatService;
import com.zbkj.service.service.WechatVideoOrderService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatVideoOrderServiceImpl
implements WechatVideoOrderService {
    private static final Logger logger = LoggerFactory.getLogger(WechatVideoOrderServiceImpl.class);
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private WechatService wechatService;

    @Override
    public Integer shopSceneCheck(Integer scene) {
        if (ObjectUtil.isNull((Object)scene)) {
            throw new CrmebException("\u573a\u666f\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_SCENE_CHECK_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("scene", scene);
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        return jsonObject.getInteger("is_matched");
    }

    @Override
    public ShopOrderAddResultVo shopOrderAdd(ShopOrderAddVo shopOrderAddVo) {
        shopOrderAddVo.setFund_type(Integer.valueOf(1));
        logger.info("001\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 - \u521b\u5efa\u8ba2\u5355 START shopOrderAddVo\uff1a" + JSON.toJSONString((Object)shopOrderAddVo));
        Map<String, Object> orderAddMap = this.assembleOrderAddMap(shopOrderAddVo);
        logger.info("001\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 - \u521b\u5efa\u8ba2\u5355 \u63d0\u4ea4\u7ed9\u5fae\u4fe1\u7684 orderAddMap\uff1a" + JSON.toJSONString(orderAddMap));
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_ORDER_ADD_URL, (Object[])new Object[]{miniAccessToken});
        String postStringData = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString(orderAddMap));
        JSONObject jsonObject = JSONObject.parseObject((String)postStringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopOrderAddResultVo resultVo = (ShopOrderAddResultVo)JSONObject.parseObject((String)jsonObject.getJSONObject("data").toJSONString(), ShopOrderAddResultVo.class);
        logger.info("001\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 - \u521b\u5efa\u8ba2\u5355 END resultVo\uff1a" + JSON.toJSONString((Object)resultVo));
        return resultVo;
    }

    @Override
    public ShopOrderGetPaymentParamsRersponseVo shopOrderGetPaymentParams(ShopOrderGetPaymentParamsRequestVo requestVo) {
        logger.info("002\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 - \u83b7\u53d6\u652f\u4ed8\u53c2\u6570 START shopOrderAddVo\uff1a" + JSON.toJSONString((Object)requestVo));
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_ORDER_PAYMENT_PARAMS_URL, (Object[])new Object[]{miniAccessToken});
        String postStringData = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString((Object)requestVo));
        JSONObject jsonObject = JSONObject.parseObject((String)postStringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopOrderGetPaymentParamsRersponseVo result = (ShopOrderGetPaymentParamsRersponseVo)JSONObject.parseObject((String)jsonObject.getJSONObject("payment_params").toJSONString(), ShopOrderGetPaymentParamsRersponseVo.class);
        logger.info("002\u5fae\u4fe1\u5c0f\u7a0b\u5e8f - \u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 - \u83b7\u53d6\u652f\u4ed8\u53c2\u6570 END resultVo\uff1a" + JSON.toJSONString((Object)result));
        return result;
    }

    private Map<String, Object> assembleOrderAddMap(ShopOrderAddVo shopOrderAddVo) {
        HashMap map = CollUtil.newHashMap();
        map.put("create_time", shopOrderAddVo.getCreateTime());
        map.put("out_order_id", shopOrderAddVo.getOutOrderId());
        map.put("openid", shopOrderAddVo.getOpenid());
        map.put("path", shopOrderAddVo.getPath());
        map.put("fund_type", shopOrderAddVo.getFund_type());
        map.put("expire_time", shopOrderAddVo.getExpire_time());
        ShopOrderDetailAddVo orderDetail = shopOrderAddVo.getOrderDetail();
        HashMap detailMap = CollUtil.newHashMap();
        List productInfos = orderDetail.getProductInfos();
        List proInfoMapList = productInfos.stream().map(productInfo -> {
            HashMap proInfoMap = CollUtil.newHashMap();
            proInfoMap.put("out_product_id", productInfo.getOutProductId());
            proInfoMap.put("out_sku_id", productInfo.getOutSkuId());
            proInfoMap.put("sku_real_price", productInfo.getSalePrice());
            proInfoMap.put("sale_price", productInfo.getSalePrice());
            proInfoMap.put("product_cnt", productInfo.getProductCnt());
            proInfoMap.put("head_img", productInfo.getHeadImg());
            proInfoMap.put("title", productInfo.getTitle());
            proInfoMap.put("path", productInfo.getPath());
            return proInfoMap;
        }).collect(Collectors.toList());
        detailMap.put("product_infos", proInfoMapList);
        ShopOrderPayInfoAddVo payInfo = orderDetail.getPayInfo();
        HashMap payInfoMap = CollUtil.newHashMap();
        payInfoMap.put("pay_method", payInfo.getPayMethod());
        payInfoMap.put("pay_method_type", payInfo.getPayMethodType());
        payInfoMap.put("prepay_id", payInfo.getPrepayId());
        payInfoMap.put("prepay_time", payInfo.getPrepayTime());
        detailMap.put("pay_info", payInfoMap);
        ShopOrderPriceInfoVo priceInfo = orderDetail.getPriceInfo();
        HashMap priceInfoMap = CollUtil.newHashMap();
        priceInfoMap.put("order_price", priceInfo.getOrderPrice());
        priceInfoMap.put("freight", priceInfo.getFreight());
        if (ObjectUtil.isNotNull((Object)priceInfo.getDiscountedPrice()) && priceInfo.getDiscountedPrice() > 0L) {
            priceInfoMap.put("discounted_price", priceInfo.getDiscountedPrice());
        }
        detailMap.put("price_info", priceInfoMap);
        map.put("order_detail", detailMap);
        ShopOrderDeliveryDetailAddVo deliveryDetail = shopOrderAddVo.getDeliveryDetail();
        HashMap deliveryMap = CollUtil.newHashMap();
        deliveryMap.put("delivery_type", deliveryDetail.getDeliveryType());
        map.put("delivery_detail", deliveryMap);
        ShopOrderAddressInfoAddVo addressInfo = shopOrderAddVo.getAddressInfo();
        HashMap addressMap = CollUtil.newHashMap();
        addressMap.put("receiver_name", addressInfo.getReceiverName());
        addressMap.put("detailed_address", addressInfo.getDetailedAddress());
        addressMap.put("tel_number", addressInfo.getTelNumber());
        map.put("address_info", addressMap);
        return map;
    }

    @Override
    public Boolean shopOrderPay(ShopOrderPayVo shopOrderPayVo) {
        logger.info("\u5c0f\u7a0b\u5e8f \u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 --\u300b \u540c\u6b65\u8ba2\u5355\u5f00\u59cb:" + JSON.toJSONString((Object)shopOrderPayVo));
        if (ObjectUtil.isNull((Object)shopOrderPayVo.getOrderId()) && StrUtil.isBlank((CharSequence)shopOrderPayVo.getOutOrderId())) {
            throw new CrmebException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> payMap = this.assembleOrderPayMap(shopOrderPayVo);
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_ORDER_PAY_URL, (Object[])new Object[]{miniAccessToken});
        String postStringData = this.restTemplateUtil.postStringData(url, JSONObject.toJSONString(payMap));
        JSONObject jsonObject = JSONObject.parseObject((String)postStringData);
        WxUtil.checkResult((JSONObject)jsonObject);
        logger.info("\u5c0f\u7a0b\u5e8f \u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 --\u300b \u540c\u6b65\u8ba2\u5355\u7ed3\u675f:" + postStringData);
        return Boolean.TRUE;
    }

    private Map<String, Object> assembleOrderPayMap(ShopOrderPayVo shopOrderPayVo) {
        HashMap map = CollUtil.newHashMap();
        if (ObjectUtil.isNotNull((Object)shopOrderPayVo.getOrderId())) {
            map.put("order_id", shopOrderPayVo.getOrderId());
        }
        if (StrUtil.isNotBlank((CharSequence)shopOrderPayVo.getOutOrderId())) {
            map.put("out_order_id", shopOrderPayVo.getOutOrderId());
        }
        map.put("openid", shopOrderPayVo.getOpenid());
        map.put("action_type", shopOrderPayVo.getActionType());
        if (StrUtil.isNotBlank((CharSequence)shopOrderPayVo.getActionRemark())) {
            map.put("action_remark", shopOrderPayVo.getActionRemark());
        }
        if (shopOrderPayVo.getActionType().equals(1)) {
            map.put("transaction_id", shopOrderPayVo.getTransactionId());
            map.put("pay_time", shopOrderPayVo.getPayTime());
        }
        return map;
    }

    @Override
    public ShopOrderVo shopOrderGet(ShopOrderCommonVo shopOrderCommonVo) {
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 - \u83b7\u53d6\u8ba2\u5355\u8be6\u60c5:shopOrderCommonVo:" + JSON.toJSONString((Object)shopOrderCommonVo));
        if (ObjectUtil.isNull((Object)shopOrderCommonVo.getOrderId()) && StrUtil.isBlank((CharSequence)shopOrderCommonVo.getOutOrderId())) {
            throw new CrmebException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String miniAccessToken = this.wechatService.getMiniAccessToken();
        String url = StrUtil.format((CharSequence)WeChatConstants.WECHAT_SHOP_ORDER_GET_URL, (Object[])new Object[]{miniAccessToken});
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ObjectUtil.isNotNull((Object)shopOrderCommonVo.getOrderId())) {
            map.put("order_id", shopOrderCommonVo.getOrderId());
        }
        if (StrUtil.isNotBlank((CharSequence)shopOrderCommonVo.getOutOrderId())) {
            map.put("out_order_id", shopOrderCommonVo.getOutOrderId());
        }
        map.put("openid", shopOrderCommonVo.getOpenid());
        String mapData = this.restTemplateUtil.postMapData(url, map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapData);
        WxUtil.checkResult((JSONObject)jsonObject);
        ShopOrderVo shopOrderVo = (ShopOrderVo)JSONObject.parseObject((String)jsonObject.getJSONObject("order").toJSONString(), ShopOrderVo.class);
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 - \u83b7\u53d6\u8ba2\u5355\u8be6\u60c5:shopOrderVo:" + JSON.toJSONString((Object)shopOrderVo));
        return shopOrderVo;
    }
}

