package com.zbkj.front.controller.bcx;

import com.zbkj.front.controller.bcx.requests.ReplenishPaymentRequest;
import com.zbkj.service.payments.WalletPaymentService;
import com.zbkj.service.payments.commands.ReplenishOrderPlatformFeeCommand;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("api/front/replenish")
@Api(tags = "补充支付及订单的相关功能")
public class ReplenishPaymentController {

    private final WalletPaymentService walletPaymentService;

    public ReplenishPaymentController(WalletPaymentService walletPaymentService) {
        this.walletPaymentService = walletPaymentService;
    }

    @ApiOperation(value = "补充支付")
    @RequestMapping(value = "/payment/do-execute", method = RequestMethod.POST)
    public void doExecute(@RequestBody @Validated ReplenishPaymentRequest request) {
        this.walletPaymentService.dispatch(
                ReplenishOrderPlatformFeeCommand.create(
                        request.getIds()
                ));
    }
}
