package com.zbkj.front.controller.bcx;

import com.zbkj.common.model.bcx.BcxOrderFapiao;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxOrderFapiaoRequest;
import com.zbkj.common.response.bcx.BcxOrderFapiaoResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.bcx.BcxOrderFapiaoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 用户订单发票申请单 控制层
 */
@Slf4j
@Api(tags = "用户订单发票申请单 控制器")
@RestController
@RequestMapping("/api/front/order/fapiao")
public class BcxOrderFapiaoController {

    @Autowired
    private BcxOrderFapiaoService bcxOrderFapiaoService;


    @ApiOperation("查询单条订单发票申请单")
    @RequestMapping(value = "/info/{id}", method = RequestMethod.GET)
    public CommonResult<BcxOrderFapiaoResponse> queryById(@PathVariable Integer id) {
        return CommonResult.success(bcxOrderFapiaoService.queryById(id));
    }

    @ApiOperation("查询分页订单发票申请单")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxOrderFapiaoResponse>> queryPagedList(@RequestParam(required = false) String orderNo,
                                                                           @Validated PageParamRequest pageParamRequest) {
        return CommonResult.success(CommonPage.restPage(bcxOrderFapiaoService.queryPagedList(orderNo, pageParamRequest)));
    }

    @ApiOperation("新增订单发票申请单")
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public CommonResult<BcxOrderFapiao> create(@RequestBody @Validated BcxOrderFapiaoRequest request) {
        return CommonResult.success(bcxOrderFapiaoService.create(request));
    }

    @ApiOperation("修改订单发票申请单")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public CommonResult<BcxOrderFapiao> update(@RequestBody @Validated BcxOrderFapiaoRequest bcxOrderFapiao) {
        if (bcxOrderFapiaoService.update(bcxOrderFapiao)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation("删除订单发票申请单")
    @RequestMapping(value = "/delete/{id}", method = RequestMethod.POST)
    public CommonResult<String> delete(@PathVariable Integer id) {
        if (bcxOrderFapiaoService.delete(id)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }
}
