package com.zbkj.front.controller.bcx;

import com.zbkj.common.model.bcx.BcxFapiaoTitle;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxFapiaoTitleRequest;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.bcx.BcxFapiaoTitleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 发票抬头表 控制层
 */
@Slf4j
@Api(tags = "用户 发票抬头 控制器")
@RestController
@RequestMapping("/api/front/fapiao/title")
public class BcxFapiaoTitleController {

    @Autowired
    private BcxFapiaoTitleService bcxFapiaoTitleService;


    @ApiOperation("查询单条发票抬头表")
    @RequestMapping(value = "/info/{id}", method = RequestMethod.GET)
    public CommonResult<BcxFapiaoTitle> queryById(@PathVariable Integer id){
        return CommonResult.success(bcxFapiaoTitleService.queryById(id));
    }

    @ApiOperation("查询分页发票抬头表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxFapiaoTitle>> queryPagedList(@Validated PageParamRequest pageParamRequest){
        return CommonResult.success(CommonPage.restPage(bcxFapiaoTitleService.queryPagedList(pageParamRequest)));
    }

    @ApiOperation("新增发票抬头表")
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public CommonResult<BcxFapiaoTitle> create(@RequestBody @Validated BcxFapiaoTitleRequest bcxFapiaoTitle){
        if(bcxFapiaoTitleService.create(bcxFapiaoTitle)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation("修改发票抬头表")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public CommonResult<BcxFapiaoTitle> update(@RequestBody @Validated BcxFapiaoTitleRequest bcxFapiaoTitle){
        if (bcxFapiaoTitleService.update(bcxFapiaoTitle)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation("删除发票抬头表")
    @RequestMapping(value = "/delete/{id}", method = RequestMethod.POST)
    public CommonResult<String> delete(@PathVariable Integer id) {
        if (bcxFapiaoTitleService.delete(id)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }
}
