package com.zbkj.front.controller;

import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxSettleSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxSettleDetailResponse;
import com.zbkj.common.response.BcxSettleResponse;
import com.zbkj.common.response.BcxSettleStatisticsResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxSettleService;
import com.zbkj.service.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;

/**
 * description：分销系统-用户-结算单 控制层
 * author：linchunpeng
 * date：2024/5/15
 */
@Slf4j
@Api(tags = "分销系统-用户结算单控制层")
@RestController
@RequestMapping("/api/front/user/settle")
public class UserSettleController {
    
    @Autowired
    private BcxSettleService bcxSettleService;
    @Autowired
    private UserService userService;


    @ApiOperation(value = "结算单统计(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/statistics", method = RequestMethod.GET)
    public CommonResult<BcxSettleStatisticsResponse> statistics(@Validated BcxSettleSearchRequest searchRequest) throws ParseException {
        searchRequest.setUserId(userService.getUserId());
        searchRequest.setSearchType(6);
        return CommonResult.success(bcxSettleService.statistics(searchRequest));
    }

    @ApiOperation(value = "结算单统计(分销商端查看员工的时候，调用这个接口)")
    @RequestMapping(value = "/fxy/statistics", method = RequestMethod.GET)
    public CommonResult<BcxSettleStatisticsResponse> fxyStatistics(@Validated BcxSettleSearchRequest searchRequest) throws ParseException {
        searchRequest.setSpreadUid(userService.getUserId());
        searchRequest.setSearchType(5);
        return CommonResult.success(bcxSettleService.statistics(searchRequest));
    }

    @ApiOperation(value = "结算单(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleResponse>> getList(@Validated BcxSettleSearchRequest searchRequest,
                                                               @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setUserId(userService.getUserId());
        searchRequest.setSearchType(6);
        return CommonResult.success(CommonPage.restPage(bcxSettleService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "分销员结算单(分销商端查看员工的时候，调用这个接口)")
    @RequestMapping(value = "/fxy/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleResponse>> getFxyList(@Validated BcxSettleSearchRequest searchRequest,
                                                                      @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSpreadUid(userService.getUserId());
        searchRequest.setSearchType(5);
        return CommonResult.success(CommonPage.restPage(bcxSettleService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "结算单详情(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/detail/{id}", method = RequestMethod.GET)
    public CommonResult<BcxSettleDetailResponse> detail(@PathVariable(name = "id") Long id)  {
        return CommonResult.success(bcxSettleService.findId(id));
    }
}