package com.zbkj.front.controller;

import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxSettleBillSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxSettleBillDetailResponse;
import com.zbkj.common.response.BcxSettleBillResponse;
import com.zbkj.common.response.BcxSettleBillStatisticsResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxSettleBillService;
import com.zbkj.service.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;

/**
 * description: 分销系统-用户-业绩账单表 控制层
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Api(tags = "分销系统-用户业绩账单表控制层")
@RestController
@RequestMapping("/api/front/user/settle/bill")
public class UserSettleBillController {
    
    @Autowired
    private BcxSettleBillService bcxSettleBillService;
    @Autowired
    private UserService userService;


    @ApiOperation(value = "业绩账单统计(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/statistics", method = RequestMethod.GET)
    public CommonResult<BcxSettleBillStatisticsResponse> statistics(@Validated BcxSettleBillSearchRequest searchRequest) throws ParseException {
        searchRequest.setUserId(userService.getUserId());
        searchRequest.setSearchType(6);
        return CommonResult.success(bcxSettleBillService.statistics(searchRequest));
    }

    @ApiOperation(value = "业绩账单统计(分销商端查看员工的时候，调用这个接口)")
    @RequestMapping(value = "/fxy/statistics", method = RequestMethod.GET)
    public CommonResult<BcxSettleBillStatisticsResponse> fxyStatistics(@Validated BcxSettleBillSearchRequest searchRequest) throws ParseException {
        searchRequest.setSpreadUid(userService.getUserId());
        searchRequest.setSearchType(5);
        return CommonResult.success(bcxSettleBillService.statistics(searchRequest));
    }

    @ApiOperation(value = "业绩账单(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleBillResponse>> getList(@Validated BcxSettleBillSearchRequest searchRequest,
                                                                      @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setUserId(userService.getUserId());
        searchRequest.setSearchType(6);
        return CommonResult.success(CommonPage.restPage(bcxSettleBillService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "分销员业绩账单(分销商端查看员工的时候，调用这个接口)")
    @RequestMapping(value = "/fxy/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxSettleBillResponse>> getFxyList(@Validated BcxSettleBillSearchRequest searchRequest,
                                                                      @Validated PageParamRequest pageParamRequest) throws ParseException {
        searchRequest.setSpreadUid(userService.getUserId());
        searchRequest.setSearchType(5);
        return CommonResult.success(CommonPage.restPage(bcxSettleBillService.getPage(searchRequest, pageParamRequest)));
    }

    @ApiOperation(value = "业绩账单详情(渠道端、分销商端、分销员端，调用这个接口)")
    @RequestMapping(value = "/detail/{id}", method = RequestMethod.GET)
    public CommonResult<BcxSettleBillDetailResponse> detail(@PathVariable(name = "id") Long id)  {
        return CommonResult.success(bcxSettleBillService.findId(id));
    }
}