package com.zbkj.front.controller;


import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserProductBenefitsRequest;
import com.zbkj.common.request.UserProductBenefitsSaveRequest;
import com.zbkj.common.response.UserProductBenefitsResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.front.service.FrontProductService;
import com.zbkj.service.service.BcxProductBenefitsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * PC商品控制器
 */
@Slf4j
@RestController
@RequestMapping("api/front/product/benefits")
@Api(tags = "分销系统-分销商品配置")
public class UserProductBenefitsController {

    @Autowired
    private FrontProductService productService;
    @Autowired
    private BcxProductBenefitsService bcxProductBenefitsService;

    @ApiOperation(value = "分销商品-分页列表")
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public CommonResult<CommonPage<UserProductBenefitsResponse>> getPage(@Validated UserProductBenefitsRequest request,
                                                                         @Validated PageParamRequest pageRequest) {
        return CommonResult.success(CommonPage.restPage(bcxProductBenefitsService.getPage(request, pageRequest)));
    }

    @ApiOperation(value = "分佣配置保存")
    @RequestMapping(value = "/config/save", method = RequestMethod.POST)
    public CommonResult<Object> saveConfig(@RequestBody @Validated UserProductBenefitsSaveRequest request) {
        return CommonResult.success(bcxProductBenefitsService.saveConfig(request));
    }
}



