package com.zbkj.front.controller;


import cn.hutool.http.HttpUtil;
import com.zbkj.common.dto.HuifuWalletTradeDto;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.result.CommonResult;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.factory.PaymentFactory;
import com.zbkj.service.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 开发数据控制器
 */
@Slf4j
@RestController
@RequestMapping("api/dev/data")
@Api(tags = "开发数据控制器")
public class DevDataController {

    @Resource
    private AsyncService asyncService;
    @Resource
    private OrderService orderService;
    @Resource
    private PayService payService;
    @Autowired
    private PaymentFactory paymentFactory;
    @Autowired
    private CommonWalletService commonWalletService;
    @Autowired
    TaskResidualService taskResidualService;

    @ApiOperation(value = "订单拆单")
    @RequestMapping(value = "/order/split", method = RequestMethod.GET)
    public CommonResult<String> splitOrder(@RequestParam(value = "orderNo") String orderNo, @RequestParam(value = "sign") String sign) {
        Order order = orderService.getByOrderNo(orderNo);
        if (sign.equals("3qvrN4DBKk0SF0YJAzyOntJiL_uDTFEYYhWmrjZoxzo")) {
            if (order.getPaid() && !order.getIsDel()) {
                asyncService.orderPaySuccessSplit(orderNo);
                return CommonResult.success("完成");
            }
            return CommonResult.success("y");
        }
        return CommonResult.success("x");
    }

    @ApiOperation(value = "测试收支明细")
    @RequestMapping(value = "/order/voucher", method = RequestMethod.GET)
    public CommonResult<String> voucher(@RequestParam(value = "hfReqNo") String hfReqNo,@RequestParam(value = "wallNo") String wallNo,@RequestParam(value = "payChannel") String payChannel, @RequestParam(value = "sign") String sign) throws CrmebWalletException {
        if (sign.equals("3qvrN4DBKk0SF0YJAzyOntJiL_uDTFEYYhWmrjZoxzo")) {
            HuifuWalletTradeDto dto = new HuifuWalletTradeDto();
            dto.setExpendAccountNo(wallNo);
            dto.setTradeFlowNo(hfReqNo);
            paymentFactory.getPaymentChannel(payChannel).getHuifuAccountTradeVoucher(dto);
            return CommonResult.success("Y");
        }
        return CommonResult.success("x");
    }

    @ApiOperation(value = "测试对账单")
    @RequestMapping(value = "/order/zd", method = RequestMethod.GET)
    public CommonResult<String> zd(@RequestParam(value = "days") String days, @RequestParam(value = "sign") String sign) {
        if (sign.equals("3qvrN4DBKk0SF0YJAzyOntJiL_uDTFEYYhWmrjZoxzo")) {
            String[] arr = days.split(",");
            for (String day:arr) {
                commonWalletService.reconciliationReplay(day);
            }
            return CommonResult.success("y");
        }
        return CommonResult.success("x");
    }

    @ApiOperation(value = "旧冻结数据修复")
    @RequestMapping(value = "/order/payLock", method = RequestMethod.GET)
    public CommonResult<String> payLock(@RequestParam(value = "orderNo") String orderNo, @RequestParam(value = "sign") String sign) {
        if (sign.equals("3qvrN4DBKk0SF0YJAzyOntJiL_uDTFEYYhWmrjZoxzo")) {
            payService.allOrder(orderNo);
            return CommonResult.success("y");
        }
        return CommonResult.success("x");
    }

    @ApiOperation(value = "定时交易任务手动触发")
    @RequestMapping(value = "/pay/payTask", method = RequestMethod.GET)
    public CommonResult<String> payTask(@RequestParam(value = "sign") String sign) {
        if (sign.equals("3qvrN4DBKk0SF0YJAzyOntJiL_uDTFEYYhWmrjZoxzo")) {
            taskResidualService.disposeTaskResidualList("0");
            return CommonResult.success("y");
        }
        return CommonResult.success("x");
    }

    public static void main(String[] args) {
        //2024-03-15
        for (int i = 1; i < 17; i++) {
            String day = DateUtils.formatDate(DateUtils.addDays(DateUtils.parseDate("2024-09-30"),i),"yyyy-MM-dd");
            System.out.println(day);
            HttpUtil.get("https://pay.mall.baibaodun.cn/api/dev/data/order/updateBalance?day0="+day+"&day1="+day+"&sign=3qvrN4DBKk0SF0YJAzyOntJiL_uDTFEYYhWmrjZoxzo");
        }
        /*String[] arr = {"20250120","20250121","20250122","20250123","20250124","20250125","20250126","20250127","20250128","20250129","20250130","20250131","20250201"};
        for (String str : arr){
            new Thread(()-> {
                HttpUtil.get("https://pay.mall.baibaodun.cn/api/dev/data/order/zd?days="+str+"&sign=3qvrN4DBKk0SF0YJAzyOntJiL_uDTFEYYhWmrjZoxzo");
            }).start();
        }*/
         /*String rr = "('SH975170019367054513621')";
         String[] nos = rr.replace("(","").replace(")","").replace("'","").split(",");
        for (String str:nos) {
            HttpUtil.get("https://shop.mall.baibaodun.cn/api/dev/data/order/payLock?sign=3qvrN4DBKk0SF0YJAzyOntJiL_uDTFEYYhWmrjZoxzo&orderNo="+str);
            System.out.println("over...");
        }*/
    }

    @ApiOperation(value = "交易详情根据日期补对应交易后余额")
    @RequestMapping(value = "/order/updateBalance", method = RequestMethod.GET)
    public CommonResult<String> updateBalance(@RequestParam(value = "day0") String day0, @RequestParam(value = "day1") String day1,@RequestParam(value = "payChannel") String payChannel, @RequestParam(value = "sign") String sign) throws CrmebWalletException {
        if (sign.equals("3qvrN4DBKk0SF0YJAzyOntJiL_uDTFEYYhWmrjZoxzo")) {
            paymentFactory.getPaymentChannel(payChannel).updateBalance(day0,day1);
            return CommonResult.success("Y");
        }
        return CommonResult.success("x");
    }
}



