/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import com.zbkj.common.utils.WXPayXmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;

public class XmlUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> xmlToMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        ServletInputStream in = null;
        try {
            in = request.getInputStream();
            Document doc = reader.read((InputStream)in);
            org.dom4j.Element root = doc.getRootElement();
            List list = root.elements();
            for (org.dom4j.Element element : list) {
                map.put(element.getName(), element.getText());
            }
        }
        catch (IOException | DocumentException e) {
            e.printStackTrace();
        }
        finally {
            try {
                assert (in != null);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static HashMap<String, Object> xmlToMap(String strxml) throws Exception {
        strxml = strxml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"");
        HashMap<String, Object> map = new HashMap<String, Object>();
        SAXReader reader = new SAXReader();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strxml.getBytes(StandardCharsets.UTF_8));
        if (StringUtils.isBlank((CharSequence)strxml)) {
            return null;
        }
        Document document = reader.read((InputStream)inputStream);
        org.dom4j.Element root = document.getRootElement();
        List list = root.elements();
        for (org.dom4j.Element e : list) {
            map.put(e.getName(), e.getText());
        }
        ((InputStream)inputStream).close();
        return map;
    }

    public static String objectToXml(Object object) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new Xpp3Driver((NameCoder)new NoNameCoder()));
        xstream.alias("xml", object.getClass());
        return xstream.toXML(object);
    }

    public static String mapToXml(Map<String, String> data) throws Exception {
        org.w3c.dom.Document document = WXPayXmlUtil.newDocument();
        Element root = document.createElement("xml");
        document.appendChild(root);
        for (String key : data.keySet()) {
            String value = data.get(key);
            if (value == null) {
                value = "";
            }
            value = value.trim();
            Element filed = document.createElement(key);
            filed.appendChild(document.createTextNode(value));
            root.appendChild(filed);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        String output = writer.getBuffer().toString();
        writer.close();
        return output;
    }
}

