/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.SysRoleService;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.spring.cache.BaseUtils;
import com.bcxin.ins.spring.cache.CacheUtils;
import com.bcxin.ins.spring.security.Principal;
import com.bcxin.ins.util.CookieUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SysLoginController
extends BaseController {
    private static final String ADMIN_LOGIN = SysLoginController.getViewPath((String)"admin/login/admin_login");
    private static final String ADMIN_MAIN = SysLoginController.getViewPath((String)"admin/main/main");
    private static final String ERROR = SysLoginController.getViewPath((String)"common/error");
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysRoleService sysRoleService;

    @RequestMapping(value={"${systemPath}/error/{code}"}, method={RequestMethod.GET})
    public String error(@PathVariable String code, HttpServletRequest request, HttpServletResponse response, Model model) {
        String msg = "\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        if ("10011".equals(code)) {
            msg = "\u8b66\u544a\uff01\uff01\u8bf7\u6c42\u5185\u5bb9\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26\u3002";
        }
        model.addAttribute("prompt", (Object)msg);
        return ERROR;
    }

    @RequestMapping(value={"${systemPath}/login"}, method={RequestMethod.GET})
    public String login(HttpServletRequest request, HttpServletResponse response, Model model) {
        return this.login(response, model);
    }

    public String login(HttpServletResponse response, Model model) {
        Principal principal = SysUserUtils.getPrincipal();
        if (principal != null) {
            return this.redirectTo("/admin/index");
        }
        if ("true".equals(GlobalConstants.getConfig((String)"notAllowRefreshIndex"))) {
            CookieUtils.setCookie((HttpServletResponse)response, (String)"LOGINED", (String)"false");
        }
        return ADMIN_LOGIN;
    }

    @RequestMapping(value={"/bcxin/ajaxlogin"})
    public void Apilogin(String data, HttpServletRequest request, HttpServletResponse response) {
        this.sysUserService.ajaxLoginValidate(data, this.getParameter("sessionId"), response);
    }

    @RequestMapping(value={"${systemPath}/removeCache"}, method={RequestMethod.GET})
    public String removeCache() {
        CacheUtils.removeAll((String)"sysCache");
        BaseUtils.removeCache((String)"menuList");
        return this.redirectTo("/admin/index");
    }

    @RequestMapping(value={"${systemPath}/logout"}, method={RequestMethod.GET})
    public String logout() {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        SysUserUtils.getUser();
        return this.redirectTo(ADMIN_LOGIN);
    }

    @RequestMapping(value={"/bcxin/logout"})
    public void apilogout() {
        Subject subject = SecurityUtils.getSubject();
        if (subject == null) {
            subject.logout();
        }
        HashMap map = Maps.newHashMap();
        map.put("status", "200");
        map.put("message", "\u64cd\u4f5c\u6210\u529f");
        MessageUtils.returnMessage((String)MessageUtils.packageMap((Map)map), (HttpServletResponse)this.response);
    }

    @RequestMapping(value={"${systemPath}/login"}, method={RequestMethod.POST})
    public String loginFail(HttpServletRequest request, HttpServletResponse response, Model model) {
        if (this.sysUserService.loginValidatePost(request, model)) {
            return this.redirectTo("${systemPath}/index");
        }
        return ADMIN_LOGIN;
    }
}

