/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.ueditor.util.upload;

import com.bcxin.ins.models.ueditor.util.Num62;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class UploadUtils {
    protected static final Pattern ILLEGAL_CURRENT_FOLDER_PATTERN = Pattern.compile("^[^/]|[^/]$|/\\.{1,2}|\\\\|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}");

    public static String generateFilename(String path, String ext) {
        SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("/yyyyMM/ddHHmmss");
        return path + MONTH_FORMAT.format(new Date()) + RandomStringUtils.random((int)4, (char[])Num62.N36_CHARS) + "." + ext;
    }

    public static String generateFilename(String ext) {
        SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("/yyyyMM/ddHHmmss");
        return MONTH_FORMAT.format(new Date()) + RandomStringUtils.random((int)4, (char[])Num62.N36_CHARS) + "." + ext;
    }

    public static String generateMonthname() {
        SimpleDateFormat YEAR_MONTH_FORMAT = new SimpleDateFormat("yyyyMM");
        return YEAR_MONTH_FORMAT.format(new Date());
    }

    public static String generateByFilename(String path, String fileName, String ext) {
        return path + fileName + "." + ext;
    }

    public static String sanitizeFileName(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return filename;
        }
        String name = UploadUtils.forceSingleExtension(filename);
        return name.replaceAll("\\\\|/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
    }

    public static String sanitizeFolderName(String folderName) {
        if (StringUtils.isBlank((CharSequence)folderName)) {
            return folderName;
        }
        return folderName.replaceAll("\\.|\\\\|/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
    }

    public static boolean isValidPath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return false;
        }
        return !ILLEGAL_CURRENT_FOLDER_PATTERN.matcher(path).find();
    }

    public static String forceSingleExtension(String filename) {
        return filename.replaceAll("\\.(?![^.]+$)", "_");
    }

    public static boolean isSingleExtension(String filename) {
        return filename.matches("[^\\.]+\\.[^\\.]+");
    }

    public static void checkDirAndCreate(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static File getUniqueFile(File file) {
        if (!file.exists()) {
            return file;
        }
        File tmpFile = new File(file.getAbsolutePath());
        File parentDir = tmpFile.getParentFile();
        int count = 1;
        String extension = FilenameUtils.getExtension((String)tmpFile.getName());
        String baseName = FilenameUtils.getBaseName((String)tmpFile.getName());
        while ((tmpFile = new File(parentDir, baseName + "(" + count++ + ")." + extension)).exists()) {
        }
        return tmpFile;
    }

    public static void main(String[] args) {
        System.out.println(UploadUtils.generateFilename("/base", "gif"));
    }
}

