/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.models.order.policy.dao.InsRoleInpolicyDao;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.models.order.policy.service.InsRoleFavoreeService;
import com.bcxin.ins.models.order.policy.service.InsRoleInpolicyService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsRoleInpolicyServiceImpl
extends ServiceImpl<InsRoleInpolicyDao, InsRoleInpolicy>
implements InsRoleInpolicyService {
    @Autowired
    private InsRoleInpolicyDao dao;
    @Autowired
    private InsRoleFavoreeService insRoleFavoreeService;
    @Autowired
    private InsInsuranceSlipService insInsuranceSlipgService;

    @Override
    public List<InsRoleInpolicy> selectInsRoleInpolicyByInsInsuranceSlip(Long oid) {
        List<InsRoleInpolicy> roles = this.dao.selectInsRoleInpolicyByInsInsuranceSlip(oid);
        ArrayList<InsRoleInpolicy> nroles = new ArrayList<InsRoleInpolicy>();
        for (InsRoleInpolicy iri : roles) {
            nroles.add(this.packagingInsRoleInpolicy(iri.getIns_role_inpolicy_id()));
        }
        return nroles;
    }

    @Override
    public InsRoleInpolicy packagingInsRoleInpolicy(Long oid) {
        InsRoleInpolicy insRoleInpolicy = this.dao.selectById(oid);
        if (insRoleInpolicy != null) {
            insRoleInpolicy.setInsRoleFavoreeList(this.insRoleFavoreeService.selectInsRoleFavoreeByInsRoleInpolicy(insRoleInpolicy.getIns_role_inpolicy_id()));
        }
        return insRoleInpolicy;
    }

    @Override
    public List<InsRoleInpolicy> initInsRoleInpolicy(InsInsuranceSlip insInsuranceSlip, String roleType, String kind) {
        ArrayList<InsRoleInpolicy> roleLost = new ArrayList<InsRoleInpolicy>();
        InsRoleInpolicy insRoleInpolicy = new InsRoleInpolicy();
        if ("3".equals(kind)) {
            insRoleInpolicy.setKind("1");
            this.createRole(insRoleInpolicy, insInsuranceSlip, roleType);
            roleLost.add(insRoleInpolicy);
            insRoleInpolicy = new InsRoleInpolicy();
            insRoleInpolicy.setKind("2");
            this.createRole(insRoleInpolicy, insInsuranceSlip, roleType);
            roleLost.add(insRoleInpolicy);
        } else {
            insRoleInpolicy.setKind(kind);
            this.createRole(insRoleInpolicy, insInsuranceSlip, roleType);
            roleLost.add(insRoleInpolicy);
        }
        return roleLost;
    }

    @Override
    public void createRole(InsRoleInpolicy insRoleInpolicy, InsInsuranceSlip insInsuranceSlip, String roleType) {
        insRoleInpolicy.setRole_type(roleType);
        insRoleInpolicy.getInsurance_slip().setIns_insurance_slip_id(insInsuranceSlip.getIns_insurance_slip_id());
        this.dao.insert(insRoleInpolicy);
    }

    @Override
    public void setRoleInPolicyByRoleCompanyVo(List<RoleSubjectVo> voList, Long policyID) {
        if (voList == null || voList.size() <= ConstProp.INT_NUMBER_ZERO) {
            return;
        }
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipgService.packagingInsInsuranceSlip(policyID);
        for (RoleSubjectVo vo : voList) {
            this.accordingToTheRoleSubjectVoSetUpInsRoleInpolicy(vo, insInsuranceSlip);
        }
    }

    @Override
    public void accordingToTheRoleSubjectVoSetUpInsRoleInpolicy(RoleSubjectVo vo, InsInsuranceSlip insInsuranceSlip) {
        InsRoleInpolicy insRoleInpolicy = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            if ("3".equals(vo.getKind())) {
                List<InsRoleInpolicy> roleList = this.selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
                for (InsRoleInpolicy role : roleList) {
                    this.updateRole(vo, role);
                }
            } else {
                insRoleInpolicy = this.packagingInsRoleInpolicy(Long.parseLong(vo.getOid()));
                this.updateRole(vo, insRoleInpolicy);
            }
        } else {
            List<InsRoleInpolicy> roleList = this.initInsRoleInpolicy(insInsuranceSlip, vo.getRole_type(), vo.getKind());
            for (InsRoleInpolicy role : roleList) {
                this.updateRole(vo, role);
            }
        }
    }

    private void updateRole(RoleSubjectVo vo, InsRoleInpolicy insRoleInpolicy) {
        insRoleInpolicy.setName_cn(vo.getName_cn());
        insRoleInpolicy.setName_en(vo.getName_en());
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insRoleInpolicy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        insRoleInpolicy.setApp_business_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_business_path()) ? vo.getApp_business_path() : "0");
        insRoleInpolicy.setApp_address_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_address_path()) ? vo.getApp_address_path() : "0");
        insRoleInpolicy.setApp_idcard_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_idcard_path()) ? vo.getApp_idcard_path() : "0");
        insRoleInpolicy.setApp_organizing_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_organizing_path()) ? vo.getApp_organizing_path() : "0");
        insRoleInpolicy.setApp_spouse_card_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_spouse_card_path()) ? vo.getApp_spouse_card_path() : "0");
        insRoleInpolicy.setApp_tax_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_tax_path()) ? vo.getApp_tax_path() : "0");
        insRoleInpolicy.setApp_trauschein_path(StringUtils.isNotEmpty((CharSequence)vo.getApp_trauschein_path()) ? vo.getApp_trauschein_path() : "0");
    }

    @Override
    public List<RoleSubjectVo> getRoleSubjectVoListByPolicyID(Long policyID) {
        List<RoleSubjectVo> voList = this.dao.selectRoleSubjectVoByInsInsuranceSlip(policyID);
        return voList;
    }

    @Override
    public RoleSubjectVo accordingToInsRoleInpolicyIntoRoleSubjectVo(InsRoleInpolicy role) {
        RoleSubjectVo vo = new RoleSubjectVo();
        vo.setName_cn(role.getName_cn());
        vo.setName_en(role.getName_en());
        vo.setOid(String.valueOf(role.getIns_role_inpolicy_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)role), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setApp_address_path("0".equals(role.getApp_address_path()) ? "" : role.getApp_address_path());
        vo.setApp_business_path("0".equals(role.getApp_business_path()) ? "" : role.getApp_business_path());
        vo.setApp_idcard_path("0".equals(role.getApp_idcard_path()) ? "" : role.getApp_idcard_path());
        vo.setApp_organizing_path("0".equals(role.getApp_organizing_path()) ? "" : role.getApp_organizing_path());
        vo.setApp_spouse_card_path("0".equals(role.getApp_spouse_card_path()) ? "" : role.getApp_spouse_card_path());
        vo.setApp_tax_path("0".equals(role.getApp_tax_path()) ? "" : role.getApp_tax_path());
        vo.setApp_trauschein_path("0".equals(role.getApp_trauschein_path()) ? "" : role.getApp_trauschein_path());
        return vo;
    }

    @Override
    public List<InsRoleInpolicy> getInsRoleInpolicyListByIDAndKind(Long oid, String kind) {
        HashMap columnMap = Maps.newHashMap();
        columnMap.put("insurance_slip_id", oid);
        columnMap.put("kind", kind);
        List roleList = this.dao.selectByMap(columnMap);
        return roleList;
    }
}

