/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsUnderwrite;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.tpost.TposRiskDuty;
import com.bcxin.ins.models.data.service.InsAreaService;
import com.bcxin.ins.models.data.service.InsRiskLevelService;
import com.bcxin.ins.models.order.policy.dao.InsRiskDutyDao;
import com.bcxin.ins.models.order.policy.service.InsRiskDutyService;
import com.bcxin.ins.models.order.policy.service.InsUnderwriteService;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.RiskDutyVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsRiskDutyServiceImpl
extends ServiceImpl<InsRiskDutyDao, TposRiskDuty>
implements InsRiskDutyService {
    @Autowired
    private InsRiskDutyDao dao;
    @Autowired
    private InsAreaService insAreaService;
    @Autowired
    private InsRiskLevelService insRiskLevelService;
    @Autowired
    private InsProductService insProductService;
    @Autowired
    private InsUnderwriteService insUnderwriteService;

    @Override
    public List<TposRiskDuty> selectInsRiskDutyByInsUnderwrite(Long oid) {
        return this.dao.selectInsRiskDutyByInsUnderwrite(oid);
    }

    @Override
    public List<TposRiskDuty> findAllList() {
        return this.dao.findAllList();
    }

    @Override
    public List<RiskDutyVo> selectInsRiskDutyByInsUnderwriteDLLVO(Long oid) {
        List<TposRiskDuty> irdList = this.selectInsRiskDutyByInsUnderwrite(oid);
        List<RiskDutyVo> rdList = this.getRiskDutyVoListByInsRiskDutyList(irdList);
        return rdList;
    }

    @Override
    public TposRiskDuty initInsRiskDuty(Long underwrite_id) {
        TposRiskDuty insRiskDuty = new TposRiskDuty();
        InsUnderwrite insUnderwrite = (InsUnderwrite)this.insUnderwriteService.selectById(underwrite_id);
        insRiskDuty.setUnderwrite(insUnderwrite);
        this.dao.insert(insRiskDuty);
        return insRiskDuty;
    }

    @Override
    public void accordingToTheRiskDutyVoSetUpInsRiskDuty(RiskDutyVo vo, Long underwrite_id) {
        TposRiskDuty insRiskDuty = null;
        insRiskDuty = StrUtil.isNotBlank((CharSequence)vo.getOid()) ? this.dao.selectById(Long.parseLong(vo.getOid())) : this.initInsRiskDuty(underwrite_id);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insRiskDuty);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateById(insRiskDuty);
    }

    @Override
    public void setRiskDutyByRiskDutyVo(List<RiskDutyVo> voList, Long underwrite_id) {
        if (voList != null && voList.size() > ConstProp.INT_NUMBER_ZERO) {
            for (RiskDutyVo vo : voList) {
                this.accordingToTheRiskDutyVoSetUpInsRiskDuty(vo, underwrite_id);
            }
        }
    }

    @Override
    public List<RiskDutyVo> getRiskDutyVoListByInsRiskDutyList(List<TposRiskDuty> irdList) {
        ArrayList<RiskDutyVo> voList = new ArrayList<RiskDutyVo>();
        if (irdList != null && irdList.size() > ConstProp.INT_NUMBER_ZERO) {
            for (TposRiskDuty ird : irdList) {
                voList.add(this.accordingToInsRiskDutyIntoRiskDutyVo(ird));
            }
        }
        return voList;
    }

    @Override
    public RiskDutyVo accordingToInsRiskDutyIntoRiskDutyVo(TposRiskDuty ird) {
        RiskDutyVo vo = new RiskDutyVo();
        if (ird == null) {
            return vo;
        }
        vo.setOid(String.valueOf(ird.getTpos_risk_duty_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)ird), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public void accordingToInsTopBuyersListGainInsRiskDuty(List<StTopBuyers> tbList, Long underwrite_id, Long insProducts_id) {
        ProPrimary insProduct = (ProPrimary)this.insProductService.selectById(insProducts_id);
        String cg = insProduct.getCountry_area_risk_type();
        if (insProduct == null || StrUtil.isBlank((String)cg)) {
            return;
        }
        ArrayList<String> indexOfList = new ArrayList<String>();
        for (StTopBuyers itb : tbList) {
            String countryGroup;
            String countryCode = this.insAreaService.accordingToCountryGainCountryCode(itb.getCom_buyer().getCountry());
            if (StrUtil.isBlank((String)countryCode) || StrUtil.isBlank((String)(countryGroup = this.insRiskLevelService.accordingToCountryCodeGainCountryGroup(countryCode, String.valueOf(insProduct.getPro_primary_id())))) || cg.indexOf(countryGroup) == ConstProp.INT_NUMBER_MINUS_ONE.intValue() || indexOfList.contains(countryGroup)) continue;
            indexOfList.add(countryGroup);
        }
        for (String str : indexOfList) {
            TposRiskDuty insRiskDuty = this.initInsRiskDuty(underwrite_id);
            insRiskDuty.setCountry_area_risk_type(str);
            this.dao.updateById(insRiskDuty);
        }
    }
}

