/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.apply.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.entity.common.ComTaskResidual;
import com.bcxin.ins.models.apply.dao.ComTaskResidualDao;
import com.bcxin.ins.models.apply.service.ComTaskResidualService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.util.SpringContextHolder;
import com.bcxin.ins.vo.shop.ImportInsuranceOrderRequest;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class ComTaskResidualServiceImpl
extends ServiceImpl<ComTaskResidualDao, ComTaskResidual>
implements ComTaskResidualService {
    @Autowired
    private ComTaskResidualDao dao;
    @Autowired
    private MyAsyncExecutor myAsyncExecutor;
    private Logger log = LoggerFactory.getLogger(ComTaskResidualServiceImpl.class);

    @Override
    public void disposeComTaskResidualList() {
        List ctrList = this.dao.selectByMap(null);
        for (ComTaskResidual ctr : ctrList) {
            try {
                Thread.sleep(300L);
                this.myAsyncExecutor.execute(() -> this.applyReturnBooleanOfClassReflect(ctr));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void applyReturnBooleanOfClassReflect(ComTaskResidual ctr) {
        ClassLoader cls = Thread.currentThread().getContextClassLoader();
        String errEsg = "";
        try {
            Class<?> c = cls.loadClass(ctr.getClass_name());
            String[] tArr = ctr.getParam_type_arr().split(",");
            String[] vArr = ctr.getParam_value_arr().split(",", -1);
            Class[] csArr = new Class[ctr.getParam_num()];
            Object[] otArr = new Object[ctr.getParam_num()];
            for (int i = 0; i < ctr.getParam_num(); ++i) {
                String tp = tArr[i];
                if ("String".equals(tp)) {
                    csArr[i] = String.class;
                    otArr[i] = String.valueOf(vArr[i]);
                    continue;
                }
                if ("int".equals(tp)) {
                    csArr[i] = Integer.TYPE;
                    otArr[i] = Integer.parseInt(vArr[i]);
                    continue;
                }
                if ("BigDecimal".equals(tp)) {
                    csArr[i] = BigDecimal.class;
                    otArr[i] = new BigDecimal(vArr[i]);
                    continue;
                }
                if ("Long".equals(tp)) {
                    csArr[i] = Long.class;
                    otArr[i] = Long.parseLong(vArr[i]);
                    continue;
                }
                if (!"com.bcxin.ins.vo.shop.ImportInsuranceOrderRequest".equals(tp)) continue;
                csArr[i] = ImportInsuranceOrderRequest.class;
                otArr[i] = JSONObject.parseObject((String)ctr.getParam_value_arr(), Class.forName(ctr.getParam_type_arr()));
            }
            Object o = SpringContextHolder.getBean(c);
            Method method = o.getClass().getDeclaredMethod(ctr.getMethod_name(), csArr);
            method.setAccessible(true);
            Object ret = method.invoke(o, otArr);
            if (ret != null) {
                boolean boo = (Boolean)ret;
                if (boo) {
                    this.dao.deleteById(ctr.getCom_task_residual_id());
                } else {
                    errEsg = "Apply Method Fail!!--------------------------";
                }
            }
        }
        catch (ClassNotFoundException e) {
            errEsg = e.getMessage();
        }
        catch (IllegalAccessException e) {
            errEsg = e.getMessage();
        }
        catch (NoSuchMethodException e) {
            errEsg = e.getMessage();
        }
        catch (SecurityException e) {
            errEsg = e.getMessage();
        }
        catch (IllegalArgumentException e) {
            errEsg = e.getMessage();
        }
        catch (InvocationTargetException e) {
            errEsg = e.getMessage();
        }
        if (StringUtils.isNotEmpty((CharSequence)errEsg)) {
            this.log.info("----------ComTaskResidual\u672a\u6210\u529f\u4efb\u52a1\u53cd\u5c04\u6267\u884c\uff08" + ctr.getAnnotation() + "\uff09,ExceptionMessage\uff1a" + errEsg);
        }
    }

    @Override
    public void saveComTaskResidual(String method_name, String annotation, String class_name, int param_num, String param_type_arr, String param_value_arr) {
        ComTaskResidual ctr = new ComTaskResidual(method_name, annotation, class_name, param_num, param_type_arr, param_value_arr);
        this.myAsyncExecutor.execute(() -> {
            try {
                this.dao.insert(ctr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.queryCnt(p)), this.dao.query(p));
    }

    @Override
    public R del(Map<Object, Object> p) {
        try {
            this.deleteById(Long.valueOf(String.valueOf(p.get("com_task_residual_id"))));
            return new R(Boolean.valueOf(true), "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u6b8b\u7559\u4efb\u52a1\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public R executeTask(Map<Object, Object> p) {
        try {
            ComTaskResidual ctr = (ComTaskResidual)this.selectById(Long.valueOf(String.valueOf(p.get("com_task_residual_id"))));
            this.applyReturnBooleanOfClassReflect(ctr);
            return new R(Boolean.valueOf(true), "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            this.log.error("\u6267\u884c\u6b8b\u7559\u4efb\u52a1\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public R batchExecuteTask() {
        try {
            this.disposeComTaskResidualList();
            return new R(Boolean.valueOf(true), "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            this.log.error("\u6267\u884c\u6b8b\u7559\u4efb\u52a1\uff0c\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public static void main(String[] args) {
        ComTaskResidual ctr = new ComTaskResidual("testReflect", "\u6d4b\u8bd5\u65b9\u6cd5", "com.bcxin.ins.service.order.PolicyService", 3, "String", "\u5475\u5475");
    }
}

