/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;

public class FtpUtils {
    private static final Log logger = LogFactory.getLog(FtpUtils.class);

    public static FTPClient getFTPClient(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort) {
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient = new FTPClient();
            ftpClient.connect(ftpHost, ftpPort);
            ftpClient.login(ftpUserName, ftpPassword);
            if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                logger.info((Object)"\u672a\u8fde\u63a5\u5230FTP\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002");
                ftpClient.disconnect();
            } else {
                logger.info((Object)"FTP\u8fde\u63a5\u6210\u529f\u3002");
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ftpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream downloadFile(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort, String ftpPath, String fileName) {
        FTPClient ftpClient = null;
        InputStream is = null;
        try {
            ftpClient = FtpUtils.getFTPClient(ftpHost, ftpUserName, ftpPassword, ftpPort);
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(ftpPath);
            is = ftpClient.retrieveFileStream(fileName);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("\u6ca1\u6709\u627e\u5230" + ftpPath + "\u6587\u4ef6"));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SocketException e) {
            logger.error((Object)"\u8fde\u63a5FTP\u5931\u8d25.");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\u3002");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (ftpClient != null) {
                    ftpClient.logout();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort, String ftpPath, String localPath, String fileName) {
        FTPClient ftpClient = null;
        OutputStream os = null;
        File dir = new File(localPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File localFile = new File(localPath + fileName);
        try {
            ftpClient = FtpUtils.getFTPClient(ftpHost, ftpUserName, ftpPassword, ftpPort);
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            FTPClientConfig conf = new FTPClientConfig("UNIX");
            ftpClient.configure(conf);
            ftpClient.setRemoteVerificationEnabled(false);
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(ftpPath);
            try (InputStream initialStream = ftpClient.retrieveFileStream(new String(fileName.getBytes("UTF-8"), "UTF-8"));
                 FileOutputStream outStream = new FileOutputStream(localFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = initialStream.read(buffer)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("\u6ca1\u6709\u627e\u5230" + ftpPath + "\u6587\u4ef6"));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SocketException e) {
            logger.error((Object)"\u8fde\u63a5FTP\u5931\u8d25.");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\u3002");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (ftpClient != null && ftpClient.isConnected()) {
                    ftpClient.logout();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return localFile;
    }

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadFile(String ftpHost, String ftpUserName, String ftpPassword, int ftpPort, String ftpPath, String fileName, InputStream input) {
        FTPClient ftp = null;
        try {
            ftp = FtpUtils.getFTPClient(ftpHost, ftpUserName, ftpPassword, ftpPort);
            ftp.changeWorkingDirectory(ftpPath);
            ftp.setFileType(2);
            fileName = new String(fileName.getBytes("GBK"), "iso-8859-1");
            ftp.storeFile(fileName, input);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (ftp != null) {
                    ftp.logout();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

