/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.util;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.HexUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.utils.HttpUtil;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthAjaxResult;
import com.bcxin.obpm.dto.DahuaFaceVerifyResult;
import com.bcxin.obpm.dto.FaceResult;
import com.bcxin.obpm.util.HttpUtils;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

@Component
public class FaceUtil {
    private static final Logger logger = LoggerFactory.getLogger(FaceUtil.class);
    @Value(value="${match-face}")
    private String FACE_MATCH_URL;
    @Resource
    private ConfigUtil configUtil;

    public String ImageToBase64(String imgPath) {
        String result = "";
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(imgPath);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
            result = this.base64Encode(data);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String base64Encode(byte[] base64) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(Objects.requireNonNull(base64)).replaceAll("[\\s*\t\n\r]", "");
    }

    public String facematch(String img1, String img2) throws IOException {
        StringBuffer result = new StringBuffer();
        HttpURLConnection connection = null;
        BufferedReader in = null;
        try {
            URL url = new URL(this.FACE_MATCH_URL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setInstanceFollowRedirects(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            StringBuilder sb = new StringBuilder();
            sb.append("image1=");
            sb.append(img1);
            sb.append("&image2=");
            sb.append(img2);
            ((OutputStream)out).write(sb.toString().getBytes());
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            int status = connection.getResponseCode();
            if (status == 200) {
                String tmp;
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((tmp = in.readLine()) != null) {
                    result.append(tmp);
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            connection.disconnect();
        }
        return result.toString();
    }

    public String facematchWithHongRuan(String img1, String img2) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("first", Base64.getDecoder().decode(img1));
        params.put("second", Base64.getDecoder().decode(img2));
        String result = HttpUtils.postWithJson(this.FACE_MATCH_URL, params);
        logger.error("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        if (StringUtils.isNotEmpty((String)result)) {
            AuthAjaxResult ajaxResult = (AuthAjaxResult)JSON.parseObject((String)result, AuthAjaxResult.class);
            if (ajaxResult.isSuccessful()) {
                JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)ajaxResult.getData()));
                FaceResult faceResult = new FaceResult();
                faceResult.setScore(Float.parseFloat(json.getString("faceSimilarScore")) * 100.0f);
                return JSON.toJSONString((Object)faceResult);
            }
            JSONObject error = JSON.parseObject((String)result);
            throw new Exception("\u8679\u8f6f\u6bd4\u5bf9\u5931\u8d25\uff0c" + error.getString("message"));
        }
        throw new Exception("\u8679\u8f6f\u6bd4\u5bf9\u5931\u8d25\uff0c\u8fd4\u56de\u7a7a");
    }

    public String facematchWithDahua(String img1, String img2) throws Exception {
        logger.error("\u53d1\u8d77\u4eba\u50cf\u6bd4\u5bf9\u7684\u8bf7\u6c42\uff08\u5927\u534e\uff09");
        Map<String, String> daHuaHeaderMap = FaceUtil.getDaHuaHeaderMap();
        logger.error("\u8bf7\u6c42\u5934\u90e8\uff1a{}", (Object)JSONObject.toJSONString(daHuaHeaderMap));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("srcFaceImage", img1);
        params.put("dstFaceImage", img2);
        String param = JSONObject.toJSONString(params);
        logger.error("\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        String result = HttpUtil.post((String)this.FACE_MATCH_URL, (String)param, daHuaHeaderMap);
        logger.error("\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        if (StringUtils.isNotEmpty((String)result)) {
            DahuaFaceVerifyResult faceVerifyResult = (DahuaFaceVerifyResult)JSONObject.parseObject((String)result, DahuaFaceVerifyResult.class);
            if (faceVerifyResult != null && faceVerifyResult.getSimilarity() != null) {
                FaceResult faceResult = new FaceResult();
                faceResult.setScore((float)(faceVerifyResult.getSimilarity() * 100.0));
                return JSONObject.toJSONString((Object)faceResult);
            }
            throw new Exception("\u5927\u534e\u6bd4\u5bf9\u5931\u8d25\uff0c" + result);
        }
        throw new Exception("\u5927\u534e\u6bd4\u5bf9\u5931\u8d25\uff0c\u8fd4\u56de\u7a7a");
    }

    private static Map<String, String> getDaHuaHeaderMap() {
        HashMap headerMap = Maps.newHashMap();
        String ak = "QkzBz5Z5BxCFjXNs";
        headerMap.put("X-Ca-AccessKey", ak);
        String sk = "58EpDtsKwWNNinxwbwwpFXw366SkcdpX";
        String nonce = UUID.randomUUID().toString().replace("-", "");
        headerMap.put("X-Ca-Nonce", nonce);
        String timestamp = System.currentTimeMillis() + "";
        headerMap.put("X-Ca-Timestamp", timestamp);
        String signStr = ak + nonce + timestamp + sk;
        try {
            String sign = HexUtil.encodeHexStr((byte[])MessageDigest.getInstance("MD5").digest(signStr.getBytes(StandardCharsets.UTF_8)));
            headerMap.put("X-Ca-Sign", sign);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return headerMap;
    }

    public static void main(String[] args) {
        Map<String, String> daHuaHeaderMap = FaceUtil.getDaHuaHeaderMap();
        System.out.println("\u8bf7\u6c42\u5934\u90e8\uff1a" + JSONObject.toJSONString(daHuaHeaderMap));
    }

    public boolean matchResult(String img1, String img2) throws Exception {
        boolean result = false;
        String matchStr = "";
        String current_native = this.configUtil.getCurrentNative();
        matchStr = "11".equals(current_native) || "64".equals(current_native) ? this.facematchWithHongRuan(img1, img2) : ("1405".equals(current_native) ? this.facematchWithDahua(img1, img2) : this.facematch(img1, img2));
        if (StringUtils.isNotEmpty((String)matchStr)) {
            FaceResult faceResult = (FaceResult)JSONObject.parseObject((String)matchStr, FaceResult.class);
            logger.error("faceResult.Score:" + faceResult.getScore());
            if (faceResult.getScore() >= 80.0f) {
                result = true;
            }
        }
        return result;
    }

    public static String imageToBase64ByOnline(String imgURL) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            URL url = new URL(imgURL);
            byte[] by = new byte[1024];
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream is = conn.getInputStream();
            int len = -1;
            while ((len = is.read(by)) != -1) {
                data.write(by, 0, len);
            }
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data.toByteArray());
    }

    public static boolean base64ToImage(String imgStr, String imgFilePath) {
        if (StringUtils.isEmpty((String)imgStr)) {
            return false;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] b = decoder.decodeBuffer(imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            FileOutputStream out = new FileOutputStream(imgFilePath);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(String remoteFilePath, String localFilePath) throws Exception {
        URL urlfile = null;
        HttpURLConnection httpUrl = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        File f = new File(localFilePath);
        try {
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            urlfile = new URL(remoteFilePath);
            httpUrl = (HttpURLConnection)urlfile.openConnection();
            httpUrl.connect();
            bis = new BufferedInputStream(httpUrl.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(f));
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = bis.read(b)) != -1) {
                ((BufferedOutputStream)bos).write(b, 0, len);
            }
            ((BufferedOutputStream)bos).flush();
            bis.close();
            httpUrl.disconnect();
        }
        catch (Exception e) {
            logger.error("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25:{}", (Object)remoteFilePath);
        }
        finally {
            try {
                bis.close();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

