/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.SysInterfaceLog;
import com.bcxin.auth.system.mapper.SysInterfaceLogMapper;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.dto.AuthenticationResult;
import com.bcxin.obpm.dto.BackgroundInfo;
import com.bcxin.obpm.dto.BackgroundResult;
import com.bcxin.obpm.dto.PerPhotoDto;
import com.bcxin.obpm.dto.SNCensorResult;
import com.bcxin.obpm.dto.SNPerInfoDto;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.obpm.util.FaceUtil;
import com.bcxin.obpm.util.FtpUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="backgroundService_610000")
public class SNBackgroundServiceImpl
implements BackgroundService {
    private static Logger logger = LoggerFactory.getLogger(SNBackgroundServiceImpl.class);
    @Autowired
    private FaceUtil faceUtil;
    @Resource
    private ConfigUtil configUtil;
    @Autowired
    private SysInterfaceLogMapper sysInterfaceLogMapper;

    @Override
    public AjaxResult personnelReview(String idNumber, String realName) {
        if (StringUtils.isEmpty((String)idNumber)) {
            return AjaxResult.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        ArrayList<BackgroundInfo> backgroundInfoList = new ArrayList<BackgroundInfo>();
        List<String> unRemind = this.configUtil.getUnRemindList();
        BackgroundResult backgroundResult = new BackgroundResult();
        backgroundResult.setIdNumber(idNumber);
        backgroundResult.setCensorResult(backgroundInfoList);
        logger.info("\u8eab\u4efd\u8bc1{}\u7b5b\u67e5\u7ed3\u679c:{}", (Object)idNumber, (Object)backgroundResult);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)backgroundResult);
    }

    private void checkPersonInfo(List<BackgroundInfo> list, String idNumber, List<String> unRemind) {
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String wfStr = "";
        try {
            boolean hasCriminalRecord;
            boolean isFugitive;
            HashMap<String, Object> wfMap = new HashMap<String, Object>();
            boolean isDrugUser = this.getSNCensorResult(idNumber, "2");
            if (isDrugUser) {
                wfStr = wfStr + "\u5438\u6bd2\u4eba\u5458,";
            }
            if (isFugitive = this.getSNCensorResult(idNumber, "3")) {
                wfStr = wfStr + "\u5728\u9003\u4eba\u5458,";
            }
            if (hasCriminalRecord = this.getSNCensorResult(idNumber, "4")) {
                wfStr = wfStr + "\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55,";
            }
            if (!wfStr.isEmpty()) {
                wfStr = wfStr.substring(0, wfStr.length() - 1);
                wfMap.put("detail", wfStr);
                backgroundInfo.setCode(200);
                backgroundInfo.setData(wfMap);
                backgroundInfo.setResult(1);
                backgroundInfo.setCxxt("\u9655\u897f\u56db\u5927\u5e93\u63a5\u53e3");
                list.add(backgroundInfo);
            }
        }
        catch (Exception e) {
            throw new V5BusinessException(e.getMessage());
        }
    }

    public AjaxResult checkPersonInfo(String idNumber) {
        ArrayList<BackgroundInfo> backgroundInfoList = new ArrayList<BackgroundInfo>();
        this.checkPersonInfo(backgroundInfoList, idNumber, null);
        String result = backgroundInfoList.stream().map(ii -> {
            Map<String, Object> rt = ii.getData();
            if (rt == null) {
                return null;
            }
            Object dtl = rt.get("detail");
            if (dtl == null) {
                return null;
            }
            return String.valueOf(dtl);
        }).filter(ii -> ii != null).collect(Collectors.joining(","));
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("problemDetails", result);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", objectMap);
    }

    private boolean getSNCensorResult(String idNumber, String type) {
        String requestUrl = "http://92.1.31.17/datac/service/support/es/query";
        SysInterfaceLog interfaceLog = new SysInterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl("http://92.1.31.17/datac/service/support/es/query");
        interfaceLog.setParameters("\u8bf7\u6c42\u4eba\u53e3\u5e93\u63a5\u53e3\uff1a" + idNumber);
        HashMap params = Maps.newHashMap();
        switch (type) {
            case "3": {
                params.put("resId", "38");
                params.put("sql", "(`ZJHM`=? and `ryzt_jyqk`=0)");
                break;
            }
            case "4": {
                params.put("resId", "62");
                params.put("sql", "(`ZJHM`=? and `ryjbxxbj` in ('0','1','5'))");
                break;
            }
            case "2": {
                params.put("resId", "57");
                params.put("sql", "(`gmsfhm`=? and `yxx`=1)");
            }
        }
        params.put("accessId", "ba3146d4");
        params.put("accessKey", "99565732e1654334859d52ae98b52c77");
        params.put("reqId", "40");
        params.put("queryValues", String.format("[{\"type\":\"string\",\"value\":\"%s\"}]", idNumber));
        logger.error("CensorRequestUrl:{}", (Object)requestUrl);
        logger.error("censorParams:{}", (Object)JSON.toJSONString((Object)params));
        int errorCount = 0;
        String responseContent = null;
        SNCensorResult snCensorResult = null;
        List<SNPerInfoDto> data = null;
        for (int i = 0; i < 3; ++i) {
            responseContent = HttpUtil.post((String)requestUrl, (Map)params);
            logger.error("\u9655\u897f\u80cc\u666f\u7b5b\u67e5\u65b0\u5e93\u67e5\u8be2{}\u8fd4\u56de:{}", (Object)idNumber, (Object)responseContent);
            snCensorResult = (SNCensorResult)JSON.parseObject((String)responseContent, SNCensorResult.class);
            if (snCensorResult != null && snCensorResult.getCode() == 0) {
                data = snCensorResult.getData();
                return data.size() > 0;
            }
            if (++errorCount == 3) break;
        }
        if (errorCount == 3) {
            interfaceLog.setResult("\u80cc\u666f\u7b5b\u67e5\u65b0\u5e93\u67e5\u8be2\u5f02\u5e38!!");
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(false);
            new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
            throw new V5BusinessException("\u80cc\u666f\u7b5b\u67e5\u65b0\u5e93\u67e5\u8be2\u5f02\u5e38\uff01\uff01");
        }
        return false;
    }

    @Override
    public AjaxResult getPersonnelInformation(String idNumber) {
        if (StringUtils.isEmpty((String)idNumber)) {
            return AjaxResult.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        AuthenticationResult authenticationResult = new AuthenticationResult();
        authenticationResult.setIdNumber(idNumber);
        try {
            PerPhotoDto perPhotoDto = this.getPopulationInfo(idNumber);
            authenticationResult.setPhoto(perPhotoDto.getPhoto());
            authenticationResult.setRealName(perPhotoDto.getName());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new V5BusinessException("\u5317\u4eac\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01\uff01");
        }
        logger.info("{}\u4eba\u5458\u4fe1\u606f\u670d\u52a1\u8fd4\u56de:{}", (Object)idNumber, (Object)authenticationResult);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)authenticationResult);
    }

    private PerPhotoDto getPopulationInfo(String idnum) {
        PerPhotoDto person = new PerPhotoDto();
        SNPerInfoDto snPerInfoDto = this.getSnPerInfo(idnum);
        if (snPerInfoDto != null) {
            person.setPhoto(snPerInfoDto.getZp());
            person.setName(snPerInfoDto.getXm());
            person.setIdNum(snPerInfoDto.getGmsfhm());
            return person;
        }
        return person;
    }

    private SNPerInfoDto getSnPerInfo(String idNumber) {
        HashMap<String, String> snPersonParams = new HashMap<String, String>();
        SysInterfaceLog interfaceLog = new SysInterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl("http://92.1.31.17/datac/service/support/es/query");
        interfaceLog.setParameters("\u8bf7\u6c42\u4eba\u53e3\u5e93\u63a5\u53e3\uff1a" + idNumber);
        snPersonParams.put("resId", "49");
        snPersonParams.put("sql", " (`GMSFHM`=?)");
        snPersonParams.put("accessId", "ba3146d4");
        snPersonParams.put("accessKey", "99565732e1654334859d52ae98b52c77");
        snPersonParams.put("reqId", "40");
        snPersonParams.put("queryValues", String.format("[{\"type\":\"string\",\"value\":\"%s\"}]", idNumber));
        logger.error("\u9655\u897f\u5b9e\u540d\u8ba4\u8bc1url:{}", (Object)"http://92.1.31.17/datac/service/support/es/query");
        logger.error("\u9655\u897f\u5b9e\u540d\u8ba4\u8bc1params:{}", snPersonParams);
        int errorCount = 0;
        for (int i = 0; i < 3; ++i) {
            String responseContent = HttpUtil.post((String)"http://92.1.31.17/datac/service/support/es/query", snPersonParams);
            SNCensorResult snCensorResult = (SNCensorResult)JSON.parseObject((String)responseContent, SNCensorResult.class);
            logger.error("\u9655\u897f\u5b9e\u540d\u8ba4\u8bc1snCensorResult:{}", (Object)snCensorResult);
            if (snCensorResult != null && snCensorResult.getCode() == 0) {
                List<SNPerInfoDto> data = snCensorResult.getData();
                if (data.size() > 0) {
                    String fileName;
                    SNPerInfoDto person = data.get(0);
                    String xp = person.getZp();
                    String path = xp.substring(0, xp.lastIndexOf("/"));
                    InputStream photoInputStream = FtpUtils.downloadFile("92.1.31.25", "xyyh", "xyyh@123", 12100, path, fileName = xp.substring(xp.lastIndexOf("/") + 1));
                    if (photoInputStream != null) {
                        byte[] bytes = IoUtil.readBytes((InputStream)photoInputStream);
                        String base64Code = Base64.getEncoder().encodeToString(bytes);
                        person.setZp(base64Code);
                    }
                    return person;
                }
                ++errorCount;
                logger.error("\u4eba\u53e3\u5e93\u83b7\u53d6\u5f02\u5e38,\u6ca1\u6709\u8fd4\u56de\u503c,\u8eab\u4efd\u8bc1\u53f7\uff1a" + idNumber);
            } else {
                ++errorCount;
            }
            if (errorCount != 3) continue;
            interfaceLog.setResult("\u83b7\u53d6\u4eba\u53e3\u5e93\u57fa\u672c\u4fe1\u606f\u5f02\u5e38!!");
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(false);
            new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AuthLog> validateResult(List<AuthLog> list) {
        for (AuthLog authLog2 : list) {
            try {
                this.matchResult(authLog2);
                authLog2.setAuthDate(DateUtils.getNowDate());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list.stream().filter(authLog -> StrUtil.isNotEmpty((CharSequence)authLog.getAuthStatus())).collect(Collectors.toList());
    }

    @Override
    public void getPersonnelAddress(String idNumber) {
    }

    public void matchResult(AuthLog authLog) throws IOException {
        try {
            PerPhotoDto person = this.getPopulationInfo(authLog.getIdNumber());
            String xp = "";
            String name = person.getName();
            if (StrUtil.isEmpty((CharSequence)name)) {
                authLog.setAuthStatus("2");
                authLog.setAuthResult("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
            } else if (name.equals(authLog.getSecurityName())) {
                xp = person.getPhoto();
                if (StrUtil.isEmpty((CharSequence)xp)) {
                    authLog.setAuthStatus("2");
                    authLog.setAuthResult("\u4eba\u53e3\u5e93\u65e0\u7167\u7247\u3002\u8bf7\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                }
            } else {
                authLog.setAuthStatus("2");
                authLog.setAuthResult("\u59d3\u540d\u4e0e\u8eab\u4efd\u8bc1\u53f7\u4e0d\u4e00\u81f4\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
            }
            if (StrUtil.isNotEmpty((CharSequence)xp)) {
                if (xp.trim().startsWith("http")) {
                    logger.error("\u5728\u7ebf\u5730\u5740\u8f6cbase64");
                    String suffix = ".jpg";
                    if (!xp.matches(".*access_token.*")) {
                        suffix = xp.substring(xp.lastIndexOf("."));
                    }
                    String filePath = BMSConfig.getTempPath() + UUID.randomUUID().toString() + suffix;
                    this.faceUtil.downloadFile(xp, filePath);
                    xp = this.faceUtil.ImageToBase64(filePath);
                    FileUtil.del((String)filePath);
                }
                if (this.faceUtil.matchResult(xp, this.faceUtil.ImageToBase64(authLog.getImgPath()))) {
                    authLog.setAuthStatus("3");
                    authLog.setAuthResult("\u8ba4\u8bc1\u6210\u529f");
                } else {
                    authLog.setAuthStatus("2");
                    authLog.setAuthResult("\u4eba\u8138\u7167\u7247\u4e0e\u8eab\u4efd\u8bc1\u53f7\u4e0d\u4e00\u81f4\u3002\u8bf7\u91cd\u65b0\u91c7\u96c6\u4eba\u8138\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                }
            }
            authLog.setAuthDate(DateUtils.getNowDate());
        }
        catch (Exception e) {
            authLog.setAuthStatus("1");
            authLog.setAuthResult("\u6bd4\u5bf9\u63a5\u53e3\u5f02\u5e38\uff01\uff01");
            e.printStackTrace();
        }
    }
}

