/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.service.impl;

import com.bcxin.auth.common.utils.bean.BeanUtils;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import com.bcxin.obpm.domain.MinisterialLog;
import com.bcxin.obpm.dto.Ministerial.DataSynchronizationSearchDto;
import com.bcxin.obpm.dto.Ministerial.MinisterialDataType;
import com.bcxin.obpm.mapper.MinisterialLogMapper;
import com.bcxin.obpm.service.MinisterialLogService;
import com.bcxin.obpm.util.DateUtil;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MinisterialLogServiceImpl
implements MinisterialLogService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MinisterialLogMapper ministerialLogDao;
    @Autowired
    private ConfigUtil configUtils;
    @Autowired
    private ISysConfigService configService;

    @Override
    public int delete(MinisterialLog ministerialLog) {
        ministerialLog.setUpdateTime(new Date());
        return this.ministerialLogDao.delete(ministerialLog);
    }

    @Override
    public int save(MinisterialLog ministerialLog) {
        if (ministerialLog.getId() == null) {
            ministerialLog.setCreateTime(new Date());
        } else {
            MinisterialLog dbMinisterialLog = this.ministerialLogDao.findById(ministerialLog.getId());
            BeanUtils.copyPropertiesIgnore((Object)((Object)ministerialLog), (Object)((Object)dbMinisterialLog), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbMinisterialLog), (Object)((Object)ministerialLog), (Boolean)false);
        }
        ministerialLog.setActive(true);
        ministerialLog.setUpdateTime(new Date());
        return this.ministerialLogDao.save(ministerialLog);
    }

    @Override
    public MinisterialLog findById(Long id) {
        return this.ministerialLogDao.findById(id);
    }

    @Override
    public MinisterialLog find(MinisterialLog ministerialLog) {
        return this.ministerialLogDao.find(ministerialLog);
    }

    @Override
    public void importBatch(List<MinisterialLog> list) {
        List<MinisterialLog> dbList = this.ministerialLogDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (MinisterialLog ministerialLog : list) {
                try {
                    if (this.configUtils.isIntranet()) continue;
                    ministerialLog.setUpdateTime(DateUtil.dateAdd(6, ministerialLog.getUpdateTime(), 1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.ministerialLogDao.saveBatch(list);
        }
    }

    @Override
    public List<MinisterialLog> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.ministerialLogDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<MinisterialLog> findDSOutList(String startDate) {
        return this.ministerialLogDao.findDSOutList(startDate);
    }

    @Override
    public List<MinisterialLog> findByBatchId(List<MinisterialLog> list) {
        return this.ministerialLogDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(MinisterialLog ministerialLog) {
        ministerialLog.setUpdateTime(new Date());
        this.ministerialLogDao.updateSelective(ministerialLog);
    }

    @Override
    public List<Map> getBusinessDatas(MinisterialDataType dataType, int limit) {
        Field[] fields;
        Class entityClass = dataType.getDataClazz();
        if (!entityClass.isAnnotationPresent(MinisterialEntity.class)) {
            return null;
        }
        MinisterialEntity entityAnno = entityClass.getAnnotation(MinisterialEntity.class);
        String tableName = entityAnno.tableName();
        String extraWhere = entityAnno.extraWhere();
        StringBuilder tableColumns = new StringBuilder();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(MinisterialAttr.class)) continue;
            MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
            if (StringUtil.isNotEmpty((String)resource.DATE_FORMAT())) {
                if (resource.isSubQuery()) {
                    tableColumns.append("DATE_FORMAT( ").append(resource.column()).append(",'").append(resource.DATE_FORMAT()).append("') as ").append(field.getName()).append(",");
                    continue;
                }
                tableColumns.append("DATE_FORMAT( t1.").append(resource.column()).append(",'").append(resource.DATE_FORMAT()).append("') as ").append(field.getName()).append(",");
                continue;
            }
            if (!resource.isSubQuery()) {
                tableColumns.append(" t1.");
            }
            tableColumns.append(resource.column()).append(" as ").append(field.getName()).append(",");
        }
        String columns = tableColumns.toString();
        columns = columns.substring(0, columns.length() - 1);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("dataType", dataType.getCode());
        paramMap.put("tableName", tableName);
        paramMap.put("tableColumns", columns);
        paramMap.put("created", this.configUtils.getCreated());
        paramMap.put("limit", limit);
        paramMap.put("extraWhere", extraWhere.contains("#{nativeName}") ? extraWhere.replace("#{nativeName}", this.configUtils.getCurrentNativeName()) : extraWhere);
        return this.ministerialLogDao.findByType(paramMap);
    }

    @Override
    public List<Map> getBusinessDatasByParam(MinisterialDataType dataType, Map paramMap) {
        Field[] fields;
        Class entityClass = dataType.getDataClazz();
        MinisterialEntity entityAnno = entityClass.getAnnotation(MinisterialEntity.class);
        String tableName = entityAnno.tableName();
        StringBuilder tableColumns = new StringBuilder();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(MinisterialAttr.class)) continue;
            MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
            if (StringUtil.isNotEmpty((String)resource.DATE_FORMAT())) {
                tableColumns.append("DATE_FORMAT( t1.").append(resource.column()).append(",'").append(resource.DATE_FORMAT()).append("') as ").append(field.getName()).append(",");
                continue;
            }
            if (!resource.isSubQuery()) {
                tableColumns.append(" t1.");
            }
            tableColumns.append(resource.column()).append(" as ").append(field.getName()).append(",");
        }
        String columns = tableColumns.toString();
        columns = columns.substring(0, columns.length() - 1);
        paramMap.put("dataType", dataType.getCode());
        paramMap.put("tableName", tableName);
        paramMap.put("created", this.configUtils.getCreated());
        paramMap.put("tableColumns", columns);
        return this.ministerialLogDao.findByParam(paramMap);
    }

    @Override
    public void saveByType(MinisterialLog ministerialLog, List subList) {
        this.ministerialLogDao.saveByType(ministerialLog, subList);
    }

    private void getSql(Map<String, Object> paramMap) {
        StringBuilder sql = new StringBuilder("select t1.id," + paramMap.get("tableColumns"));
        sql.append(" FROM " + paramMap.get("tableName") + " t1 where 1=1 " + paramMap.get("extraWhere"));
        sql.append(" AND NOT EXISTS (select 1 from ministerial_log t2 where t1.id =t2.businessId and t2.active=true");
        sql.append(" AND t2.businessType ='" + paramMap.get("tableName") + "')");
        sql.append(" ORDER BY RAND() limit " + paramMap.get("limit") + ";");
        this.logger.error(sql.toString());
    }
}

