/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.HttpUtil;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.SysInterfaceLog;
import com.bcxin.auth.system.mapper.SysInterfaceLogMapper;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.dto.AuthenticationResult;
import com.bcxin.obpm.dto.BackgroundInfo;
import com.bcxin.obpm.dto.BackgroundResult;
import com.bcxin.obpm.dto.JcCensorResult;
import com.bcxin.obpm.dto.JcPerInfoDto;
import com.bcxin.obpm.dto.PerPhotoDto;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.obpm.util.FaceUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="backgroundService_140500")
public class JcBackgroundServiceImpl
implements BackgroundService {
    private static Logger logger = LoggerFactory.getLogger(JcBackgroundServiceImpl.class);
    @Autowired
    private FaceUtil faceUtil;
    @Autowired
    private SysInterfaceLogMapper sysInterfaceLogMapper;

    @Override
    public AjaxResult personnelReview(String idNumber, String realName) {
        if (StringUtils.isEmpty((String)idNumber)) {
            return AjaxResult.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        ArrayList<BackgroundInfo> backgroundInfoList = new ArrayList<BackgroundInfo>();
        BackgroundResult backgroundResult = new BackgroundResult();
        this.checkPersonInfo(backgroundInfoList, idNumber);
        backgroundResult.setIdNumber(idNumber);
        backgroundResult.setCensorResult(backgroundInfoList);
        logger.info("\u8eab\u4efd\u8bc1{}\u7b5b\u67e5\u7ed3\u679c:{}", (Object)idNumber, (Object)backgroundResult);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)backgroundResult);
    }

    private void checkPersonInfo(List<BackgroundInfo> list, String idNumber) {
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String wfStr = "";
        try {
            boolean hasCriminalRecord;
            boolean isFugitive;
            HashMap<String, Object> wfMap = new HashMap<String, Object>();
            boolean isPointsUser = this.getJcCensorResult(idNumber, "http://23.232.14.211:8950/dataApi/services/v1.0.0/people/background/zdr/compare?idNo=%s");
            if (isPointsUser) {
                wfStr = wfStr + "\u91cd\u70b9\u4eba\u5458,";
            }
            if (isFugitive = this.getJcCensorResult(idNumber, "http://23.232.14.211:8950/dataApi/services/v1.0.0/people/background/ztry/compare?idNo=%s")) {
                wfStr = wfStr + "\u5728\u9003\u4eba\u5458,";
            }
            if (hasCriminalRecord = this.getJcCensorResult(idNumber, "http://23.232.14.211:8950/dataApi/services/v1.0.0/people/background/case/compare?idNo=%s")) {
                wfStr = wfStr + "\u6709\u8fdd\u6cd5\u72af\u7f6a\u8bb0\u5f55,";
            }
            if (!wfStr.isEmpty()) {
                wfStr = wfStr.substring(0, wfStr.length() - 1);
                wfMap.put("detail", wfStr);
                backgroundInfo.setCode(200);
                backgroundInfo.setData(wfMap);
                backgroundInfo.setResult(1);
                backgroundInfo.setCxxt("\u664b\u57ce\u5e02\u516c\u5b89\u5c40\u670d\u52a1\u603b\u7ebf\u63a5\u53e3");
                list.add(backgroundInfo);
            }
        }
        catch (Exception e) {
            throw new V5BusinessException(e.getMessage());
        }
    }

    private boolean getJcCensorResult(String idNumber, String requestUrl) {
        SysInterfaceLog interfaceLog = new SysInterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(requestUrl);
        interfaceLog.setParameters("\u664b\u57ce\u5e02\u516c\u5b89\u5c40\u670d\u52a1\u603b\u7ebf\u63a5\u53e3\uff1a" + idNumber);
        requestUrl = String.format(requestUrl, idNumber);
        Map<String, String> headerMap = this.getHeaderMap();
        logger.error("requestUrl:{}", (Object)requestUrl);
        logger.error("headerMap:{}", (Object)JSONObject.toJSONString(headerMap));
        for (int i = 0; i < 3; ++i) {
            String result = HttpUtil.get((String)requestUrl, headerMap);
            logger.error("\u664b\u57ce\u5e02\u516c\u5b89\u5c40\u670d\u52a1\u603b\u7ebf\u63a5\u53e3\uff0c\u80cc\u666f\u7b5b\u67e5\uff0c\u8eab\u4efd\u8bc1\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)idNumber, (Object)result);
            JcCensorResult jcCensorResult = (JcCensorResult)JSONObject.parseObject((String)result, JcCensorResult.class);
            if (jcCensorResult == null || jcCensorResult.getCode() != 200) continue;
            interfaceLog.setResult(result);
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(true);
            new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
            return CollectionUtil.isNotEmpty(jcCensorResult.getData());
        }
        interfaceLog.setResult("\u80cc\u666f\u7b5b\u67e5\u65b0\u5e93\u67e5\u8be2\u5f02\u5e38!!");
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(false);
        new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
        throw new V5BusinessException("\u80cc\u666f\u7b5b\u67e5\u65b0\u5e93\u67e5\u8be2\u5f02\u5e38\uff01\uff01");
    }

    @Override
    public AjaxResult getPersonnelInformation(String idNumber) {
        if (StringUtils.isEmpty((String)idNumber)) {
            return AjaxResult.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        AuthenticationResult authenticationResult = new AuthenticationResult();
        authenticationResult.setIdNumber(idNumber);
        try {
            PerPhotoDto perPhotoDto = this.getPopulationInfo(idNumber, null);
            authenticationResult.setPhoto(perPhotoDto.getPhoto());
            authenticationResult.setRealName(perPhotoDto.getName());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new V5BusinessException("\u664b\u57ce\u5e02\u516c\u5b89\u5c40\u670d\u52a1\u603b\u7ebf\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01\uff01");
        }
        logger.info("{}\u4eba\u5458\u4fe1\u606f\u670d\u52a1\u8fd4\u56de:{}", (Object)idNumber, (Object)authenticationResult);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)authenticationResult);
    }

    private PerPhotoDto getPopulationInfo(String idnum, String name) {
        PerPhotoDto person = new PerPhotoDto();
        JcPerInfoDto jcPerInfoDto = this.getJcPerInfo(idnum, name);
        if (jcPerInfoDto != null) {
            person.setPhoto(jcPerInfoDto.getIdCardUrl());
            person.setName(jcPerInfoDto.getName());
            person.setIdNum(jcPerInfoDto.getIdNo());
        }
        return person;
    }

    private JcPerInfoDto getJcPerInfo(String idNumber, String name) {
        SysInterfaceLog interfaceLog = new SysInterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl("http://23.232.14.211:8950/dataApi/services/v1.0.0/people/identity/verify?idNo=%s&name=%s");
        interfaceLog.setParameters("\u664b\u57ce\u5e02\u516c\u5b89\u5c40\u670d\u52a1\u603b\u7ebf\u63a5\u53e3\uff1a" + idNumber);
        String requestUrl = String.format("http://23.232.14.211:8950/dataApi/services/v1.0.0/people/identity/verify?idNo=%s&name=%s", idNumber, name);
        Map<String, String> headerMap = this.getHeaderMap();
        logger.error("\u664b\u57ce\u5b9e\u540d\u8ba4\u8bc1url:{}", (Object)requestUrl);
        logger.error("\u664b\u57ce\u5b9e\u540d\u8ba4\u8bc1headerMap:{}", (Object)JSONObject.toJSONString(headerMap));
        for (int i = 0; i < 3; ++i) {
            List<JSONObject> data;
            String result = HttpUtil.get((String)requestUrl, headerMap);
            logger.error("\u664b\u57ce\u5e02\u516c\u5b89\u5c40\u670d\u52a1\u603b\u7ebf\u63a5\u53e3\uff0c\u5b9e\u540d\u8ba4\u8bc1\uff0c\u8eab\u4efd\u8bc1\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)idNumber, (Object)result);
            JcCensorResult jcCensorResult = (JcCensorResult)JSONObject.parseObject((String)result, JcCensorResult.class);
            if (jcCensorResult == null || jcCensorResult.getCode() != 200 || (data = jcCensorResult.getData()).size() <= 0) continue;
            JcPerInfoDto person = (JcPerInfoDto)data.get(0).toJavaObject(JcPerInfoDto.class);
            interfaceLog.setResult(result);
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(true);
            new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
            return person;
        }
        interfaceLog.setResult("\u83b7\u53d6\u4eba\u53e3\u5e93\u57fa\u672c\u4fe1\u606f\u5f02\u5e38!!");
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(false);
        new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AuthLog> validateResult(List<AuthLog> list) {
        for (AuthLog authLog2 : list) {
            try {
                this.matchResult(authLog2);
                authLog2.setAuthDate(DateUtils.getNowDate());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list.stream().filter(authLog -> StrUtil.isNotEmpty((CharSequence)authLog.getAuthStatus())).collect(Collectors.toList());
    }

    @Override
    public void getPersonnelAddress(String idNumber) {
    }

    public void matchResult(AuthLog authLog) throws IOException {
        try {
            PerPhotoDto person = this.getPopulationInfo(authLog.getIdNumber(), authLog.getSecurityName());
            String xp = "";
            String name = person.getName();
            if (StrUtil.isEmpty((CharSequence)name)) {
                authLog.setAuthStatus("2");
                authLog.setAuthResult("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
            } else if (name.equals(authLog.getSecurityName())) {
                xp = person.getPhoto();
                if (StrUtil.isEmpty((CharSequence)xp)) {
                    authLog.setAuthStatus("2");
                    authLog.setAuthResult("\u4eba\u53e3\u5e93\u65e0\u7167\u7247\u3002\u8bf7\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                }
            } else {
                authLog.setAuthStatus("2");
                authLog.setAuthResult("\u59d3\u540d\u4e0e\u8eab\u4efd\u8bc1\u53f7\u4e0d\u4e00\u81f4\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
            }
            if (StrUtil.isNotEmpty((CharSequence)xp)) {
                if (this.faceUtil.matchResult(xp, this.faceUtil.ImageToBase64(authLog.getImgPath()))) {
                    authLog.setAuthStatus("3");
                    authLog.setAuthResult("\u8ba4\u8bc1\u6210\u529f");
                } else {
                    authLog.setAuthStatus("2");
                    authLog.setAuthResult("\u4eba\u8138\u7167\u7247\u4e0e\u8eab\u4efd\u8bc1\u53f7\u4e0d\u4e00\u81f4\u3002\u8bf7\u91cd\u65b0\u91c7\u96c6\u4eba\u8138\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                }
            }
            authLog.setAuthDate(DateUtils.getNowDate());
        }
        catch (Exception e) {
            authLog.setAuthStatus("1");
            authLog.setAuthResult("\u6bd4\u5bf9\u63a5\u53e3\u5f02\u5e38\uff01\uff01");
            e.printStackTrace();
        }
    }

    private Map<String, String> getHeaderMap() {
        HashMap headerMap = Maps.newHashMap();
        String ak = "QkzBz5Z5BxCFjXNs";
        headerMap.put("X-Ca-AccessKey", ak);
        String sk = "58EpDtsKwWNNinxwbwwpFXw366SkcdpX";
        String nonce = UUID.randomUUID().toString().replace("-", "");
        headerMap.put("X-Ca-Nonce", nonce);
        String timestamp = System.currentTimeMillis() + "";
        headerMap.put("X-Ca-Timestamp", timestamp);
        String signStr = ak + nonce + timestamp + sk;
        try {
            String sign = HexUtil.encodeHexStr((byte[])MessageDigest.getInstance("MD5").digest(signStr.getBytes(StandardCharsets.UTF_8)));
            headerMap.put("X-Ca-Sign", sign);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return headerMap;
    }
}

