/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.SysInterfaceLog;
import com.bcxin.auth.system.mapper.SysInterfaceLogMapper;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.dto.AuthenticationResult;
import com.bcxin.obpm.dto.BackgroundInfo;
import com.bcxin.obpm.dto.BackgroundResult;
import com.bcxin.obpm.dto.PerPhotoDto;
import com.bcxin.obpm.dto.hunan.HuNanPeopleInfo;
import com.bcxin.obpm.dto.hunan.HuNanPeopleResult;
import com.bcxin.obpm.dto.hunan.HuNanResponseInfo;
import com.bcxin.obpm.dto.hunan.HuNanResult;
import com.bcxin.obpm.dto.hunan.Token;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.obpm.util.FaceUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service(value="backgroundService_430000")
public class HNBackgroundServiceImpl
implements BackgroundService {
    private static Logger logger = LoggerFactory.getLogger(HNBackgroundServiceImpl.class);
    @Autowired
    private ConfigUtil configUtil;
    @Resource
    private FaceUtil faceUtil;
    @Autowired
    private SysInterfaceLogMapper sysInterfaceLogMapper;

    public Token getToken() {
        HashMap params = Maps.newHashMap();
        params.put("client_id", "E7ECFE3CC13444B4B84F063BF089EF17");
        params.put("client_secret", "4C31078A-633C-46FB-86D3-9A7EF0D49B00");
        params.put("grant_type", "interface");
        params.put("type", "interface");
        params.put("sfzh", DigestUtils.md5DigestAsHex((byte[])"430102198906112012".getBytes()));
        String postResult = HttpUtil.post((String)"http://65.26.10.139/authserver/oauth/token", (Map)params);
        return (Token)com.alibaba.fastjson.JSON.parseObject((String)postResult, Token.class);
    }

    @Override
    public AjaxResult getPersonnelInformation(String idNumber) {
        HttpResponse photoResponse;
        String photoBody;
        HuNanResult photoResult;
        if (StringUtils.isEmpty((String)idNumber)) {
            return AjaxResult.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        AuthenticationResult authenticationResult = new AuthenticationResult();
        authenticationResult.setIdNumber(idNumber);
        if (this.configUtil.isTest()) {
            return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)authenticationResult);
        }
        Token token = this.getToken();
        logger.info("token:{}", (Object)token);
        HashMap params = Maps.newHashMap();
        params.put("sfzh", idNumber);
        HttpRequest request = HttpUtil.createPost((String)"http://65.26.10.139/api/api-gabzy/exapi/querySyrkInfo");
        request.header("Content-Type", "application/json;charset=UTF-8");
        request.bearerAuth(token.getAccessToken());
        request.body(JSONUtil.toJsonStr((Object)params));
        HttpResponse response = request.execute();
        String peopleInfoBody = response.body();
        HuNanPeopleResult huNanPeopleResult = (HuNanPeopleResult)JSONUtil.toBean((String)peopleInfoBody, HuNanPeopleResult.class);
        logger.info("{}\u4eba\u53e3\u5e93\u8fd4\u56de:{}", (Object)idNumber, (Object)huNanPeopleResult);
        List<HuNanPeopleInfo> data = huNanPeopleResult.getData();
        if (data != null && !data.isEmpty()) {
            HuNanPeopleInfo huNanPeopleInfo = data.get(0);
            authenticationResult.setRealName(huNanPeopleInfo.getXm());
        }
        if (StrUtil.isNotEmpty((CharSequence)(photoResult = (HuNanResult)JSONUtil.toBean((String)(photoBody = (photoResponse = HttpUtil.createGet((String)"http://65.26.10.139/api/api-hcxx/photo/hn").form("sfzh", (Object)idNumber).form("access_token", (Object)token.getAccessToken()).execute()).body()), HuNanResult.class)).getData())) {
            authenticationResult.setPhoto(photoResult.getData());
        }
        logger.info("{}\u4eba\u5458\u4fe1\u606f\u670d\u52a1\u8fd4\u56de:{}", (Object)idNumber, (Object)authenticationResult);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)authenticationResult);
    }

    @Override
    public List<AuthLog> validateResult(List<AuthLog> list) {
        Map<String, PerPhotoDto> personMap = this.getPopulationInfo(list);
        for (AuthLog authLog2 : list) {
            try {
                PerPhotoDto person = personMap.get(authLog2.getIdNumber());
                String xp = "";
                String name = person.getName();
                if (StrUtil.isEmpty((CharSequence)name)) {
                    authLog2.setAuthStatus("2");
                    authLog2.setAuthResult("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                } else if (name.equals(authLog2.getSecurityName())) {
                    xp = person.getPhoto();
                    if (StrUtil.isEmpty((CharSequence)xp)) {
                        authLog2.setAuthStatus("2");
                        authLog2.setAuthResult("\u4eba\u53e3\u5e93\u65e0\u7167\u7247\u3002\u8bf7\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                    }
                } else {
                    authLog2.setAuthStatus("2");
                    authLog2.setAuthResult("\u59d3\u540d\u4e0e\u8eab\u4efd\u8bc1\u53f7\u4e0d\u4e00\u81f4\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                }
                if (StrUtil.isNotEmpty((CharSequence)xp)) {
                    if (xp.trim().startsWith("http")) {
                        logger.error("\u5728\u7ebf\u5730\u5740\u8f6cbase64");
                        String suffix = ".jpg";
                        if (!xp.matches(".*access_token.*")) {
                            suffix = xp.substring(xp.lastIndexOf("."));
                        }
                        String filePath = BMSConfig.getTempPath() + UUID.randomUUID().toString() + suffix;
                        this.faceUtil.downloadFile(xp, filePath);
                        xp = this.faceUtil.ImageToBase64(filePath);
                        FileUtil.del((String)filePath);
                    }
                    if (this.faceUtil.matchResult(xp, this.faceUtil.ImageToBase64(authLog2.getImgPath()))) {
                        authLog2.setAuthStatus("3");
                        authLog2.setAuthResult("\u8ba4\u8bc1\u6210\u529f");
                    } else {
                        authLog2.setAuthStatus("2");
                        authLog2.setAuthResult("\u4eba\u8138\u7167\u7247\u4e0e\u8eab\u4efd\u8bc1\u53f7\u4e0d\u4e00\u81f4\u3002\u8bf7\u91cd\u65b0\u91c7\u96c6\u4eba\u8138\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                    }
                }
                authLog2.setAuthDate(DateUtils.getNowDate());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return list.stream().filter(authLog -> StrUtil.isNotEmpty((CharSequence)authLog.getAuthStatus())).collect(Collectors.toList());
    }

    @Override
    public void getPersonnelAddress(String idNumber) {
    }

    private PerPhotoDto getPopulationInfo(String idnum) {
        PerPhotoDto perPhotoDto = new PerPhotoDto();
        SysInterfaceLog interfaceLog = new SysInterfaceLog();
        Boolean isSuccessful = true;
        perPhotoDto.setIdNum(idnum);
        Token token = this.getToken();
        logger.error("token:{}", (Object)token);
        HashMap params = Maps.newHashMap();
        params.put("sfzh", idnum);
        logger.error("\u8bf7\u6c42\u5730\u5740:{}", (Object)"http://65.26.10.139/api/api-gabzy/exapi/querySyrkInfo");
        logger.error("\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSONUtil.toJsonStr((Object)params));
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl("http://65.26.10.139/api/api-gabzy/exapi/querySyrkInfo");
        interfaceLog.setParameters(JSONUtil.toJsonStr((Object)params));
        HttpRequest request = HttpUtil.createPost((String)"http://65.26.10.139/api/api-gabzy/exapi/querySyrkInfo");
        request.header("Content-Type", "application/json;charset=UTF-8");
        request.bearerAuth(token.getAccessToken());
        request.body(JSONUtil.toJsonStr((Object)params));
        HttpResponse response = request.execute();
        String peopleInfoBody = response.body();
        HuNanPeopleResult huNanPeopleResult = (HuNanPeopleResult)JSONUtil.toBean((String)peopleInfoBody, HuNanPeopleResult.class);
        logger.error("{}\u4eba\u53e3\u5e93\u8fd4\u56de:{}", (Object)idnum, (Object)huNanPeopleResult);
        List<HuNanPeopleInfo> data = huNanPeopleResult.getData();
        if (data != null && !data.isEmpty()) {
            HuNanPeopleInfo huNanPeopleInfo = data.get(0);
            perPhotoDto.setName(huNanPeopleInfo.getXm());
            logger.error("\u4eba\u5458\u4fe1\u606f\u670d\u52a1\u5730\u5740:{}", (Object)"http://65.26.10.139/api/api-hcxx/photo/hn");
            HttpResponse photoResponse = HttpUtil.createGet((String)"http://65.26.10.139/api/api-hcxx/photo/hn").form("sfzh", (Object)idnum).form("access_token", (Object)token.getAccessToken()).execute();
            String photoBody = photoResponse.body();
            logger.error("{}\u4eba\u5458\u4fe1\u606f\u670d\u52a1\u8fd4\u56de:{}", (Object)idnum, (Object)photoBody);
            HuNanResult photoResult = (HuNanResult)JSONUtil.toBean((String)photoBody, HuNanResult.class);
            if (StrUtil.isNotEmpty((CharSequence)photoResult.getData())) {
                perPhotoDto.setPhoto(photoResult.getData());
            }
        }
        interfaceLog.setResult(perPhotoDto.toString());
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(isSuccessful);
        new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
        return perPhotoDto;
    }

    public Map<String, PerPhotoDto> getPopulationInfo(List<AuthLog> authLogList) {
        HashMap<String, PerPhotoDto> personList = new HashMap<String, PerPhotoDto>();
        PerPhotoDto person = null;
        for (AuthLog authLog : authLogList) {
            person = this.getPopulationInfo(authLog.getIdNumber());
            if (person == null) continue;
            personList.put(person.getIdNum(), person);
        }
        return personList;
    }

    @Override
    public AjaxResult personnelReview(String idNumber, String realName) {
        if (StringUtils.isEmpty((String)idNumber)) {
            return AjaxResult.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        BackgroundResult backgroundResult = new BackgroundResult();
        backgroundResult.setIdNumber(idNumber);
        if (this.configUtil.isTest()) {
            return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f");
        }
        ArrayList<BackgroundInfo> backgroundInfoList = new ArrayList<BackgroundInfo>();
        backgroundResult.setCensorResult(backgroundInfoList);
        logger.info("\u8eab\u4efd\u8bc1{}\u7b5b\u67e5\u7ed3\u679c:{}", (Object)idNumber, (Object)backgroundResult);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)backgroundResult);
    }

    private HuNanResponseInfo getResponseResult(String sender_id, String service_id, String postURL, String idNumber, boolean isEscaped) {
        String returnValue = "";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HuNanResponseInfo huNanResponseInfo = new HuNanResponseInfo();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(postURL);
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            String data = this.getRequestFrom(idNumber, isEscaped);
            StringEntity requestEntity = new StringEntity(data, "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            System.out.println(requestEntity);
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("senderid", sender_id);
            httpPost.setHeader("serviceid", service_id);
            httpPost.setHeader("bus_sre_name", "%E6%B5%8B%E8%AF%95");
            httpPost.setHeader("end_user.id_card", "350629198905055025");
            httpPost.setHeader("end_user.department", "430000");
            httpPost.setHeader("end_user.certificate", "BH9527");
            httpPost.setHeader("end_user.device_id", "65.28.39.255");
            httpPost.setHeader("timeout", "60");
            httpPost.setHeader("timestamp", timestamp);
            httpPost.setConfig(requestConfig.build());
            httpPost.setEntity((HttpEntity)requestEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            JSONObject object = JSONObject.parseObject((String)returnValue);
            logger.error("\u6e56\u5357\u65b0\u80cc\u666f\u7b5b\u67e5\u8eab\u4efd\u8bc1:" + idNumber + "\u8fd4\u56de\u7ed3\u679c:" + object.toJSONString());
            huNanResponseInfo = (HuNanResponseInfo)JSONObject.parseObject((String)returnValue, HuNanResponseInfo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u80cc\u666f\u7b5b\u67e5\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
            throw new V5BusinessException(e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return huNanResponseInfo;
    }

    private String getRequestFrom(String idNumber, boolean isEscaped) {
        HashMap requestForm = Maps.newHashMap();
        requestForm.put("httpMethod", "GET");
        HashMap executeSource = Maps.newHashMap();
        HashMap query = Maps.newHashMap();
        HashMap term = Maps.newHashMap();
        HashMap keyword = Maps.newHashMap();
        keyword.put("value", idNumber);
        String key = "zjhm.keyword";
        if (isEscaped) {
            key = "gmsfzh.keyword";
        }
        term.put(key, keyword);
        query.put("term", term);
        executeSource.put("query", query);
        requestForm.put("executeSource", executeSource);
        return JSONUtil.toJsonStr((JSON)JSONUtil.parse((Object)requestForm));
    }

    public BackgroundInfo getInformationOnDrugPersonnel(String idNumber) {
        logger.error("jds\u4eba\u5458\u4fe1\u606f\u901a\u7528\u6570\u636e\u67e5\u8be2-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id = "C90-43000061";
        String service_id = "S-430000000000-0104-00418";
        String postURL = "http://10.142.247.70:8581/GatewayMsg/proxy/invoke";
        try {
            HuNanResponseInfo huNanResponseInfo = this.getResponseResult(sender_id, service_id, postURL, idNumber, false);
            if (StringUtils.isNotNull((Object)huNanResponseInfo.getHits()) && StringUtils.isNotNull((Object)huNanResponseInfo.getHits().getTotal()) && huNanResponseInfo.getHits().getTotal().getValue() != 0) {
                HashMap<String, Object> wfMap = new HashMap<String, Object>();
                wfMap.put("detail", "\u6212\u6bd2\u6240\u4eba\u5458");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("\u7701\u5385_\u76d1\u7ba1_\u6212\u6bd2\u6240\u4eba\u5458\u4fe1\u606f");
                backgroundInfo.setData(wfMap);
                backgroundInfo.setResult(1);
            }
        }
        catch (Exception e) {
            throw new V5BusinessException("jds\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
        }
        return backgroundInfo;
    }

    public BackgroundInfo getInformationOnDetentionPersonnel(String idNumber) {
        logger.error("jls\u4eba\u5458\u4fe1\u606f\u901a\u7528\u6570\u636e\u67e5\u8be2-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id = "C90-43000061";
        String service_id = "S-430000000000-0104-00405";
        String postURL = "http://10.142.247.70:8581/GatewayMsg/proxy/invoke";
        try {
            HuNanResponseInfo huNanResponseInfo = this.getResponseResult(sender_id, service_id, postURL, idNumber, false);
            if (StringUtils.isNotNull((Object)huNanResponseInfo.getHits()) && StringUtils.isNotNull((Object)huNanResponseInfo.getHits().getTotal()) && huNanResponseInfo.getHits().getTotal().getValue() != 0) {
                HashMap<String, Object> wfMap = new HashMap<String, Object>();
                wfMap.put("detail", "\u62d8\u7559\u6240\u4eba\u5458");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("\u7701\u5385_\u76d1\u7ba1_\u62d8\u7559\u6240\u4eba\u5458\u4fe1\u606f");
                backgroundInfo.setData(wfMap);
                backgroundInfo.setResult(1);
            }
        }
        catch (Exception e) {
            throw new V5BusinessException("jls\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
        }
        return backgroundInfo;
    }

    public BackgroundInfo getInformationOnJailPersonnel(String idNumber) {
        logger.error("bjg\u4eba\u5458\u901a\u7528\u6570\u636e\u67e5\u8be2-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id = "C90-43000061";
        String service_id = "S-430000000000-0104-00404";
        String postURL = "http://10.142.247.70:8581/GatewayMsg/proxy/invoke";
        try {
            HuNanResponseInfo huNanResponseInfo = this.getResponseResult(sender_id, service_id, postURL, idNumber, false);
            if (StringUtils.isNotNull((Object)huNanResponseInfo.getHits()) && StringUtils.isNotNull((Object)huNanResponseInfo.getHits().getTotal()) && huNanResponseInfo.getHits().getTotal().getValue() != 0) {
                HashMap<String, Object> wfMap = new HashMap<String, Object>();
                wfMap.put("detail", "\u88ab\u76d1\u7ba1\u4eba\u5458");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("\u7701\u5385_\u76d1\u7ba1_\u88ab\u76d1\u7ba1\u4eba\u5458\u4fe1\u606f");
                backgroundInfo.setData(wfMap);
                backgroundInfo.setResult(1);
            }
        }
        catch (Exception e) {
            throw new V5BusinessException("bjg\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
        }
        return backgroundInfo;
    }

    public BackgroundInfo getInformationOnLargePersonnel(String idNumber) {
        logger.error("zt\u4eba\u5458\u4fe1\u606f\u901a\u7528\u6570\u636e\u67e5\u8be2-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id = "C90-43000061";
        String service_id = "S90-43000208";
        String postURL = "http://10.142.247.70:8581/GatewayMsg/proxy/invoke";
        try {
            HuNanResponseInfo huNanResponseInfo = this.getResponseResult(sender_id, service_id, postURL, idNumber, true);
            if (StringUtils.isNotNull((Object)huNanResponseInfo.getHits()) && StringUtils.isNotNull((Object)huNanResponseInfo.getHits().getTotal()) && huNanResponseInfo.getHits().getTotal().getValue() != 0) {
                HashMap<String, Object> wfMap = new HashMap<String, Object>();
                wfMap.put("detail", "\u5168\u56fd\u5728\u9003\u4eba\u5458");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("\u7701\u5385_\u5211\u4fa6_\u5168\u56fd\u5728\u9003\u4eba\u5458");
                backgroundInfo.setData(wfMap);
                backgroundInfo.setResult(1);
            }
        }
        catch (Exception e) {
            throw new V5BusinessException("zt\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
        }
        return backgroundInfo;
    }

    public BackgroundInfo getInformationOnOffendersPersonnel(String idNumber) {
        logger.error("wf\u4eba\u4fe1\u606f\u901a\u7528\u6570\u636e\u67e5\u8be2-----------------------------");
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String sender_id = "C90-43000061";
        String service_id = "S-430000000000-0104-00402";
        String postURL = "http://10.142.247.70:8581/GatewayMsg/proxy/invoke";
        try {
            HuNanResponseInfo huNanResponseInfo = this.getResponseResult(sender_id, service_id, postURL, idNumber, false);
            if (StringUtils.isNotNull((Object)huNanResponseInfo.getHits()) && StringUtils.isNotNull((Object)huNanResponseInfo.getHits().getTotal()) && huNanResponseInfo.getHits().getTotal().getValue() != 0) {
                HashMap<String, Object> wfMap = new HashMap<String, Object>();
                wfMap.put("detail", "\u8fdd\u6cd5\u884c\u4e3a\u4eba\u5458");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("\u7701\u5385_\u6cd5\u5236_\u6267\u6cd5\u529e\u6848\u8fdd\u6cd5\u884c\u4e3a\u4eba\u5458");
                backgroundInfo.setData(wfMap);
                backgroundInfo.setResult(1);
            }
        }
        catch (Exception e) {
            throw new V5BusinessException("wf\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
        }
        return backgroundInfo;
    }

    public static void main(String[] args) {
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String returnValue = "{\n    \"_shards\":{\n        \"total\":5,\n        \"failed\":0,\n        \"successful\":5,\n        \"skipped\":0\n    },\n    \"hits\":{\n        \"hits\":[\n\n        ],\n        \"total\":{\n            \"value\":3,\n            \"relation\":\"eq\"\n        },\n        \"max score\":12.2652025\n    },\n    \"took\":35,\n    \"timed out\":false\n}";
        try {
            HuNanResponseInfo huNanResponseInfo = (HuNanResponseInfo)JSONObject.parseObject((String)returnValue, HuNanResponseInfo.class);
            if (StringUtils.isNotNull((Object)huNanResponseInfo.getHits()) && StringUtils.isNotNull((Object)huNanResponseInfo.getHits().getTotal()) && huNanResponseInfo.getHits().getTotal().getValue() != 0) {
                HashMap<String, Object> wfMap = new HashMap<String, Object>();
                wfMap.put("detail", "\u8fdd\u6cd5\u884c\u4e3a\u4eba\u5458(\u5211\u4fa6)");
                backgroundInfo.setCode(200);
                backgroundInfo.setCxxt("\u6e56\u5357\u5211\u4fa6_\u8fdd\u6cd5\u884c\u4e3a\u4eba\u5458\u4fe1\u606f");
                backgroundInfo.setData(wfMap);
                backgroundInfo.setResult(1);
            }
        }
        catch (Exception e) {
            throw new V5BusinessException("\u8fdd\u6cd5\u884c\u4e3a\u4eba\u5458\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
        }
        System.out.println(backgroundInfo.toString());
    }
}

