/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.service.impl;

import com.bcxin.auth.common.annotation.DataScope;
import com.bcxin.auth.common.core.domain.entity.SysRole;
import com.bcxin.auth.common.core.domain.entity.SysUser;
import com.bcxin.auth.common.core.text.Convert;
import com.bcxin.auth.common.exception.BusinessException;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.utils.security.Md5Utils;
import com.bcxin.auth.system.domain.SysPost;
import com.bcxin.auth.system.domain.SysUserPost;
import com.bcxin.auth.system.domain.SysUserRole;
import com.bcxin.auth.system.mapper.SysPostMapper;
import com.bcxin.auth.system.mapper.SysRoleMapper;
import com.bcxin.auth.system.mapper.SysUserMapper;
import com.bcxin.auth.system.mapper.SysUserPostMapper;
import com.bcxin.auth.system.mapper.SysUserRoleMapper;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.service.ISysUserService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysUserServiceImpl
implements ISysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Autowired
    private SysUserMapper userMapper;
    @Autowired
    private SysRoleMapper roleMapper;
    @Autowired
    private SysPostMapper postMapper;
    @Autowired
    private SysUserPostMapper userPostMapper;
    @Autowired
    private SysUserRoleMapper userRoleMapper;
    @Autowired
    private ISysConfigService configService;

    @Override
    @DataScope(deptAlias="d", userAlias="u")
    public List<SysUser> selectUserList(SysUser user) {
        return this.userMapper.selectUserList(user);
    }

    @Override
    @DataScope(deptAlias="d", userAlias="u")
    public List<SysUser> selectAllocatedList(SysUser user) {
        return this.userMapper.selectAllocatedList(user);
    }

    @Override
    @DataScope(deptAlias="d", userAlias="u")
    public List<SysUser> selectUnallocatedList(SysUser user) {
        return this.userMapper.selectUnallocatedList(user);
    }

    @Override
    public SysUser selectUserByLoginName(String userName) {
        return this.userMapper.selectUserByLoginName(userName);
    }

    @Override
    public SysUser selectUserByPhoneNumber(String phoneNumber) {
        return this.userMapper.selectUserByPhoneNumber(phoneNumber);
    }

    @Override
    public SysUser selectUserByEmail(String email) {
        return this.userMapper.selectUserByEmail(email);
    }

    @Override
    public SysUser selectUserById(Long userId) {
        return this.userMapper.selectUserById(userId);
    }

    @Override
    public List<SysUserRole> selectUserRoleByUserId(Long userId) {
        return this.userRoleMapper.selectUserRoleByUserId(userId);
    }

    @Override
    @Transactional
    public int deleteUserById(Long userId) {
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.userPostMapper.deleteUserPostByUserId(userId);
        return this.userMapper.deleteUserById(userId);
    }

    @Override
    @Transactional
    public int deleteUserByIds(String ids) {
        Long[] userIds;
        for (Long userId : userIds = Convert.toLongArray((String)ids)) {
            this.checkUserAllowed(new SysUser(userId));
        }
        this.userRoleMapper.deleteUserRole(userIds);
        this.userPostMapper.deleteUserPost(userIds);
        return this.userMapper.deleteUserByIds(userIds);
    }

    @Override
    @Transactional
    public int insertUser(SysUser user) {
        int rows = this.userMapper.insertUser(user);
        this.insertUserPost(user);
        this.insertUserRole(user.getUserId(), user.getRoleIds());
        return rows;
    }

    @Override
    public boolean registerUser(SysUser user) {
        user.setUserType("01");
        return this.userMapper.insertUser(user) > 0;
    }

    @Override
    @Transactional
    public int updateUser(SysUser user) {
        Long userId = user.getUserId();
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(user.getUserId(), user.getRoleIds());
        this.userPostMapper.deleteUserPostByUserId(userId);
        this.insertUserPost(user);
        return this.userMapper.updateUser(user);
    }

    @Override
    public int updateUserInfo(SysUser user) {
        return this.userMapper.updateUser(user);
    }

    @Override
    public void insertUserAuth(Long userId, Long[] roleIds) {
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(userId, roleIds);
    }

    @Override
    public int resetUserPwd(SysUser user) {
        return this.updateUserInfo(user);
    }

    public void insertUserRole(Long userId, Long[] roleIds) {
        if (StringUtils.isNotNull((Object)roleIds)) {
            ArrayList<SysUserRole> list = new ArrayList<SysUserRole>();
            for (Long roleId : roleIds) {
                SysUserRole ur = new SysUserRole();
                ur.setUserId(userId);
                ur.setRoleId(roleId);
                list.add(ur);
            }
            if (list.size() > 0) {
                this.userRoleMapper.batchUserRole(list);
            }
        }
    }

    public void insertUserPost(SysUser user) {
        Long[] posts = user.getPostIds();
        if (StringUtils.isNotNull((Object)posts)) {
            ArrayList<SysUserPost> list = new ArrayList<SysUserPost>();
            for (Long postId : posts) {
                SysUserPost up = new SysUserPost();
                up.setUserId(user.getUserId());
                up.setPostId(postId);
                list.add(up);
            }
            if (list.size() > 0) {
                this.userPostMapper.batchUserPost(list);
            }
        }
    }

    @Override
    public String checkLoginNameUnique(String loginName) {
        int count = this.userMapper.checkLoginNameUnique(loginName);
        if (count > 0) {
            return "1";
        }
        return "0";
    }

    @Override
    public String checkPhoneUnique(SysUser user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkPhoneUnique(user.getPhonenumber());
        if (StringUtils.isNotNull((Object)info) && info.getUserId().longValue() != userId.longValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public String checkEmailUnique(SysUser user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkEmailUnique(user.getEmail());
        if (StringUtils.isNotNull((Object)info) && info.getUserId().longValue() != userId.longValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public void checkUserAllowed(SysUser user) {
        if (StringUtils.isNotNull((Object)user.getUserId()) && user.isAdmin()) {
            throw new BusinessException("\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8d85\u7ea7\u7ba1\u7406\u5458\u7528\u6237");
        }
    }

    @Override
    public String selectUserRoleGroup(Long userId) {
        List<SysRole> list = this.roleMapper.selectRolesByUserId(userId);
        StringBuffer idsStr = new StringBuffer();
        for (SysRole role : list) {
            idsStr.append(role.getRoleName()).append(",");
        }
        if (StringUtils.isNotEmpty((String)idsStr.toString())) {
            return idsStr.substring(0, idsStr.length() - 1);
        }
        return idsStr.toString();
    }

    @Override
    public String selectUserPostGroup(Long userId) {
        List<SysPost> list = this.postMapper.selectPostsByUserId(userId);
        StringBuffer idsStr = new StringBuffer();
        for (SysPost post : list) {
            idsStr.append(post.getPostName()).append(",");
        }
        if (StringUtils.isNotEmpty((String)idsStr.toString())) {
            return idsStr.substring(0, idsStr.length() - 1);
        }
        return idsStr.toString();
    }

    @Override
    public String importUser(List<SysUser> userList, Boolean isUpdateSupport, String operName) {
        if (StringUtils.isNull(userList) || userList.size() == 0) {
            throw new BusinessException("\u5bfc\u5165\u7528\u6237\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        String password = this.configService.selectConfigByKey("sys.user.initPassword");
        for (SysUser user : userList) {
            try {
                SysUser u = this.userMapper.selectUserByLoginName(user.getLoginName());
                if (StringUtils.isNull((Object)u)) {
                    user.setPassword(Md5Utils.hash((String)(user.getLoginName() + password)));
                    user.setCreateBy(operName);
                    this.insertUser(user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getLoginName() + " \u5bfc\u5165\u6210\u529f");
                    continue;
                }
                if (isUpdateSupport.booleanValue()) {
                    user.setUpdateBy(operName);
                    this.updateUser(user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getLoginName() + " \u66f4\u65b0\u6210\u529f");
                    continue;
                }
                failureMsg.append("<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getLoginName() + " \u5df2\u5b58\u5728");
            }
            catch (Exception e) {
                String msg = "<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getLoginName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                failureMsg.append(msg + e.getMessage());
                log.error(msg, (Throwable)e);
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "\u5f88\u62b1\u6b49\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u5171 " + failureNum + " \u6761\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u5982\u4e0b\uff1a");
            throw new BusinessException(failureMsg.toString());
        }
        successMsg.insert(0, "\u606d\u559c\u60a8\uff0c\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01\u5171 " + successNum + " \u6761\uff0c\u6570\u636e\u5982\u4e0b\uff1a");
        return successMsg.toString();
    }

    @Override
    public int changeStatus(SysUser user) {
        return this.userMapper.updateUser(user);
    }
}

