/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.service.impl;

import com.bcxin.auth.common.core.text.Convert;
import com.bcxin.auth.common.exception.BusinessException;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.SysPost;
import com.bcxin.auth.system.mapper.SysPostMapper;
import com.bcxin.auth.system.mapper.SysUserPostMapper;
import com.bcxin.auth.system.service.ISysPostService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysPostServiceImpl
implements ISysPostService {
    @Autowired
    private SysPostMapper postMapper;
    @Autowired
    private SysUserPostMapper userPostMapper;

    @Override
    public List<SysPost> selectPostList(SysPost post) {
        return this.postMapper.selectPostList(post);
    }

    @Override
    public List<SysPost> selectPostAll() {
        return this.postMapper.selectPostAll();
    }

    @Override
    public List<SysPost> selectPostsByUserId(Long userId) {
        List<SysPost> userPosts = this.postMapper.selectPostsByUserId(userId);
        List<SysPost> posts = this.postMapper.selectPostAll();
        block0: for (SysPost post : posts) {
            for (SysPost userRole : userPosts) {
                if (post.getPostId().longValue() != userRole.getPostId().longValue()) continue;
                post.setFlag(true);
                continue block0;
            }
        }
        return posts;
    }

    @Override
    public SysPost selectPostById(Long postId) {
        return this.postMapper.selectPostById(postId);
    }

    @Override
    public int deletePostByIds(String ids) throws BusinessException {
        Long[] postIds;
        for (Long postId : postIds = Convert.toLongArray((String)ids)) {
            SysPost post = this.selectPostById(postId);
            if (this.countUserPostById(postId) <= 0) continue;
            throw new BusinessException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", post.getPostName()));
        }
        return this.postMapper.deletePostByIds(postIds);
    }

    @Override
    public int insertPost(SysPost post) {
        return this.postMapper.insertPost(post);
    }

    @Override
    public int updatePost(SysPost post) {
        return this.postMapper.updatePost(post);
    }

    @Override
    public int countUserPostById(Long postId) {
        return this.userPostMapper.countUserPostById(postId);
    }

    @Override
    public String checkPostNameUnique(SysPost post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        SysPost info = this.postMapper.checkPostNameUnique(post.getPostName());
        if (StringUtils.isNotNull((Object)((Object)info)) && info.getPostId().longValue() != postId.longValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public String checkPostCodeUnique(SysPost post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        SysPost info = this.postMapper.checkPostCodeUnique(post.getPostCode());
        if (StringUtils.isNotNull((Object)((Object)info)) && info.getPostId().longValue() != postId.longValue()) {
            return "1";
        }
        return "0";
    }
}

