/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.service.impl;

import com.bcxin.auth.common.core.domain.entity.SysDictData;
import com.bcxin.auth.common.core.text.Convert;
import com.bcxin.auth.common.utils.DictUtils;
import com.bcxin.auth.system.mapper.SysDictDataMapper;
import com.bcxin.auth.system.service.ISysDictDataService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysDictDataServiceImpl
implements ISysDictDataService {
    @Autowired
    private SysDictDataMapper dictDataMapper;

    @Override
    public List<SysDictData> selectDictDataList(SysDictData dictData) {
        return this.dictDataMapper.selectDictDataList(dictData);
    }

    @Override
    public String selectDictLabel(String dictType, String dictValue) {
        return this.dictDataMapper.selectDictLabel(dictType, dictValue);
    }

    @Override
    public SysDictData selectDictDataById(Long dictCode) {
        return this.dictDataMapper.selectDictDataById(dictCode);
    }

    @Override
    public int deleteDictDataByIds(String ids) {
        int row = this.dictDataMapper.deleteDictDataByIds(Convert.toStrArray((String)ids));
        if (row > 0) {
            DictUtils.clearDictCache();
        }
        return row;
    }

    @Override
    public int insertDictData(SysDictData dictData) {
        int row = this.dictDataMapper.insertDictData(dictData);
        if (row > 0) {
            DictUtils.clearDictCache();
        }
        return row;
    }

    @Override
    public int updateDictData(SysDictData dictData) {
        int row = this.dictDataMapper.updateDictData(dictData);
        if (row > 0) {
            DictUtils.clearDictCache();
        }
        return row;
    }
}

