/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.service.impl;

import com.bcxin.auth.common.annotation.DataScope;
import com.bcxin.auth.common.core.domain.Ztree;
import com.bcxin.auth.common.core.domain.entity.SysDept;
import com.bcxin.auth.common.core.domain.entity.SysRole;
import com.bcxin.auth.common.exception.BusinessException;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.mapper.SysDeptMapper;
import com.bcxin.auth.system.service.ISysDeptService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysDeptServiceImpl
implements ISysDeptService {
    @Autowired
    private SysDeptMapper deptMapper;

    @Override
    @DataScope(deptAlias="d")
    public List<SysDept> selectDeptList(SysDept dept) {
        return this.deptMapper.selectDeptList(dept);
    }

    @Override
    @DataScope(deptAlias="d")
    public List<Ztree> selectDeptTree(SysDept dept) {
        List<SysDept> deptList = this.deptMapper.selectDeptList(dept);
        List<Ztree> ztrees = this.initZtree(deptList);
        return ztrees;
    }

    @Override
    @DataScope(deptAlias="d")
    public List<Ztree> selectDeptTreeExcludeChild(SysDept dept) {
        Long deptId = dept.getDeptId();
        List<SysDept> deptList = this.deptMapper.selectDeptList(dept);
        Iterator<SysDept> it = deptList.iterator();
        while (it.hasNext()) {
            SysDept d = it.next();
            if ((long)d.getDeptId().intValue() != deptId && !ArrayUtils.contains((Object[])StringUtils.split((String)d.getAncestors(), (String)","), (Object)(deptId + ""))) continue;
            it.remove();
        }
        List<Ztree> ztrees = this.initZtree(deptList);
        return ztrees;
    }

    @Override
    public List<Ztree> roleDeptTreeData(SysRole role) {
        Long roleId = role.getRoleId();
        List<Object> ztrees = new ArrayList();
        List<SysDept> deptList = this.selectDeptList(new SysDept());
        if (StringUtils.isNotNull((Object)roleId)) {
            List<String> roleDeptList = this.deptMapper.selectRoleDeptTree(roleId);
            ztrees = this.initZtree(deptList, roleDeptList);
        } else {
            ztrees = this.initZtree(deptList);
        }
        return ztrees;
    }

    public List<Ztree> initZtree(List<SysDept> deptList) {
        return this.initZtree(deptList, null);
    }

    public List<Ztree> initZtree(List<SysDept> deptList, List<String> roleDeptList) {
        ArrayList<Ztree> ztrees = new ArrayList<Ztree>();
        boolean isCheck = StringUtils.isNotNull(roleDeptList);
        for (SysDept dept : deptList) {
            if (!"0".equals(dept.getStatus())) continue;
            Ztree ztree = new Ztree();
            ztree.setId(dept.getDeptId());
            ztree.setpId(dept.getParentId());
            ztree.setName(dept.getDeptName());
            ztree.setTitle(dept.getDeptName());
            if (isCheck) {
                ztree.setChecked(roleDeptList.contains(dept.getDeptId() + dept.getDeptName()));
            }
            ztrees.add(ztree);
        }
        return ztrees;
    }

    @Override
    public int selectDeptCount(Long parentId) {
        SysDept dept = new SysDept();
        dept.setParentId(parentId);
        return this.deptMapper.selectDeptCount(dept);
    }

    @Override
    public boolean checkDeptExistUser(Long deptId) {
        int result = this.deptMapper.checkDeptExistUser(deptId);
        return result > 0;
    }

    @Override
    public int deleteDeptById(Long deptId) {
        return this.deptMapper.deleteDeptById(deptId);
    }

    @Override
    public int insertDept(SysDept dept) {
        SysDept info = this.deptMapper.selectDeptById(dept.getParentId());
        if (!"0".equals(info.getStatus())) {
            throw new BusinessException("\u90e8\u95e8\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        dept.setAncestors(info.getAncestors() + "," + dept.getParentId());
        return this.deptMapper.insertDept(dept);
    }

    @Override
    @Transactional
    public int updateDept(SysDept dept) {
        SysDept newParentDept = this.deptMapper.selectDeptById(dept.getParentId());
        SysDept oldDept = this.selectDeptById(dept.getDeptId());
        if (StringUtils.isNotNull((Object)newParentDept) && StringUtils.isNotNull((Object)oldDept)) {
            String newAncestors = newParentDept.getAncestors() + "," + newParentDept.getDeptId();
            String oldAncestors = oldDept.getAncestors();
            dept.setAncestors(newAncestors);
            this.updateDeptChildren(dept.getDeptId(), newAncestors, oldAncestors);
        }
        int result = this.deptMapper.updateDept(dept);
        if ("0".equals(dept.getStatus())) {
            this.updateParentDeptStatus(dept);
        }
        return result;
    }

    private void updateParentDeptStatus(SysDept dept) {
        String updateBy = dept.getUpdateBy();
        dept = this.deptMapper.selectDeptById(dept.getDeptId());
        dept.setUpdateBy(updateBy);
        this.deptMapper.updateDeptStatus(dept);
    }

    public void updateDeptChildren(Long deptId, String newAncestors, String oldAncestors) {
        List<SysDept> children = this.deptMapper.selectChildrenDeptById(deptId);
        for (SysDept child : children) {
            child.setAncestors(child.getAncestors().replace(oldAncestors, newAncestors));
        }
        if (children.size() > 0) {
            this.deptMapper.updateDeptChildren(children);
        }
    }

    @Override
    public SysDept selectDeptById(Long deptId) {
        return this.deptMapper.selectDeptById(deptId);
    }

    @Override
    public int selectNormalChildrenDeptById(Long deptId) {
        return this.deptMapper.selectNormalChildrenDeptById(deptId);
    }

    @Override
    public String checkDeptNameUnique(SysDept dept) {
        Long deptId = StringUtils.isNull((Object)dept.getDeptId()) ? -1L : dept.getDeptId();
        SysDept info = this.deptMapper.checkDeptNameUnique(dept.getDeptName(), dept.getParentId());
        if (StringUtils.isNotNull((Object)info) && info.getDeptId().longValue() != deptId.longValue()) {
            return "1";
        }
        return "0";
    }
}

