/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.schedule;

import com.bcxin.auth.system.domain.DataSyncLog;
import com.bcxin.auth.system.mapper.DataSyncLogMapper;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.auth.system.util.DataSyncInterfaceUtil;
import com.bcxin.obpm.dto.AuthAjaxResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dataSyncFtpTask")
public class DataSyncFtpTask {
    private static Logger logger = LoggerFactory.getLogger(DataSyncFtpTask.class);
    @Autowired
    ISysConfigService configService;
    @Autowired
    ConfigUtil configUtil;
    @Autowired
    DataSyncLogMapper dataSyncLogMapper;
    @Autowired
    DataSyncInterfaceUtil dataSyncInterfaceUtil;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            List<DataSyncLog> dataSyncLogList;
            if (this.configUtil.isIntranet() && (dataSyncLogList = this.dataSyncLogMapper.findUnDataSyncList()).size() > 0) {
                Object dataSyncDto = null;
                AuthAjaxResult result = null;
                ArrayList<DataSyncLog> saveList = new ArrayList<DataSyncLog>();
                for (DataSyncLog dataSyncLog : dataSyncLogList) {
                    try {
                        result = this.dataSyncInterfaceUtil.callInterface("/ftp/file/trans", dataSyncLog);
                        if (result.isSuccessful()) {
                            dataSyncLog.setMsgId(result.getData().toString());
                            dataSyncLog.setDataSyncState("1");
                            dataSyncLog.setErrorInfo("");
                        } else {
                            dataSyncLog.setErrorInfo(result.getMsg());
                            if (dataSyncLog.getErrorInfo().length() > 400) {
                                dataSyncLog.setErrorInfo(dataSyncLog.getErrorInfo().substring(0, 400));
                            }
                        }
                        dataSyncLog.setUpdateTime(new Date());
                        saveList.add(dataSyncLog);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (saveList.size() > 0) {
                    this.dataSyncLogMapper.saveBatch(saveList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        finally {
            this.lock = false;
        }
    }
}

