package com.bcxin.obpm.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.utils.DES3;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.IdWorker;
import com.bcxin.auth.common.utils.file.FileUtils;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.mapper.TenantUserMapper;
import com.bcxin.obpm.service.ITenantUserService;
import com.bcxin.obpm.util.AuthConstants;
import com.bcxin.obpm.util.ComInterfaceUtil;
import com.bcxin.obpm.util.JwtUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * v5保安员Service业务层处理
 * 
 * @author lin
 * @date 2021-06-06
 */
@Service
@Transactional
public class TenantUserServiceImpl implements ITenantUserService {

    private static Logger logger = LoggerFactory.getLogger(TenantUserServiceImpl.class);

    @Autowired
    ConfigUtil configUtil;

    @Autowired
    IdWorker idWorker;

    @Autowired
    private TenantUserMapper tenantUserMapper;

    @Resource
    private ComInterfaceUtil comInterfaceUtil;

    @Override
    public int updateAuthStatus(AuthLog authLog) {
        return tenantUserMapper.updateAuthStatus(authLog);
    }

    @Override
    public List<AuthLog> queryUnAuth(String idNumber) {
        List<AuthLog> list = tenantUserMapper.queryUnAuth(idNumber,configUtil.isGSDB());
        for (AuthLog dbAuthLog : list) {
            if(StrUtil.isNotEmpty(dbAuthLog.getImgPath())) {
                dbAuthLog.setImgPath(dbAuthLog.getImgPath().replace("\\\"", "\""));
            }
        }
        return list;
    }

    @Override
    public void updateBatchAuthStatus(List<AuthLog> list) {
        if (configUtil.isGSDB()){
            tenantUserMapper.updateBatchAuthStatusForGS(list);
        }else {
            tenantUserMapper.updateBatchAuthStatus(list);
        }
        if (configUtil.isPolice() && !configUtil.isIntranet()){
            Map<String,Object> paramMap = new HashMap<>();
            paramMap.put("authList", JwtUtil.createJwt(JSON.toJSONString(list)));
            comInterfaceUtil.callInterface(AuthConstants.COM_DS_URL_AUTH,paramMap);
        }
    }

    @Override
    public void updateBatchAuthStatusToCom(List<AuthLog> list) {
        if (configUtil.isPolice() && !configUtil.isIntranet()){
            Map<String,Object> paramMap = new HashMap<>();
            paramMap.put("authList", JwtUtil.createJwt(JSON.toJSONString(list)));
            comInterfaceUtil.callInterface(AuthConstants.COM_DS_URL_AUTH,paramMap);
        }
    }

    @Override
    public void updateBatch(List<AuthLog> list) {
        tenantUserMapper.updateBatchAuthStatus(list);
    }

    @Override
    public List<AuthLog> selectList(AuthLog authLog) {
        List<AuthLog> list = tenantUserMapper.selectList(authLog);
        for (AuthLog dbAuthLog : list) {
            if(StrUtil.isNotEmpty(dbAuthLog.getImgPath())) {
                dbAuthLog.setImgPath(dbAuthLog.getImgPath().replace("\\\"", "\""));
            }
        }
        return list;
    }

    @Override
    public void dataSyncFile(AuthLog authLog) throws Exception {
        List<AuthLog> logList = tenantUserMapper.findAuthList(authLog);

        if(logList.size() > 0) {
            //TODO 生成同步摆渡文件
            try {
                //将数据转成json字符串并加密
                String content = DES3.encode(JSON.toJSONStringWithDateFormat(logList, DateUtils.YYYY_MM_DD_HH_MM_SS, SerializerFeature.WriteMapNullValue));
                //保存到txt文件中
                String fileName = "AuthLog_" + DateUtils.dateTimeNow(DateUtils.HHMMSS) + "_" + idWorker.nextId();
                String filepath = FileUtils.writeTxtFile(content, fileName, BMSConfig.getTempPath());

                String zipPath = BMSConfig.getDataSyncProfile() + DateUtils.getDate() + File.separator;
                File file = new File(zipPath);

                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }

                if (!file.exists()) {
                    file.mkdirs();
                }

                zipPath = zipPath + fileName + ".zip";
                FileUtils.zipFile(filepath, zipPath);
                FileUtils.deleteFile(filepath);
            } catch (Exception e) {
                e.printStackTrace();
                logger.error("生成同步文件异常：{}", e);
                throw e;
            }
        }
    }
}
