package com.bcxin.obpm.service.impl;


import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;

import com.alibaba.fastjson.JSON;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.SysInterfaceLog;
import com.bcxin.auth.system.mapper.SysInterfaceLogMapper;
import com.bcxin.obpm.dto.*;

import com.bcxin.obpm.mapper.ObpmSecurityManMapper;
import com.bcxin.obpm.service.BackgroundService;

import com.bcxin.obpm.service.IObpmSecurityManService;
import com.bcxin.obpm.util.AuthConstants;
import com.bcxin.obpm.util.FaceUtil;
import com.dragonsoft.node.adapter.comm.RbspCall;
import com.dragonsoft.node.adapter.comm.RbspConsts;
import com.dragonsoft.node.adapter.comm.RbspService;
import com.github.pagehelper.util.StringUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 宁夏
 * @author linqinglin
 * @date 2021/08/19 0019 10:25
 */

@Service("backgroundService_640000")
public class NXBackgroundServiceImpl implements BackgroundService {

    private static Logger logger = LoggerFactory.getLogger(NXBackgroundServiceImpl.class);


    @Autowired
    private FaceUtil faceUtil;

    @Autowired
    private ObpmSecurityManMapper obpmSecurityManMapper;

    @Autowired
    private SysInterfaceLogMapper sysInterfaceLogMapper;

    /**
     *
     */
    private final String ZAURL = "http://10.196.11.94:8585/node";


    @Override
    public AjaxResult personnelReview(String idNumber, String realName) {
        if (StringUtils.isEmpty(idNumber)) {
            return AjaxResult.error("参数不正确");
        }
        List<BackgroundInfo> backgroundInfoList = new ArrayList<>();
        BackgroundResult backgroundResult = new BackgroundResult();
        checkPersonInfo(backgroundInfoList, idNumber, realName);
        backgroundResult.setIdNumber(idNumber);
        backgroundResult.setCensorResult(backgroundInfoList);
        logger.error("身份证{}筛查结果:{}", idNumber, backgroundResult);
        // 请求
        return AjaxResult.success("请求成功", backgroundResult);
    }


    private void checkPersonInfo(List<BackgroundInfo> list, String idNumber, String name) {
        BackgroundInfo backgroundInfo = new BackgroundInfo();
        String wfStr = StringUtils.EMPTY;
        // 吸毒
        try {
            boolean xdResult = send(idNumber, name, Constants.NX_XD_REQUESTID, Constants.NX_XD_SERVICEID);
            if (xdResult) {
                wfStr += "吸毒人员,";
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
        // 在逃
        try {
            boolean ztResult = send(idNumber, name, Constants.NX_DT_REQUESTID, Constants.NX_DT_SERVICEID);
            if (ztResult) {
                wfStr += "在逃人员,";
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
        // 犯罪
        try {
            boolean wfResult = send(idNumber, name, Constants.NX_WF_REQUESTID, Constants.NX_WF_SERVICEID);
            if (wfResult) {
                wfStr += "有违法犯罪记录,";
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
        Map<String, Object> wfMap = new HashMap<>();
        if (!wfStr.isEmpty()) {
            wfStr = wfStr.substring(0, wfStr.length() - 1);
            wfMap.put("detail", wfStr);
            backgroundInfo.setCode(200);
            backgroundInfo.setData(wfMap);
            backgroundInfo.setResult(1);
            backgroundInfo.setCxxt("宁夏四大库接口");
            list.add(backgroundInfo);
        }
    }

    /***
     * 请求四大库
     * @param idNumber 身份证号
     * @param requestID 请求ID
     * @param serviceID 服务ID
     */
    private boolean send(String idNumber, String name, String requestID, String serviceID) {

        String DataObjectCode = Constants.NX_ZDRY_DataObjectCode;
        String InfoCodeMode = "002";
        SysInterfaceLog interfaceLog=new SysInterfaceLog();
        //执行返回的编码
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(ZAURL);
        interfaceLog.setParameters("请求核查库接口："+idNumber+":"+serviceID);
        String code = "";
        //结果返回
        boolean result = false;
        int errorCount = 0;
        //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
        for (int i = 0; i < Constants.ZAFLAG_COUNT; i++) {
            String requestResult = send(idNumber, requestID, serviceID, new String[]{Constants.INFO_XM}
                    , DataObjectCode, InfoCodeMode, "SFZH");
            //如果不为空则没有数据
            if (requestResult != null && !requestResult.equals("")) {
                try {
                    SAXReader reader = new SAXReader();
                    Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes("UTF-8")));
                    Element root = doc.getRootElement();
                    Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                    //valueElement节点为空的话，请求人口库异常
                    if (valueElement != null) {
                        List<Element> list = valueElement.elements();
                        //获取执行返回编码
                        if (list != null && list.size() > 0) {
                            Element e = list.get(0);
                            code = e.element("Data").getText();
                        }
                        //获取查询结果
                        if (list != null && list.size() > 2) {
                            Element e = list.get(2);
                            String resultname = e.element("Data").getText();
                            if (resultname != null && resultname.equals(name)) {
                                result = true;
                            } else {
                                result = false;
                            }
                            interfaceLog.setResult(resultname);
                            interfaceLog.setUpdateTime(new Date());
                            interfaceLog.setSuccessful(true);
                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    e.printStackTrace();
                    errorCount++;
                }
            }else {
                errorCount++;
            }
            //如果执行成功则返回
            if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                new Thread(()->{
                    sysInterfaceLogMapper.insert(interfaceLog);
                }).start();
                break;
            }
            if (errorCount == 3) {
                interfaceLog.setResult("请求核查库接口异常！！！");
                interfaceLog.setUpdateTime(new Date());
                interfaceLog.setSuccessful(false);
                new Thread(()->{
                    sysInterfaceLogMapper.insert(interfaceLog);
                }).start();
            }
        }
        return result;
    }

    @Override
    public AjaxResult getPersonnelInformation(String idNumber) {
        if (StringUtils.isEmpty(idNumber)) {
            return AjaxResult.error("参数不正确");
        }

        AuthenticationResult authenticationResult = new AuthenticationResult();
        authenticationResult.setIdNumber(idNumber);
        try {
            PerPhotoDto perPhotoDto = getPopulationInfo(idNumber, true);
            authenticationResult.setPhoto(perPhotoDto.getPhoto());
            authenticationResult.setRealName(perPhotoDto.getName());
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new V5BusinessException("北京人员基本信息接口调用异常！！");

        }

        logger.info("{}人员信息服务返回:{}", idNumber, authenticationResult);
        return AjaxResult.success("请求成功", authenticationResult);
    }


    private PerPhotoDto getPopulationInfo(String idNumber, boolean needPhoto) {
        PerPhotoDto person = new PerPhotoDto();
        SysInterfaceLog interfaceLog=new SysInterfaceLog();
        String code = "";
        int errorCount = 0;

        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(ZAURL);
        interfaceLog.setParameters("常驻人口基本信息查询"+idNumber+":"+Constants.NX_CZ_SERVICEID_INFO);
        //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
        for (int i = 0; i < Constants.ZAFLAG_COUNT; i++) {
            //数据保留7天
            //redisUtil.getCount(key, 7L);
            String requestResult = send(idNumber, Constants.NX_CZ_REQUESTID, Constants.NX_CZ_SERVICEID_INFO,
                    new String[]{Constants.INFO_XM, Constants.INFO_JGSSX, Constants.INFO_ZZ,Constants.INFO_ZXBS},
                    Constants.NX_CZINFO_DataObjectCode, "002", "GMSFHM");
            logger.error(idNumber + "：获取四大库人员信息" + requestResult);
            //如果不为空则没有数据
            if (requestResult != null && !requestResult.equals("")) {
                try {
                    String pattern = "\\s{2,}";
                    Pattern r = Pattern.compile(pattern);
                    Matcher m = r.matcher(requestResult);
                    requestResult = m.replaceAll("");
                    SAXReader reader = new SAXReader();
                    Document doc = reader.read(new ByteArrayInputStream(requestResult.getBytes(Constants.UTF8)));
                    Element root = doc.getRootElement();
                    Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                    if (valueElement != null) {
                        List<Element> list = valueElement.elements();
                        //获取执行返回编码
                        if (list != null && list.size() > 0) {
                            Element e = list.get(0);
                            code = e.element("Data").getText();
                        }
                        //获取返回值
                        if (list != null && list.size() > 2) {
                            for (int x=2;x<list.size();x++){
                                Element e = list.get(x);
                                String isDelete=((DefaultElement) e.content().get(3)).getText();
                                if (isDelete.equals("0")){
                                    person.setName(((DefaultElement) e.content().get(0)).getText());
                                    person.setPopulationaddress(((DefaultElement) e.content().get(2)).getText());
                                    if (needPhoto) {
                                        person.setPhoto((getPhoto(idNumber, person.getName())));
                                    }
                                }
                            }

                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    //异常次数加1
                    errorCount++;
                }
            } else {
                logger.error("人口库获取异常,没有返回值,身份证号：" + idNumber);
                //异常次数加1
                errorCount++;
            }
            //如果执行成功则返回
            if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                interfaceLog.setResult(idNumber+":"+person.getName()+":"+person.getPopulationaddress());
                interfaceLog.setUpdateTime(new Date());
                interfaceLog.setSuccessful(true);
                new Thread(()->{
                    sysInterfaceLogMapper.insert(interfaceLog);
                }).start();
                break;
            }
            if (errorCount == 3) {
                interfaceLog.setResult("获取四大库常驻人口基本信息异常!!");
                interfaceLog.setUpdateTime(new Date());
                interfaceLog.setSuccessful(false);
                new Thread(()->{
                    sysInterfaceLogMapper.insert(interfaceLog);
                }).start();
                throw new V5BusinessException("获取四大库人员信息调用异常！！");
            }
        }

        return person;
    }

    private String getPhoto(String idNumber, String name) {
        String strResult = "";
        String code = "";
        int errorCount = 0;
        SysInterfaceLog interfaceLog=new SysInterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(ZAURL);
        interfaceLog.setParameters("常住人口库照片数据查询"+idNumber+":"+Constants.NX_CZ_SERVICEID_PHOTO);
        //人口库调用会异常或超时，循环三次，三次还是异常或超时，则获取失败
        for (int i = 0; i < 3; i++) {
            String result = send(idNumber, Constants.NX_CZ_REQUESTID, Constants.NX_CZ_SERVICEID_PHOTO,
                    new String[]{Constants.INFO_XP}, Constants.NX_CZPHOTO_DataObjectCode, "001",
                    "GMSFHM");
            //logger.error("身份证："+idNumber+",获取人口库照片返回结果：" + result);
            if (StringUtil.isNotEmpty(result)) {
                try {
                    SAXReader reader = new SAXReader();
                    org.dom4j.Document doc = reader.read(new ByteArrayInputStream(result.getBytes(Constants.UTF8)));
                    Element root = doc.getRootElement();
                    Element valueElement = root.element("Method").element("Items").element("Item").element("Value");
                    if (valueElement != null) {
                        List<Element> list = valueElement.elements();
                        //获取执行返回编码
                        if (list != null && list.size() > 0) {
                            Element e = list.get(0);
                            code = e.element("Data").getText();
                        }
                        if (list != null && list.size() > 2) {
                            Element e = list.get(2);
                            strResult = e.element("Data").getText();
                        }
                    } else {
                        //异常次数加1
                        errorCount++;
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    //异常次数加1
                    errorCount++;
                }
            } else {
                logger.error("人口库获取照片异常,没有返回值,身份证号：" + idNumber);
                //异常次数加1
                errorCount++;
            }
            //如果执行成功则返回
            if (Constants.ZAFLAG_CODE_SUCCESS.equals(code)) {
                interfaceLog.setResult("照片长度："+strResult.length());
                interfaceLog.setUpdateTime(new Date());
                interfaceLog.setSuccessful(true);
                new Thread(()->{
                    sysInterfaceLogMapper.insert(interfaceLog);
                }).start();
                break;
            }
        }
        if (errorCount == 3) {
            interfaceLog.setResult("获取人口库照片接口调用异常！！");
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(false);
            new Thread(()->{
                sysInterfaceLogMapper.insert(interfaceLog);
            }).start();
            throw new V5BusinessException("获取人口库照片接口调用异常！！");
        }

        return strResult;
    }

    /***
     * 请求四大库 获取基本信息，图片
     * @param idNumber 身份证号
     * @param requestID 请求ID
     * @param serviceID 服务ID
     * @param requiredItems 返回结果集
     */
    private String send(String idNumber, String requestID, String serviceID, String[] requiredItems,
                        String DataObjectCode, String InfoCodeMode, String idType) {
        //结果返回
        String result = StringUtils.EMPTY;

        Boolean isSuccessful = true;
        RbspService service = new RbspService(requestID, serviceID);
        //用户信息
        service.setUserCardId("asdfasd");
        service.setUserDept("0100");
        service.setUserName("ptjian");
        RbspCall call = service.createCall();
        call.setUrl(ZAURL);
        call.setMethod(RbspConsts.METHOD_QUERY);
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("DataObjectCode", DataObjectCode);
        params.put("InfoCodeMode", InfoCodeMode);
        //按身份证号查
        params.put("Condition", idType + "= '" + idNumber.toUpperCase() + "'");
        //返回字段：
        params.put("RequiredItems", requiredItems);

        logger.error("请求地址：{}", ZAURL);
        logger.error("请求参数：{}", JSON.toJSONString(params));
        result = call.invoke(params);
        logger.error("返回结果：{}", result);
        return result;
    }

    @Override
    public List<AuthLog> validateResult(List<AuthLog> list) {
        for (AuthLog authLog : list) {
            try {
                this.matchResult(authLog);
                authLog.setAuthDate(DateUtils.getNowDate());
            } catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), e);
            } finally {
            }
        }
        return list.stream().filter(((authLog) -> StrUtil.isNotEmpty(authLog.getAuthStatus()))).collect(Collectors.toList());
    }

    @Override
    public void getPersonnelAddress(String idNumber) {
        PerPhotoDto person = getPopulationInfo(idNumber, false);
        String address=person.getPopulationaddress();
        if (StrUtil.isNotEmpty(address)) {
            AuthLog authLog=new AuthLog();
            authLog.setIdNumber(idNumber);
            authLog.setAddress(address);
            authLog.setAuthDate(DateUtils.getNowDate());
            obpmSecurityManMapper.updatePopulationAddress(authLog);
        }
    }

    /**
     * 实名认证比对
     *
     * @param authLog
     * @throws IOException
     */
    public void matchResult(AuthLog authLog) throws IOException {
        try {
            /***2.2 获取人口库照片，base64，如果是互联网则获取本地图片，以身份证命名******/
            PerPhotoDto person = getPopulationInfo(authLog.getIdNumber(), true);
            String xp = "";
            /**
             *  获取人口库地址
             */
            String address=person.getPopulationaddress();
            if (StrUtil.isNotEmpty(address)) {
                authLog.setAddress(address);
            }

            /**
             *  2.2.1获取姓名
             */
            String name = person.getName();
            /**
             * 2.2.2 判断姓名是否为空，如果为空，则人口库没有信息
             */
            if (StrUtil.isEmpty(name)) {
                //姓名和身份证不匹配
                authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_CARD_IDEMSG);
            } else if (name.equals(authLog.getSecurityName())) {
                /**
                 * 2.2.3 匹配姓名是否正常，如果匹配则获取照片信息，不匹配则返回
                 */
                //获取人口库照片
                xp = person.getPhoto();
                /***2.2.4 没有照片代码身份证和姓名不匹配**/
                if (StrUtil.isEmpty(xp)) {
                    authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                    authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_PHOTO_IDEMSG);
                }
            } else {
                /***
                 * 2.2.4 姓名和身份证不匹配
                 */
                authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_NAME_IDEMSG);
            }

            /***
             * 2.3 如果有照片进行对比
             */
            if (StrUtil.isNotEmpty(xp)) {
                /***2.4 人口库和认证头像比对 **/
                if (xp.trim().startsWith("http")) {
                    logger.error("在线地址转base64");
                    String suffix = ".jpg";
                    if (!xp.matches(".*access_token.*")) {
                        suffix = xp.substring(xp.lastIndexOf("."));
                    }
                    String filePath = BMSConfig.getTempPath() + UUID.randomUUID().toString() + suffix;
                    faceUtil.downloadFile(xp, filePath);
                    xp = faceUtil.ImageToBase64(filePath);
                    FileUtil.del(filePath);
                }

                if (faceUtil.matchResult(xp, faceUtil.ImageToBase64(authLog.getImgPath()))) {
                    authLog.setAuthStatus(AuthConstants.AUTHRESULT_YES);
                    authLog.setAuthResult(AuthConstants.AUTHRESULT_YES_MESSAGE);
                } else {
                    authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                    authLog.setAuthResult(AuthConstants.AUTHRESULT_NO_IMGMSG);
                }
            }
            authLog.setAuthDate(DateUtils.getNowDate());
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
        }

    }

    public static void main(String[] args) {
        String x="http://v5qy.baibaodun.cn/static/signon/fronts/#/register?number=GotH0zyjCmMmrUtqoUf--__RCOcXGrkJRC4HyyXmrG";

        System.out.println(x.length());
    }

}
