package com.bcxin.obpm.service.impl;

import com.bcxin.auth.common.utils.bean.BeanUtils;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import com.bcxin.obpm.domain.MinisterialLog;
import com.bcxin.obpm.dto.Ministerial.DataSynchronizationSearchDto;
import com.bcxin.obpm.dto.Ministerial.MinisterialDataType;
import com.bcxin.obpm.mapper.MinisterialLogMapper;
import com.bcxin.obpm.service.MinisterialLogService;
import com.bcxin.obpm.util.DateUtil;
import com.github.pagehelper.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据上报部级接口记录Service业务层处理
 *
 * @author linqinglin
 * @date 2021-03-04
 */
@Service
@Transactional
public class MinisterialLogServiceImpl implements MinisterialLogService {

    /**
     * 日志对象
     */
    protected Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private MinisterialLogMapper ministerialLogDao;


    @Autowired
    private ConfigUtil configUtils;

    @Autowired
    private ISysConfigService configService;




    @Override
    public int delete(MinisterialLog ministerialLog) {

        ministerialLog.setUpdateTime(new Date());
        return ministerialLogDao.delete(ministerialLog);
    }

    @Override
    public int save(MinisterialLog ministerialLog) {
        if(ministerialLog.getId() == null){
            ministerialLog.setCreateTime(new Date());
        }else{
            MinisterialLog dbMinisterialLog = ministerialLogDao.findById(ministerialLog.getId());
            BeanUtils.copyPropertiesIgnore(ministerialLog,dbMinisterialLog,true);
            BeanUtils.copyPropertiesIgnore(dbMinisterialLog,ministerialLog,false);
        }

        ministerialLog.setActive(true);
        ministerialLog.setUpdateTime(new Date());
        return ministerialLogDao.save(ministerialLog);
    }

    @Override
    public MinisterialLog findById(Long id) {
        return ministerialLogDao.findById(id);
    }

    @Override
    public MinisterialLog find(MinisterialLog ministerialLog) {
        return ministerialLogDao.find(ministerialLog);
    }

    @Override
    public void importBatch(List<MinisterialLog> list) {
        List<MinisterialLog> dbList = ministerialLogDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (MinisterialLog ministerialLog : list) {
                try {
                    if(!configUtils.isIntranet()){
                        ministerialLog.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, ministerialLog.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ministerialLogDao.saveBatch(list);
        }
    }

    @Override
    public List<MinisterialLog> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return ministerialLogDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<MinisterialLog> findDSOutList(String startDate) {
        return ministerialLogDao.findDSOutList(startDate);
    }

    @Override
    public List<MinisterialLog> findByBatchId(List<MinisterialLog> list) {
        return ministerialLogDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(MinisterialLog ministerialLog) {
        ministerialLog.setUpdateTime(new Date());
        ministerialLogDao.updateSelective(ministerialLog);
    }

    @Override
    public List<Map> getBusinessDatas(MinisterialDataType dataType, int limit){
        Class entityClass = dataType.getDataClazz();
        if(!entityClass.isAnnotationPresent(MinisterialEntity.class)){
            return null;
        }
        MinisterialEntity entityAnno = (MinisterialEntity)entityClass.getAnnotation(MinisterialEntity.class);
        String tableName = entityAnno.tableName();
        String extraWhere = entityAnno.extraWhere();

        StringBuilder tableColumns = new StringBuilder();
        Field[] fields = entityClass.getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(MinisterialAttr.class)) {
                MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                if (StringUtil.isNotEmpty(resource.DATE_FORMAT())){
                    if (resource.isSubQuery()){
                        tableColumns
                                .append("DATE_FORMAT( ")
                                .append(resource.column())
                                .append(",'")
                                .append(resource.DATE_FORMAT())
                                .append("') as ")
                                .append(field.getName())
                                .append(",");
                    }else {
                        tableColumns
                                .append("DATE_FORMAT( t1.")
                                .append(resource.column())
                                .append(",'")
                                .append(resource.DATE_FORMAT())
                                .append("') as ")
                                .append(field.getName())
                                .append(",");
                    }

                } else {
                    // 子查询就不加t1了
                    if (!resource.isSubQuery()) {
                        tableColumns
                                .append(" t1.");
                    }
                    tableColumns
                            .append(resource.column())
                            .append(" as ")
                            .append(field.getName())
                            .append(",");
                }
            }
        }
        String columns = tableColumns.toString();
        columns = columns.substring(0, columns.length() - 1);

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("dataType",dataType.getCode());
        paramMap.put("tableName",tableName);
        paramMap.put("tableColumns",columns);
        paramMap.put("created",configUtils.getCreated());
        paramMap.put("limit",limit);

        paramMap.put("extraWhere", extraWhere.contains("#{nativeName}") ? extraWhere.replace("#{nativeName}",configUtils.getCurrentNativeName()):extraWhere);

        return ministerialLogDao.findByType(paramMap);
        //getSql(paramMap);
        //return null;
    }

    @Override
    public List<Map> getBusinessDatasByParam(MinisterialDataType dataType,Map paramMap){
        Class entityClass = dataType.getDataClazz();
        MinisterialEntity entityAnno = (MinisterialEntity)entityClass.getAnnotation(MinisterialEntity.class);
        String tableName = entityAnno.tableName();

        StringBuilder tableColumns = new StringBuilder();
        Field[] fields = entityClass.getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(MinisterialAttr.class)) {
                MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                if (StringUtil.isNotEmpty(resource.DATE_FORMAT())){
                    tableColumns
                            .append("DATE_FORMAT( t1.")
                            .append(resource.column())
                            .append(",'")
                            .append(resource.DATE_FORMAT())
                            .append("') as ")
                            .append(field.getName())
                            .append(",");
                }else{
                    // 子查询就不加t1了
                    if (!resource.isSubQuery()) {
                        tableColumns
                                .append(" t1.");
                    }
                    tableColumns
                            .append(resource.column())
                            .append(" as ")
                            .append(field.getName())
                            .append(",");
                }
            }
        }
        String columns = tableColumns.toString();
        columns = columns.substring(0, columns.length() - 1);

        paramMap.put("dataType",dataType.getCode());
        paramMap.put("tableName",tableName);
        paramMap.put("created",configUtils.getCreated());
        paramMap.put("tableColumns",columns);
        //getSql(paramMap);
        return ministerialLogDao.findByParam(paramMap);
    }

    @Override
    public void saveByType(MinisterialLog ministerialLog, List subList) {
        ministerialLogDao.saveByType(ministerialLog,subList);
    }

    private void getSql(Map<String, Object> paramMap){
        StringBuilder sql = new StringBuilder("select t1.id,"+paramMap.get("tableColumns"));
        sql.append(" FROM " + paramMap.get("tableName") + " t1 where 1=1 " + paramMap.get("extraWhere"));
        sql.append(" AND NOT EXISTS (select 1 from ministerial_log t2 where t1.id =t2.businessId and t2.active=true");
        sql.append(" AND t2.businessType ='" + paramMap.get("tableName")+"')");
        sql.append(" ORDER BY RAND() limit " + paramMap.get("limit") +";");

        logger.error(sql.toString());
    }
}
